/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.hibernate.orm.panache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkiverse.groovy.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.impl.GenerateBridge;
import jakarta.json.bind.annotation.JsonbTransient;
import java.util.stream.Stream;

public abstract class PanacheEntityBase {
    public void persist() {
        JpaOperations.INSTANCE.persist(this);
    }

    public void persistAndFlush() {
        JpaOperations.INSTANCE.persist(this);
        JpaOperations.INSTANCE.flush(this);
    }

    public void delete() {
        JpaOperations.INSTANCE.delete(this);
    }

    @JsonbTransient
    @JsonIgnore
    public boolean isPersistent() {
        return JpaOperations.INSTANCE.isPersistent(this);
    }

    @GenerateBridge(callSuperMethod=true)
    public static void persist(Iterable<?> entities) {
        JpaOperations.INSTANCE.persist(entities);
    }

    @GenerateBridge(callSuperMethod=true)
    public static void persist(Stream<?> entities) {
        JpaOperations.INSTANCE.persist(entities);
    }

    @GenerateBridge(callSuperMethod=true)
    public static void persist(Object firstEntity, Object ... entities) {
        JpaOperations.INSTANCE.persist(firstEntity, entities);
    }
}

