/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.providers;

import io.quarkiverse.loggingjson.Enabled;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.JsonWritingUtils;
import io.quarkiverse.loggingjson.StringBuilderWriter;
import io.quarkiverse.loggingjson.config.Config;
import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.logmanager.ExtLogRecord;

public class StackTraceJsonProvider
implements JsonProvider,
Enabled {
    private final String fieldName;
    private final Config.FieldConfig config;

    public StackTraceJsonProvider(Config.FieldConfig config) {
        this(config, "stackTrace");
    }

    public StackTraceJsonProvider(Config.FieldConfig config, String defaultName) {
        this.config = config;
        this.fieldName = config.fieldName.orElse(defaultName);
    }

    @Override
    public void writeTo(JsonGenerator generator, ExtLogRecord event) throws IOException {
        if (event.getThrown() != null) {
            StringBuilderWriter w = new StringBuilderWriter();
            event.getThrown().printStackTrace(new PrintWriter(w));
            JsonWritingUtils.writeStringField(generator, this.fieldName, w.toString());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled.orElse(true);
    }
}

