/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.config;

import io.quarkiverse.loggingjson.config.ConfigConsole;
import io.quarkiverse.loggingjson.config.ConfigFile;
import io.quarkiverse.loggingjson.config.ConfigSocket;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.log.json")
public interface Config {
    @WithName(value="console")
    public ConfigConsole console();

    @WithName(value="file")
    public ConfigFile file();

    @WithName(value="socket")
    public ConfigSocket socket();

    public FieldsConfig fields();

    @WithDefault(value="false")
    public boolean prettyPrint();

    @WithDefault(value="\n")
    public String recordDelimiter();

    @ConfigDocMapKey(value="field-name")
    @ConfigDocSection
    public Map<String, AdditionalFieldConfig> additionalField();

    @WithDefault(value="DEFAULT")
    public LogFormat logFormat();

    public static enum LogFormat {
        DEFAULT,
        ECS;

    }

    public static enum AdditionalFieldType {
        STRING,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }

    @ConfigGroup
    public static interface AdditionalFieldConfig {
        public String value();

        @WithDefault(value="STRING")
        public AdditionalFieldType type();
    }

    @ConfigGroup
    public static interface ArgumentsConfig {
        public Optional<String> fieldName();

        @WithDefault(value="true")
        public boolean includeStructuredArguments();

        @WithDefault(value="false")
        public boolean includeNonStructuredArguments();

        @WithDefault(value="arg")
        public String nonStructuredArgumentsFieldPrefix();
    }

    @ConfigGroup
    public static interface TimestampField {
        public Optional<String> fieldName();

        @WithDefault(value="default")
        public String dateFormat();

        @WithDefault(value="default")
        public String zoneId();

        public Optional<Boolean> enabled();
    }

    @ConfigGroup
    public static interface MDCConfig {
        public Optional<String> fieldName();

        public Optional<Boolean> enabled();

        @WithDefault(value="false")
        public boolean flatFields();
    }

    @ConfigGroup
    public static interface FieldConfig {
        public Optional<String> fieldName();

        public Optional<Boolean> enabled();
    }

    @ConfigGroup
    public static interface FieldsConfig {
        public ArgumentsConfig arguments();

        public TimestampField timestamp();

        public FieldConfig hostname();

        public FieldConfig sequence();

        public FieldConfig loggerClassName();

        public FieldConfig loggerName();

        public FieldConfig level();

        public FieldConfig message();

        public FieldConfig threadName();

        public FieldConfig threadId();

        public MDCConfig mdc();

        public FieldConfig ndc();

        public FieldConfig processName();

        public FieldConfig processId();

        public FieldConfig stackTrace();

        public FieldConfig errorType();

        public FieldConfig errorMessage();
    }
}

