/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.stdio.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.JsonRPC;
import io.quarkiverse.mcp.server.runtime.McpMessageHandler;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompleteManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.quarkiverse.mcp.server.runtime.config.McpRuntimeConfig;
import io.quarkiverse.mcp.server.stdio.runtime.StdioMcpConnection;
import io.quarkus.runtime.Quarkus;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;

@Singleton
public class StdioMcpMessageHandler
extends McpMessageHandler {
    private static final Logger LOG = Logger.getLogger(StdioMcpMessageHandler.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final TrafficLogger trafficLogger;
    private final Vertx vertx;

    protected StdioMcpMessageHandler(McpRuntimeConfig config, ConnectionManager connectionManager, PromptManagerImpl promptManager, ToolManagerImpl toolManager, ResourceManagerImpl resourceManager, PromptCompletionManagerImpl promptCompleteManager, ResourceTemplateManagerImpl resourceTemplateManager, ResourceTemplateCompleteManagerImpl resourceTemplateCompleteManager, McpMetadata metadata, Vertx vertx) {
        super(config, connectionManager, promptManager, toolManager, resourceManager, promptCompleteManager, resourceTemplateManager, resourceTemplateCompleteManager, metadata);
        this.trafficLogger = config.trafficLogging().enabled() ? new TrafficLogger(config.trafficLogging().textLimit()) : null;
        this.vertx = vertx;
    }

    void initialize(PrintStream stdout, McpRuntimeConfig config) {
        String connectionId = Base64.getUrlEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
        final StdioMcpConnection connection = new StdioMcpConnection(connectionId, config.clientLogging().defaultLevel(), this.trafficLogger, config.autoPingInterval(), stdout, this.vertx);
        final InputStream in = System.in;
        this.executor.submit(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while (true) {
                        line = reader.readLine();
                        if (line != null) break block14;
                        LOG.debug((Object)"EOF received, exiting");
                        Quarkus.asyncExit((int)0);
                        break;
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    {
                        JsonObject message;
                        block14: {
                            reader.close();
                            return;
                        }
                        try {
                            message = new JsonObject(line);
                        }
                        catch (Exception e) {
                            String msg = "Unable to parse the JSON message";
                            LOG.errorf((Throwable)e, msg, new Object[0]);
                            connection.sendError(null, -32700, msg);
                            reader.close();
                            return;
                        }
                        try {
                            if (StdioMcpMessageHandler.this.trafficLogger != null) {
                                StdioMcpMessageHandler.this.trafficLogger.messageReceived(message, (McpConnection)connection);
                            }
                            if (!JsonRPC.validate((JsonObject)message, (Responder)connection)) continue;
                            StdioMcpMessageHandler.this.handle(message, (McpConnection)connection, (Responder)connection, null);
                        }
                        catch (DecodeException e) {
                            String msg = "Unable to parse the JSON message";
                            LOG.errorf((Throwable)e, msg, new Object[0]);
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    LOG.errorf((Throwable)e, "Error reading stdio", new Object[0]);
                    return;
                }
            }
        });
    }
}

