/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quarkus.reactive.h2.client.deployment;

import io.quarkiverse.quarkus.reactive.h2.client.H2PoolCreator;
import io.quarkiverse.quarkus.reactive.h2.client.deployment.H2PoolBuildItem;
import io.quarkiverse.quarkus.reactive.h2.client.runtime.DataSourcesReactiveH2Config;
import io.quarkiverse.quarkus.reactive.h2.client.runtime.H2PoolRecorder;
import io.quarkiverse.quarkus.reactive.h2.client.runtime.H2ServiceBindingConverter;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.devui.Name;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mutiny.jdbcclient.JDBCPool;
import io.vertx.sqlclient.Pool;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

class ReactiveH2ClientProcessor {
    private static final String FEATURE = "reactive-h2-client";
    private static final ParameterizedType POOL_INJECTION_TYPE = ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)H2PoolCreator.class.getName()))}, null);
    private static final AnnotationInstance[] EMPTY_ANNOTATIONS = new AnnotationInstance[0];
    private static final DotName REACTIVE_DATASOURCE = DotName.createSimple(ReactiveDataSource.class);

    ReactiveH2ClientProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<H2PoolBuildItem> h2Pool, BuildProducer<VertxPoolBuildItem> vertxPool, H2PoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveH2Config dataSourcesReactiveH2Config, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE));
        for (String dataSourceName : dataSourcesBuildTimeConfig.dataSources().keySet()) {
            this.createPoolIfDefined(recorder, vertx, eventLoopCount, shutdown, h2Pool, syntheticBeans, dataSourceName, dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveH2Config, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem);
        }
        vertxPool.produce((BuildItem)new VertxPoolBuildItem());
        return new ServiceStartBuildItem(FEATURE);
    }

    @BuildStep
    List<DevServicesDatasourceConfigurationHandlerBuildItem> devDbHandler() {
        return List.of(DevServicesDatasourceConfigurationHandlerBuildItem.reactive((String)"h2"));
    }

    @BuildStep
    void unremoveableBeans(BuildProducer<UnremovableBeanBuildItem> producer) {
        producer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{H2PoolCreator.class}));
    }

    @BuildStep
    void validateBeans(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        HashMap<String, Boolean> seen = new HashMap<String, Boolean>();
        for (BeanInfo beanInfo : validationPhase.getContext().beans().matchBeanTypes((Predicate)new H2PoolCreatorBeanClassPredicate())) {
            TreeSet<Name> qualifiers = new TreeSet<Name>();
            for (AnnotationInstance qualifier : beanInfo.getQualifiers()) {
                qualifiers.add(Name.from((AnnotationInstance)qualifier));
            }
            String qualifiersStr = qualifiers.stream().map(Name::toString).collect(Collectors.joining("_"));
            if (seen.getOrDefault(qualifiersStr, false).booleanValue()) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("There can be at most one bean of type '" + H2PoolCreator.class.getName() + "' for each datasource.")}));
                continue;
            }
            seen.put(qualifiersStr, true);
        }
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{H2ServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("h2"));
    }

    @BuildStep
    void addHealthCheck(Capabilities capabilities, BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!capabilities.isPresent("io.quarkus.smallrye.health")) {
            return;
        }
        if (!this.hasPools(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkiverse.quarkus.reactive.h2.client.runtime.health.ReactiveH2DataSourcesHealthCheck", dataSourcesBuildTimeConfig.healthEnabled()));
    }

    private void createPoolIfDefined(H2PoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<H2PoolBuildItem> h2Pool, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, String dataSourceName, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveH2Config dataSourcesReactiveH2Config, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!ReactiveH2ClientProcessor.isReactiveH2PoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        Function poolFunction = recorder.configureH2Pool(vertx.getVertx(), eventLoopCount.getEventLoopCount(), dataSourceName, dataSourcesRuntimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveH2Config, (ShutdownContext)shutdown);
        h2Pool.produce((BuildItem)new H2PoolBuildItem(dataSourceName, poolFunction));
        SyntheticBeanBuildItem.ExtendedBeanConfigurator h2PoolBeanConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.jdbcclient.JDBCPool.class).defaultBean()).addType(Pool.class)).scope(ApplicationScoped.class)).addInjectionPoint((Type)POOL_INJECTION_TYPE, this.injectionPointAnnotations(dataSourceName))).addInjectionPoint((Type)ClassType.create(DataSourceSupport.class), new AnnotationInstance[0])).createWith(poolFunction).unremovable()).setRuntimeInit();
        ReactiveH2ClientProcessor.addQualifiers(h2PoolBeanConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)h2PoolBeanConfigurator.done());
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mutinyH2PoolConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(JDBCPool.class).defaultBean()).addType(io.vertx.mutiny.sqlclient.Pool.class)).scope(ApplicationScoped.class)).addInjectionPoint((Type)POOL_INJECTION_TYPE, this.injectionPointAnnotations(dataSourceName))).addInjectionPoint((Type)ClassType.create(DataSourceSupport.class), new AnnotationInstance[0])).createWith(recorder.mutinyH2Pool(poolFunction)).unremovable()).setRuntimeInit();
        ReactiveH2ClientProcessor.addQualifiers(mutinyH2PoolConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)mutinyH2PoolConfigurator.done());
    }

    private AnnotationInstance[] injectionPointAnnotations(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return EMPTY_ANNOTATIONS;
        }
        return new AnnotationInstance[]{AnnotationInstance.builder((DotName)REACTIVE_DATASOURCE).add("value", dataSourceName).build()};
    }

    private static boolean isReactiveH2PoolDefined(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, String dataSourceName, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = (DataSourceBuildTimeConfig)dataSourcesBuildTimeConfig.dataSources().get(dataSourceName);
        DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig = dataSourcesReactiveBuildTimeConfig.getDataSourceReactiveBuildTimeConfig(dataSourceName);
        Optional dbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind(), defaultDataSourceDbKindBuildItems, (!DataSourceUtil.isDefault((String)dataSourceName) || dataSourceBuildTimeConfig.devservices().enabled().orElse(dataSourcesBuildTimeConfig.dataSources().isEmpty()) != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        return dbKind.filter(s -> DatabaseKind.isH2((String)s) && dataSourceReactiveBuildTimeConfig.enabled()).isPresent();
    }

    private boolean hasPools(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (ReactiveH2ClientProcessor.isReactiveH2PoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, "<default>", defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return true;
        }
        for (String dataSourceName : dataSourcesBuildTimeConfig.dataSources().keySet()) {
            if (!ReactiveH2ClientProcessor.isReactiveH2PoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) continue;
            return true;
        }
        return false;
    }

    private static void addQualifiers(SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator, String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            configurator.addQualifier(DotNames.DEFAULT);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)dataSourceName).done();
            configurator.addQualifier().annotation(ReactiveDataSource.class).addValue("value", (Object)dataSourceName).done();
        }
    }

    private static class H2PoolCreatorBeanClassPredicate
    implements Predicate<Set<Type>> {
        private static final Type H2_POOL_CREATOR = Type.create((DotName)DotName.createSimple((String)H2PoolCreator.class.getName()), (Type.Kind)Type.Kind.CLASS);

        private H2PoolCreatorBeanClassPredicate() {
        }

        @Override
        public boolean test(Set<Type> types) {
            return types.contains(H2_POOL_CREATOR);
        }
    }
}

