/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Types;
import java.lang.reflect.Modifier;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

abstract class AbstractGenerator {
    static final String DEFAULT_PACKAGE = Arc.class.getPackage().getName() + ".generator";

    AbstractGenerator() {
    }

    static String generatedNameFromTarget(String targetPackage, String baseName, String suffix) {
        if (targetPackage == null || targetPackage.isEmpty()) {
            return baseName + suffix;
        }
        return targetPackage.replace('.', '/') + "/" + baseName + suffix;
    }

    protected String getBaseName(BeanInfo bean, String beanClassName) {
        String name = Types.getSimpleName(beanClassName);
        return name.substring(0, name.lastIndexOf("_Bean"));
    }

    protected boolean isReflectionFallbackNeeded(MethodInfo method, String targetPackage) {
        if (Modifier.isPrivate(method.flags())) {
            return true;
        }
        if (Modifier.isProtected(method.flags()) || this.isPackagePrivate(method.flags())) {
            return !DotNames.packageName(method.declaringClass().name()).equals(targetPackage);
        }
        return false;
    }

    protected boolean isReflectionFallbackNeeded(FieldInfo field, String targetPackage) {
        if (Modifier.isPrivate(field.flags())) {
            return true;
        }
        if (Modifier.isProtected(field.flags()) || this.isPackagePrivate(field.flags())) {
            return !DotNames.packageName(field.declaringClass().name()).equals(targetPackage);
        }
        return false;
    }

    protected boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    protected String getPackageName(BeanInfo bean) {
        DotName providerTypeName = bean.isProducerMethod() || bean.isProducerField() ? bean.getDeclaringBean().getProviderType().name() : (bean.getProviderType().kind() == Type.Kind.ARRAY || bean.getProviderType().kind() == Type.Kind.PRIMITIVE ? bean.getImplClazz().name() : bean.getProviderType().name());
        String packageName = DotNames.packageName(providerTypeName);
        if (packageName.startsWith("java.")) {
            packageName = DEFAULT_PACKAGE;
        }
        return packageName;
    }
}

