/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class ObserverInfo
implements InjectionTargetInfo {
    private final BeanInfo declaringBean;
    private final MethodInfo observerMethod;
    private final Injection injection;
    private final MethodParameterInfo eventParameter;
    private final int eventMetadataParameterPosition;
    private final int priority;
    private final boolean isAsync;

    ObserverInfo(BeanInfo declaringBean, MethodInfo observerMethod, Injection injection, boolean isAsync) {
        this.declaringBean = declaringBean;
        this.observerMethod = observerMethod;
        this.injection = injection;
        this.eventParameter = this.initEventParam(observerMethod);
        this.eventMetadataParameterPosition = this.initEventMetadataParam(observerMethod);
        AnnotationInstance priorityAnnotation = observerMethod.annotation(DotNames.PRIORITY);
        this.priority = priorityAnnotation != null && priorityAnnotation.target().equals(this.eventParameter) ? priorityAnnotation.value().asInt() : 2500;
        this.isAsync = isAsync;
    }

    @Override
    public InjectionTargetInfo.TargetKind kind() {
        return InjectionTargetInfo.TargetKind.OBSERVER;
    }

    @Override
    public ObserverInfo asObserver() {
        return this;
    }

    public BeanInfo getDeclaringBean() {
        return this.declaringBean;
    }

    public MethodInfo getObserverMethod() {
        return this.observerMethod;
    }

    public MethodParameterInfo getEventParameter() {
        return this.eventParameter;
    }

    int getEventMetadataParameterPosition() {
        return this.eventMetadataParameterPosition;
    }

    Injection getInjection() {
        return this.injection;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public Reception getReception() {
        AnnotationInstance observesAnnotation = this.isAsync ? this.declaringBean.getDeployment().getAnnotation((AnnotationTarget)this.observerMethod, DotNames.OBSERVES_ASYNC) : this.declaringBean.getDeployment().getAnnotation((AnnotationTarget)this.observerMethod, DotNames.OBSERVES);
        AnnotationValue receptionValue = observesAnnotation.value("notifyObserver");
        if (receptionValue == null) {
            return Reception.ALWAYS;
        }
        return Reception.valueOf((String)receptionValue.asEnum());
    }

    void init(List<Throwable> errors) {
        for (InjectionPointInfo injectionPoint : this.injection.injectionPoints) {
            Beans.resolveInjectionPoint(this.declaringBean.getDeployment(), this, injectionPoint, errors);
        }
    }

    public Type getObservedType() {
        return (Type)this.observerMethod.parameters().get(this.eventParameter.position());
    }

    public Set<AnnotationInstance> getQualifiers() {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : this.declaringBean.getDeployment().getAnnotations((AnnotationTarget)this.observerMethod)) {
            if (!annotation.target().equals(this.eventParameter) || this.declaringBean.getDeployment().getQualifier(annotation.name()) == null) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    int getPriority() {
        return this.priority;
    }

    MethodParameterInfo initEventParam(MethodInfo observerMethod) {
        ArrayList<MethodParameterInfo> eventParams = new ArrayList<MethodParameterInfo>();
        for (AnnotationInstance annotation : this.declaringBean.getDeployment().getAnnotations((AnnotationTarget)observerMethod)) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind() || !annotation.name().equals((Object)DotNames.OBSERVES) && !annotation.name().equals((Object)DotNames.OBSERVES_ASYNC)) continue;
            eventParams.add(annotation.target().asMethodParameter());
        }
        if (eventParams.isEmpty()) {
            throw new DefinitionException("No event parameters found for " + observerMethod);
        }
        if (eventParams.size() > 1) {
            throw new DefinitionException("Multiple event parameters found for " + observerMethod);
        }
        return (MethodParameterInfo)eventParams.get(0);
    }

    int initEventMetadataParam(MethodInfo observerMethod) {
        ListIterator iterator = observerMethod.parameters().listIterator();
        while (iterator.hasNext()) {
            if (!((Type)iterator.next()).name().equals((Object)DotNames.EVENT_METADATA)) continue;
            return iterator.previousIndex();
        }
        return -1;
    }
}

