/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.DotNames;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public final class Transformation {
    private final AnnotationStore.TransformationContextImpl transformationContext;
    private final List<AnnotationInstance> modified;

    Transformation(AnnotationStore.TransformationContextImpl transformationContext) {
        this.transformationContext = transformationContext;
        this.modified = new ArrayList<AnnotationInstance>(transformationContext.getAnnotations());
    }

    public Transformation add(AnnotationInstance annotation) {
        this.modified.add(annotation);
        return this;
    }

    public Transformation addAll(Collection<AnnotationInstance> annotations) {
        this.modified.addAll(annotations);
        return this;
    }

    public Transformation addAll(AnnotationInstance ... annotations) {
        Collections.addAll(this.modified, annotations);
        return this;
    }

    public Transformation add(Class<? extends Annotation> annotationType, AnnotationValue ... values) {
        this.add(DotNames.create(annotationType.getName()), values);
        return this;
    }

    public Transformation add(DotName name, AnnotationValue ... values) {
        this.add(AnnotationInstance.create((DotName)name, (AnnotationTarget)this.transformationContext.getTarget(), (AnnotationValue[])values));
        return this;
    }

    public Transformation remove(Predicate<AnnotationInstance> predicate) {
        this.modified.removeIf(predicate);
        return this;
    }

    public Transformation removeAll() {
        this.modified.clear();
        return this;
    }

    public void done() {
        this.transformationContext.setAnnotations(this.modified);
    }
}

