/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.BeanCreator;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.QualifierConfigurator;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public abstract class BeanConfiguratorBase<B extends BeanConfiguratorBase<B, T>, T>
implements Consumer<AnnotationInstance> {
    protected final DotName implClazz;
    protected final Set<Type> types;
    protected final Set<AnnotationInstance> qualifiers;
    protected ScopeInfo scope;
    protected Integer alternativePriority;
    protected String name;
    protected Consumer<MethodCreator> creatorConsumer;
    protected Consumer<MethodCreator> destroyerConsumer;
    protected boolean defaultBean;
    protected boolean removable;
    protected final Map<String, Object> params;
    protected Type providerType;
    protected boolean forceApplicationClass;

    protected BeanConfiguratorBase(DotName implClazz) {
        this.implClazz = implClazz;
        this.types = new HashSet<Type>();
        this.qualifiers = new HashSet<AnnotationInstance>();
        this.scope = BuiltinScope.DEPENDENT.getInfo();
        this.removable = true;
        this.params = new HashMap<String, Object>();
    }

    protected abstract B self();

    public B read(BeanConfiguratorBase<?, ?> base) {
        this.types.clear();
        this.types.addAll(base.types);
        this.qualifiers.clear();
        this.qualifiers.addAll(base.qualifiers);
        this.forceApplicationClass = base.forceApplicationClass;
        this.scope(base.scope);
        if (base.alternativePriority != null) {
            this.alternativePriority(base.alternativePriority);
        }
        this.name(base.name);
        this.creator(base.creatorConsumer);
        this.destroyer(base.destroyerConsumer);
        if (base.defaultBean) {
            this.defaultBean();
        }
        this.removable = base.removable;
        this.params.clear();
        this.params.putAll(base.params);
        this.providerType(base.providerType);
        return this.self();
    }

    public B types(Class<?> ... types) {
        for (Class<?> type : types) {
            this.addType(type);
        }
        return this.self();
    }

    public B types(Type ... types) {
        Collections.addAll(this.types, types);
        return this.self();
    }

    public B addType(DotName className) {
        this.types.add(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
        return this.self();
    }

    public B addType(Type type) {
        this.types.add(type);
        return this.self();
    }

    public B addType(Class<?> type) {
        return this.addType(DotName.createSimple((String)type.getName()));
    }

    public B addQualifier(Class<? extends Annotation> annotationClass) {
        return this.addQualifier(DotName.createSimple((String)annotationClass.getName()));
    }

    public B addQualifier(DotName annotationName) {
        return this.addQualifier(AnnotationInstance.create((DotName)annotationName, null, (AnnotationValue[])new AnnotationValue[0]));
    }

    public B addQualifier(AnnotationInstance qualifier) {
        this.qualifiers.add(qualifier);
        return this.self();
    }

    public QualifierConfigurator<B> addQualifier() {
        return new QualifierConfigurator<BeanConfiguratorBase>((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public B qualifiers(AnnotationInstance ... qualifiers) {
        Collections.addAll(this.qualifiers, qualifiers);
        return this.self();
    }

    public B scope(ScopeInfo scope) {
        this.scope = scope;
        return this.self();
    }

    public B scope(Class<? extends Annotation> scope) {
        DotName scopeName = DotName.createSimple((String)scope.getName());
        BuiltinScope builtinScope = BuiltinScope.from(scopeName);
        this.scope = builtinScope != null ? builtinScope.getInfo() : new ScopeInfo(scopeName, scope.isAnnotationPresent(NormalScope.class), scope.isAnnotationPresent(Inherited.class));
        return this.self();
    }

    public B name(String name) {
        this.name = name;
        return this.self();
    }

    public B named(String name) {
        return (B)((BeanConfiguratorBase)((BeanConfiguratorBase)this.name(name)).addQualifier().annotation(DotNames.NAMED).addValue("value", name).done());
    }

    public B defaultBean() {
        this.defaultBean = true;
        return this.self();
    }

    public B unremovable() {
        this.removable = false;
        return this.self();
    }

    public B forceApplicationClass() {
        this.forceApplicationClass = true;
        return this.self();
    }

    public B alternativePriority(int priority) {
        this.alternativePriority = priority;
        return this.self();
    }

    public B param(String name, Class<?> value) {
        this.params.put(name, value);
        return this.self();
    }

    public B param(String name, int value) {
        this.params.put(name, value);
        return this.self();
    }

    public B param(String name, long value) {
        this.params.put(name, value);
        return this.self();
    }

    public B param(String name, double value) {
        this.params.put(name, value);
        return this.self();
    }

    public B param(String name, String value) {
        this.params.put(name, value);
        return this.self();
    }

    public B param(String name, boolean value) {
        this.params.put(name, value);
        return this.self();
    }

    public B providerType(Type providerType) {
        this.providerType = providerType;
        return this.self();
    }

    public <U extends T> B creator(Class<? extends BeanCreator<U>> creatorClazz) {
        return this.creator((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
            ResultHandle creatorHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)creatorClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle[] params = new ResultHandle[]{mc.getMethodParam(0), paramsHandle};
            ResultHandle ret = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanCreator.class, (String)"create", Object.class, (Class[])new Class[]{CreationalContext.class, Map.class}), creatorHandle, params);
            mc.returnValue(ret);
        });
    }

    public <U extends T> B creator(Consumer<MethodCreator> methodCreatorConsumer) {
        this.creatorConsumer = methodCreatorConsumer;
        return (B)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public <U extends T> B destroyer(Class<? extends BeanDestroyer<U>> destroyerClazz) {
        return this.destroyer((MethodCreator mc) -> {
            ResultHandle paramsHandle = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
            ResultHandle destoyerHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)destroyerClazz, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle[] params = new ResultHandle[]{mc.getMethodParam(0), mc.getMethodParam(1), paramsHandle};
            mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanDestroyer.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class, Map.class}), destoyerHandle, params);
            mc.returnValue(null);
        });
    }

    public <U extends T> B destroyer(Consumer<MethodCreator> methodCreatorConsumer) {
        this.destroyerConsumer = methodCreatorConsumer;
        return (B)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    protected static <T> T cast(Object obj) {
        return (T)obj;
    }

    @Override
    public void accept(AnnotationInstance qualifier) {
        this.addQualifier(qualifier);
    }
}

