/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.BeanInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodInfoImpl;
import io.quarkus.arc.processor.bcextensions.ParameterInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;

class ObserverInfoImpl
implements jakarta.enterprise.inject.build.compatible.spi.ObserverInfo {
    private final IndexView jandexIndex;
    private final AllAnnotationOverlays annotationOverlays;
    private final ObserverInfo arcObserverInfo;

    ObserverInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, ObserverInfo arcObserverInfo) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.arcObserverInfo = arcObserverInfo;
    }

    public Type eventType() {
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, this.arcObserverInfo.getObservedType());
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.arcObserverInfo.getQualifiers().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).collect(Collectors.toUnmodifiableList());
    }

    public ClassInfo declaringClass() {
        org.jboss.jandex.ClassInfo jandexClass = this.jandexIndex.getClassByName(this.arcObserverInfo.getBeanClass());
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlays, jandexClass);
    }

    public MethodInfo observerMethod() {
        if (this.arcObserverInfo.isSynthetic()) {
            return null;
        }
        return new MethodInfoImpl(this.jandexIndex, this.annotationOverlays, this.arcObserverInfo.getObserverMethod());
    }

    public ParameterInfo eventParameter() {
        if (this.arcObserverInfo.isSynthetic()) {
            return null;
        }
        MethodParameterInfo jandexParameter = this.arcObserverInfo.getEventParameter();
        return new ParameterInfoImpl(this.jandexIndex, this.annotationOverlays, jandexParameter);
    }

    public BeanInfo bean() {
        if (this.arcObserverInfo.isSynthetic()) {
            return null;
        }
        return BeanInfoImpl.create(this.jandexIndex, this.annotationOverlays, this.arcObserverInfo.getDeclaringBean());
    }

    public boolean isSynthetic() {
        return this.arcObserverInfo.isSynthetic();
    }

    public int priority() {
        return this.arcObserverInfo.getPriority();
    }

    public boolean isAsync() {
        return this.arcObserverInfo.isAsync();
    }

    public Reception reception() {
        return this.arcObserverInfo.getReception();
    }

    public TransactionPhase transactionPhase() {
        return this.arcObserverInfo.getTransactionPhase();
    }

    public String toString() {
        return this.arcObserverInfo.toString();
    }
}

