/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.KotlinDotNames;
import java.lang.reflect.Modifier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class KotlinUtils {
    public static boolean isKotlinClass(ClassInfo clazz) {
        return clazz.hasDeclaredAnnotation(KotlinDotNames.METADATA);
    }

    public static boolean isKotlinMethod(MethodInfo method) {
        return KotlinUtils.isKotlinClass(method.declaringClass());
    }

    public static boolean isKotlinSuspendMethod(MethodInfo method) {
        if (!KotlinUtils.isKotlinMethod(method)) {
            return false;
        }
        if (method.parametersCount() == 0) {
            return false;
        }
        Type lastParameter = method.parameterType(method.parametersCount() - 1);
        return KotlinDotNames.CONTINUATION.equals((Object)lastParameter.name());
    }

    public static boolean isNoninterceptableKotlinMethod(MethodInfo method) {
        return KotlinUtils.isKotlinSuspendMethod(method) && (Modifier.isFinal(method.flags()) || Modifier.isFinal(method.declaringClass().flags()));
    }
}

