/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.InterceptionProxy;
import io.quarkus.arc.InterceptionProxySubclass;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.FieldDescriptors;
import io.quarkus.arc.processor.InterceptionProxyInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.SubclassGenerator;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.interceptor.InvocationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptionProxyGenerator
extends AbstractGenerator {
    private static final String INTERCEPTION_SUBCLASS = "_InterceptionSubclass";
    private final Predicate<DotName> applicationClassPredicate;
    private final IndexView beanArchiveIndex;
    private final AnnotationLiteralProcessor annotationLiterals;
    private final ReflectionRegistration reflectionRegistration;

    InterceptionProxyGenerator(boolean generateSources, Predicate<DotName> applicationClassPredicate, BeanDeployment deployment, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        super(generateSources);
        this.applicationClassPredicate = applicationClassPredicate;
        this.beanArchiveIndex = deployment.getBeanArchiveIndex();
        this.annotationLiterals = annotationLiterals;
        this.reflectionRegistration = reflectionRegistration;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        if (bean.getInterceptionProxy() == null) {
            return Collections.emptyList();
        }
        Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction = className -> {
            if (className.endsWith(INTERCEPTION_SUBCLASS)) {
                return ResourceOutput.Resource.SpecialType.SUBCLASS;
            }
            return null;
        };
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(bean.getBeanClass()), specialTypeFunction, this.generateSources);
        this.createInterceptionProxyProvider(classOutput, bean);
        this.createInterceptionProxy(classOutput, bean);
        this.createInterceptionSubclass(classOutput, bean.getInterceptionProxy(), bytecodeTransformerConsumer, transformUnproxyableClasses);
        return classOutput.getResources();
    }

    static String interceptionProxyProviderName(BeanInfo bean) {
        return bean.getBeanClass().toString() + "_InterceptionProxyProvider_" + bean.getIdentifier();
    }

    private static String interceptionProxyName(BeanInfo bean) {
        return bean.getBeanClass().toString() + "_InterceptionProxy_" + bean.getIdentifier();
    }

    private static String interceptionSubclassName(InterceptionProxyInfo interceptionProxy) {
        return String.valueOf(interceptionProxy.getTargetClass()) + INTERCEPTION_SUBCLASS;
    }

    private void createInterceptionProxyProvider(ClassOutput classOutput, BeanInfo bean) {
        try (ClassCreator clazz = ClassCreator.builder().classOutput(classOutput).className(InterceptionProxyGenerator.interceptionProxyProviderName(bean)).interfaces(new Class[]{Supplier.class, InjectableReferenceProvider.class}).build();){
            MethodCreator get0 = clazz.getMethodCreator("get", Object.class, new Class[0]);
            get0.returnValue(get0.getThis());
            MethodCreator get1 = clazz.getMethodCreator("get", Object.class, new Class[]{CreationalContext.class});
            String targetName = InterceptionProxyGenerator.interceptionProxyName(bean);
            ResultHandle result = get1.newInstance(MethodDescriptor.ofConstructor((Object)targetName, (Object[])new Object[]{CreationalContext.class}), new ResultHandle[]{get1.getMethodParam(0)});
            get1.returnValue(result);
        }
    }

    private void createInterceptionProxy(ClassOutput classOutput, BeanInfo bean) {
        try (ClassCreator clazz = ClassCreator.builder().classOutput(classOutput).className(InterceptionProxyGenerator.interceptionProxyName(bean)).interfaces(new Class[]{InterceptionProxy.class}).build();){
            FieldCreator cc = (FieldCreator)clazz.getFieldCreator("creationalContext", CreationalContext.class).setModifiers(18);
            MethodCreator ctor = clazz.getConstructorCreator(new Class[]{CreationalContext.class});
            ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
            ctor.writeInstanceField(cc.getFieldDescriptor(), ctor.getThis(), ctor.getMethodParam(0));
            ctor.returnVoid();
            MethodCreator create = clazz.getMethodCreator("create", Object.class, new Class[]{Object.class});
            ResultHandle ccHandle = create.readInstanceField(cc.getFieldDescriptor(), create.getThis());
            ResultHandle delegateHandle = create.getMethodParam(0);
            BytecodeCreator isInstance = create.ifFalse(create.instanceOf(delegateHandle, bean.getInterceptionProxy().getTargetClass().toString())).falseBranch();
            isInstance.returnValue(isInstance.newInstance(MethodDescriptor.ofConstructor((Object)InterceptionProxyGenerator.interceptionSubclassName(bean.getInterceptionProxy()), (Object[])new Object[]{CreationalContext.class, Object.class}), new ResultHandle[]{ccHandle, delegateHandle}));
            ResultHandle exceptionMessage = Gizmo.newStringBuilder((BytecodeCreator)create).append("InterceptionProxy for ").append(create.load(bean.toString())).append(" got unknown delegate: ").append(delegateHandle).callToString();
            ResultHandle exception = create.newInstance(MethodDescriptor.ofConstructor(IllegalArgumentException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{exceptionMessage});
            create.throwException(exception);
            create.returnNull();
        }
    }

    private void createInterceptionSubclass(ClassOutput classOutput, InterceptionProxyInfo interceptionProxy, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        String[] stringArray;
        String superClass;
        BeanInfo pseudoBean = interceptionProxy.getPseudoBean();
        ClassInfo pseudoBeanClass = pseudoBean.getImplClazz();
        String pseudoBeanClassName = pseudoBeanClass.name().toString();
        boolean isInterface = pseudoBeanClass.isInterface();
        String string = superClass = isInterface ? Object.class.getName() : pseudoBeanClassName;
        if (isInterface) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = pseudoBeanClassName;
            stringArray = stringArray2;
            stringArray2[1] = InterceptionProxySubclass.class.getName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = InterceptionProxySubclass.class.getName();
        }
        String[] interfaces = stringArray;
        try (ClassCreator clazz = ClassCreator.builder().classOutput(classOutput).className(InterceptionProxyGenerator.interceptionSubclassName(interceptionProxy)).superClass(superClass).interfaces(interfaces).build();){
            FieldCreator delegate = (FieldCreator)clazz.getFieldCreator("delegate", Object.class).setModifiers(18);
            HashMap<String, ResultHandle> interceptorToResultHandle = new HashMap<String, ResultHandle>();
            HashMap<String, ResultHandle> interceptorInstanceToResultHandle = new HashMap<String, ResultHandle>();
            MethodCreator ctor = clazz.getConstructorCreator(new Class[]{CreationalContext.class, Object.class});
            ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClass, (String[])new String[0]), ctor.getThis(), new ResultHandle[0]);
            ctor.writeInstanceField(delegate.getFieldDescriptor(), ctor.getThis(), ctor.getMethodParam(1));
            ResultHandle arc = ctor.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle creationalContextHandle = ctor.getMethodParam(0);
            for (InterceptorInfo interceptorInfo : pseudoBean.getBoundInterceptors()) {
                ResultHandle interceptorBean = ctor.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_BEAN, arc, new ResultHandle[]{ctor.load(interceptorInfo.getIdentifier())});
                interceptorToResultHandle.put(interceptorInfo.getIdentifier(), interceptorBean);
                ResultHandle creationalContext = ctor.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{creationalContextHandle});
                ResultHandle interceptorInstance = ctor.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, interceptorBean, new ResultHandle[]{creationalContext});
                interceptorInstanceToResultHandle.put(interceptorInfo.getIdentifier(), interceptorInstance);
            }
            HashMap<MethodDescriptor, MethodDescriptor> forwardingMethods = new HashMap<MethodDescriptor, MethodDescriptor>();
            for (MethodInfo method : pseudoBean.getInterceptedMethods().keySet()) {
                forwardingMethods.put(MethodDescriptor.of((MethodInfo)method), SubclassGenerator.createForwardingMethod(clazz, pseudoBeanClassName, method));
            }
            FieldCreator fieldCreator = (FieldCreator)clazz.getFieldCreator("arc$constructed", Boolean.TYPE).setModifiers(18);
            SubclassGenerator.IntegerHolder chainIdx = new SubclassGenerator.IntegerHolder();
            SubclassGenerator.IntegerHolder bindingIdx = new SubclassGenerator.IntegerHolder();
            HashMap<List<InterceptorInfo>, String> interceptorChainKeys = new HashMap<List<InterceptorInfo>, String>();
            HashMap<Set<AnnotationInstanceEquivalenceProxy>, String> bindingKeys = new HashMap<Set<AnnotationInstanceEquivalenceProxy>, String>();
            ResultHandle interceptorChainMap = ctor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle bindingsMap = ctor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            HashMap<AnnotationInstanceEquivalenceProxy, ResultHandle> bindingsLiterals = new HashMap<AnnotationInstanceEquivalenceProxy, ResultHandle>();
            Function<Set<AnnotationInstanceEquivalenceProxy>, String> bindingsFun = SubclassGenerator.createBindingsFun(bindingIdx, ctor, bindingsMap, bindingsLiterals, pseudoBean, this.annotationLiterals);
            Function<List<InterceptorInfo>, String> interceptorChainKeysFun = SubclassGenerator.createInterceptorChainKeysFun(chainIdx, ctor, interceptorChainMap, interceptorInstanceToResultHandle, interceptorToResultHandle);
            int methodIdx = 1;
            for (BeanInfo.InterceptionInfo interception : pseudoBean.getInterceptedMethods().values()) {
                clazz.getFieldCreator("arc$" + methodIdx++, InterceptedMethodMetadata.class.getName()).setModifiers(2);
                interceptorChainKeys.computeIfAbsent(interception.interceptors, interceptorChainKeysFun);
                bindingKeys.computeIfAbsent(interception.bindingsEquivalenceProxies(), bindingsFun);
            }
            int group = 0;
            int groupLimit = 30;
            MethodCreator initMetadataMethod = null;
            HashMap<String, ResultHandle> chainHandles = new HashMap<String, ResultHandle>();
            HashMap<String, ResultHandle> bindingsHandles = new HashMap<String, ResultHandle>();
            methodIdx = 1;
            for (MethodInfo method : pseudoBean.getInterceptedMethods().keySet()) {
                ResultHandle[] superParamHandles;
                if (initMetadataMethod == null || methodIdx >= group * groupLimit) {
                    if (initMetadataMethod != null) {
                        initMetadataMethod.returnVoid();
                        initMetadataMethod.close();
                        ctor.invokeVirtualMethod(initMetadataMethod.getMethodDescriptor(), ctor.getThis(), new ResultHandle[]{interceptorChainMap, bindingsMap});
                    }
                    initMetadataMethod = (MethodCreator)clazz.getMethodCreator("arc$initMetadata" + group++, Void.TYPE, new Class[]{Map.class, Map.class}).setModifiers(2);
                    chainHandles.clear();
                    bindingsHandles.clear();
                }
                MethodDescriptor methodDescriptor = MethodDescriptor.of((MethodInfo)method);
                BeanInfo.InterceptionInfo interception = pseudoBean.getInterceptedMethods().get(method);
                MethodDescriptor forwardDescriptor = (MethodDescriptor)forwardingMethods.get(methodDescriptor);
                List parameters = method.parameterTypes();
                MethodCreator initMetadataMethodFinal = initMetadataMethod;
                String interceptorChainKey = (String)interceptorChainKeys.get(interception.interceptors);
                ResultHandle chainHandle = chainHandles.computeIfAbsent(interceptorChainKey, ignored -> initMetadataMethodFinal.invokeInterfaceMethod(MethodDescriptors.MAP_GET, initMetadataMethodFinal.getMethodParam(0), new ResultHandle[]{initMetadataMethodFinal.load(interceptorChainKey)}));
                ResultHandle[] paramsHandles = new ResultHandle[3];
                paramsHandles[0] = initMetadataMethod.loadClass(pseudoBeanClassName);
                paramsHandles[1] = initMetadataMethod.load(method.name());
                if (!parameters.isEmpty()) {
                    ResultHandle paramsArray = initMetadataMethod.newArray(Class.class, initMetadataMethod.load(parameters.size()));
                    ListIterator iterator = parameters.listIterator();
                    while (iterator.hasNext()) {
                        initMetadataMethod.writeArrayValue(paramsArray, iterator.nextIndex(), initMetadataMethod.loadClass(((Type)iterator.next()).name().toString()));
                    }
                    paramsHandles[2] = paramsArray;
                } else {
                    paramsHandles[2] = initMetadataMethod.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY);
                }
                ResultHandle methodHandle = initMetadataMethod.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_METHOD, paramsHandles);
                String bindingKey = (String)bindingKeys.get(interception.bindingsEquivalenceProxies());
                ResultHandle bindingsHandle = bindingsHandles.computeIfAbsent(bindingKey, ignored -> initMetadataMethodFinal.invokeInterfaceMethod(MethodDescriptors.MAP_GET, initMetadataMethodFinal.getMethodParam(1), new ResultHandle[]{initMetadataMethodFinal.load(bindingKey)}));
                FunctionCreator func = initMetadataMethod.createFunction(BiFunction.class);
                BytecodeCreator funcBytecode = func.getBytecode();
                ResultHandle targetHandle = funcBytecode.getMethodParam(0);
                ResultHandle ctxHandle = funcBytecode.getMethodParam(1);
                if (parameters.isEmpty()) {
                    superParamHandles = new ResultHandle[]{};
                } else {
                    superParamHandles = new ResultHandle[parameters.size()];
                    ResultHandle ctxParamsHandle = funcBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationContext.class, (String)"getParameters", Object[].class, (Class[])new Class[0]), ctxHandle, new ResultHandle[0]);
                    for (int i = 0; i < superParamHandles.length; ++i) {
                        superParamHandles[i] = funcBytecode.readArrayValue(ctxParamsHandle, i);
                    }
                }
                ResultHandle superResult = method.declaringClass().isInterface() ? funcBytecode.invokeInterfaceMethod(methodDescriptor, targetHandle, superParamHandles) : funcBytecode.invokeVirtualMethod(methodDescriptor, targetHandle, superParamHandles);
                funcBytecode.returnValue(superResult != null ? superResult : funcBytecode.loadNull());
                ResultHandle aroundForwardFun = func.getInstance();
                ResultHandle methodMetadataHandle = initMetadataMethod.newInstance(MethodDescriptors.INTERCEPTED_METHOD_METADATA_CONSTRUCTOR, new ResultHandle[]{chainHandle, methodHandle, bindingsHandle, aroundForwardFun});
                FieldDescriptor metadataField = FieldDescriptor.of((String)clazz.getClassName(), (String)("arc$" + methodIdx++), (String)InterceptedMethodMetadata.class.getName());
                initMetadataMethod.writeInstanceField(metadataField, initMetadataMethod.getThis(), methodMetadataHandle);
                this.reflectionRegistration.registerMethod(method);
                SubclassGenerator.createInterceptedMethod(method, clazz, metadataField, fieldCreator.getFieldDescriptor(), forwardDescriptor, bc -> bc.readInstanceField(delegate.getFieldDescriptor(), bc.getThis()));
            }
            if (initMetadataMethod != null) {
                initMetadataMethod.returnVoid();
                ctor.invokeVirtualMethod(initMetadataMethod.getMethodDescriptor(), ctor.getThis(), new ResultHandle[]{interceptorChainMap, bindingsMap});
            }
            ctor.writeInstanceField(fieldCreator.getFieldDescriptor(), ctor.getThis(), ctor.load(true));
            ctor.returnVoid();
            MethodCreator getDelegate = clazz.getMethodCreator("arc_delegate", Object.class, new Class[0]);
            getDelegate.returnValue(getDelegate.readInstanceField(delegate.getFieldDescriptor(), getDelegate.getThis()));
            Collection<MethodInfo> methodsToForward = this.collectMethodsToForward(pseudoBean, bytecodeTransformerConsumer, transformUnproxyableClasses);
            for (MethodInfo method : methodsToForward) {
                MethodCreator mc = clazz.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
                ResultHandle[] args = new ResultHandle[method.parametersCount()];
                for (int i = 0; i < method.parametersCount(); ++i) {
                    args[i] = mc.getMethodParam(i);
                }
                BytecodeCreator notConstructed = mc.ifFalse(mc.readInstanceField(fieldCreator.getFieldDescriptor(), mc.getThis())).trueBranch();
                notConstructed.returnValue(notConstructed.invokeSpecialMethod(method, notConstructed.getThis(), args));
                ResultHandle dlgt = mc.readInstanceField(delegate.getFieldDescriptor(), mc.getThis());
                ResultHandle result = method.declaringClass().isInterface() ? mc.invokeInterfaceMethod(method, dlgt, args) : mc.invokeVirtualMethod(method, dlgt, args);
                mc.returnValue(result);
            }
        }
    }

    private Collection<MethodInfo> collectMethodsToForward(BeanInfo pseudoBean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        ClassInfo pseudoBeanClass = pseudoBean.getImplClazz();
        HashMap<Methods.MethodKey, MethodInfo> methods = new HashMap<Methods.MethodKey, MethodInfo>();
        HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
        Methods.addDelegatingMethods(this.beanArchiveIndex, pseudoBeanClass, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            for (Map.Entry entry : methodsFromWhichToRemoveFinal.entrySet()) {
                String className = (String)entry.getKey();
                bytecodeTransformerConsumer.accept(new BytecodeTransformer(className, new Methods.RemoveFinalFromMethod((Set)entry.getValue())));
            }
        }
        for (MethodInfo interceptedMethod : pseudoBean.getInterceptedMethods().keySet()) {
            methods.remove(new Methods.MethodKey(interceptedMethod));
        }
        return methods.values();
    }
}

