/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.InterceptionProxy;
import io.quarkus.arc.InterceptionProxySubclass;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.FieldDescs;
import io.quarkus.arc.processor.Grouping;
import io.quarkus.arc.processor.InterceptionProxyInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.SubclassGenerator;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.interceptor.InvocationContext;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.jandex.gizmo2.StringBuilderGen;

public class InterceptionProxyGenerator
extends AbstractGenerator {
    private static final String INTERCEPTION_SUBCLASS = "_InterceptionSubclass";
    private final Predicate<DotName> applicationClassPredicate;
    private final IndexView beanArchiveIndex;
    private final AnnotationLiteralProcessor annotationLiterals;

    InterceptionProxyGenerator(boolean generateSources, Predicate<DotName> applicationClassPredicate, BeanDeployment deployment, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        super(generateSources, reflectionRegistration);
        this.applicationClassPredicate = applicationClassPredicate;
        this.beanArchiveIndex = deployment.getBeanArchiveIndex();
        this.annotationLiterals = annotationLiterals;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        if (bean.getInterceptionProxy() == null) {
            return Collections.emptyList();
        }
        Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction = className -> {
            if (className.endsWith(INTERCEPTION_SUBCLASS)) {
                return ResourceOutput.Resource.SpecialType.SUBCLASS;
            }
            return null;
        };
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(bean.getBeanClass()), specialTypeFunction, this.generateSources);
        Gizmo gizmo = InterceptionProxyGenerator.gizmo(classOutput);
        this.createInterceptionProxyProvider(gizmo, bean);
        this.createInterceptionProxy(gizmo, bean);
        this.createInterceptionSubclass(gizmo, bean.getInterceptionProxy(), bytecodeTransformerConsumer, transformUnproxyableClasses);
        return classOutput.getResources();
    }

    static String interceptionProxyProviderName(BeanInfo bean) {
        return bean.getBeanClass().toString() + "_InterceptionProxyProvider_" + bean.getIdentifier();
    }

    private static String interceptionProxyName(BeanInfo bean) {
        return bean.getBeanClass().toString() + "_InterceptionProxy_" + bean.getIdentifier();
    }

    private static String interceptionSubclassName(InterceptionProxyInfo interceptionProxy) {
        return String.valueOf(interceptionProxy.getTargetClass()) + INTERCEPTION_SUBCLASS;
    }

    private void createInterceptionProxyProvider(Gizmo gizmo, BeanInfo bean) {
        gizmo.class_(InterceptionProxyGenerator.interceptionProxyProviderName(bean), cc -> {
            cc.implements_(Supplier.class);
            cc.implements_(InjectableReferenceProvider.class);
            cc.defaultConstructor();
            cc.method("get", mc -> {
                mc.public_();
                mc.returning(Object.class);
                mc.body(bc -> bc.return_((Expr)cc.this_()));
            });
            cc.method("get", mc -> {
                mc.public_();
                mc.returning(Object.class);
                ParamVar creationalContext = mc.parameter("creationalContext", CreationalContext.class);
                mc.body(bc -> {
                    ConstructorDesc ctor = ConstructorDesc.of((ClassDesc)ClassDesc.of(InterceptionProxyGenerator.interceptionProxyName(bean)), (ClassDesc[])new ClassDesc[]{ClassDesc.of(CreationalContext.class.getName())});
                    bc.return_(bc.new_(ctor, (Expr)creationalContext));
                });
            });
        });
    }

    private void createInterceptionProxy(Gizmo gizmo, BeanInfo bean) {
        gizmo.class_(InterceptionProxyGenerator.interceptionProxyName(bean), cc -> {
            cc.implements_(InterceptionProxy.class);
            FieldDesc ccField = cc.field("creationalContext", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(CreationalContext.class);
            });
            cc.constructor(mc -> {
                mc.public_();
                ParamVar ccParam = mc.parameter("creationalContext", CreationalContext.class);
                mc.body(bc -> {
                    bc.invokeSpecial(ConstructorDesc.of(Object.class, (Class[])new Class[0]), (Expr)cc.this_());
                    bc.set((Assignable)cc.this_().field(ccField), (Expr)ccParam);
                    bc.return_();
                });
            });
            cc.method("create", mc -> {
                mc.public_();
                mc.returning(Object.class);
                ParamVar delegate = mc.parameter("delegate", Object.class);
                mc.body(b0 -> {
                    InterceptionProxyInfo interceptionProxy = bean.getInterceptionProxy();
                    b0.ifInstanceOf((Expr)delegate, Jandex2Gizmo.classDescOf((DotName)interceptionProxy.getTargetClass()), (b1, ignored) -> {
                        ConstructorDesc ctor = ConstructorDesc.of((ClassDesc)ClassDesc.of(InterceptionProxyGenerator.interceptionSubclassName(interceptionProxy)), (Class[])new Class[]{CreationalContext.class, Object.class});
                        b1.return_(b1.new_(ctor, (Expr)cc.this_().field(ccField), (Expr)delegate));
                    });
                    Expr err = StringBuilderGen.ofNew((BlockCreator)b0).append("InterceptionProxy for ").append(bean.toString()).append(" got unknown delegate: ").append((Expr)delegate).toString_();
                    b0.throw_(IllegalArgumentException.class, err);
                });
            });
        });
    }

    private void createInterceptionSubclass(Gizmo gizmo, InterceptionProxyInfo interceptionProxy, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        BeanInfo pseudoBean = interceptionProxy.getPseudoBean();
        ClassDesc pseudoBeanClass = Jandex2Gizmo.classDescOf((ClassInfo)pseudoBean.getImplClazz());
        boolean implementingInterface = pseudoBean.getImplClazz().isInterface();
        CodeGenInfo info = this.preprocess(pseudoBean);
        ClassDesc superClass = implementingInterface ? ConstantDescs.CD_Object : pseudoBeanClass;
        gizmo.class_(InterceptionProxyGenerator.interceptionSubclassName(interceptionProxy), cc -> {
            cc.extends_(superClass);
            if (implementingInterface) {
                cc.implements_(pseudoBeanClass);
            }
            cc.implements_(InterceptionProxySubclass.class);
            FieldDesc delegateField = cc.field("delegate", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(pseudoBeanClass);
            });
            FieldDesc constructedField = cc.field("arc$constructed", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Boolean.TYPE);
            });
            HashMap<List<InterceptorInfo>, String> interceptorChainKeys = new HashMap<List<InterceptorInfo>, String>();
            HashMap<Set<AnnotationInstanceEquivalenceProxy>, String> bindingKeys = new HashMap<Set<AnnotationInstanceEquivalenceProxy>, String>();
            HashMap<MethodDesc, MethodDesc> forwardingMethods = new HashMap<MethodDesc, MethodDesc>();
            for (InterceptedMethod interceptedMethod : info.interceptedMethods()) {
                MethodInfo method = interceptedMethod.method();
                MethodDesc forwardDesc = SubclassGenerator.createForwardingMethod(cc, pseudoBeanClass, method, implementingInterface);
                forwardingMethods.put(Jandex2Gizmo.methodDescOf((MethodInfo)method), forwardDesc);
            }
            cc.constructor(mc -> {
                mc.public_();
                ParamVar ccParam = mc.parameter("creationalContext", CreationalContext.class);
                ParamVar delegateParam = mc.parameter("delegate", Object.class);
                mc.body(bc -> {
                    bc.invokeSpecial(ConstructorDesc.of((ClassDesc)superClass), (Expr)cc.this_());
                    bc.set((Assignable)cc.this_().field(delegateField), bc.cast((Expr)delegateParam, pseudoBeanClass));
                    LocalVar arc = bc.localVar("arc", bc.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER));
                    HashMap<String, LocalVar> interceptorBeanToLocalVar = new HashMap<String, LocalVar>();
                    HashMap<String, LocalVar> interceptorInstanceToLocalVar = new HashMap<String, LocalVar>();
                    for (int i = 0; i < info.boundInterceptors().size(); ++i) {
                        InterceptorInfo interceptorInfo = info.boundInterceptors().get(i);
                        String id = interceptorInfo.getIdentifier();
                        LocalVar interceptorBean = bc.localVar("interceptorBean_" + i, bc.invokeInterface(MethodDescs.ARC_CONTAINER_BEAN, (Expr)arc, (Expr)Const.of((String)id)));
                        interceptorBeanToLocalVar.put(id, interceptorBean);
                        Expr ccChild = bc.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD, (Expr)ccParam);
                        LocalVar interceptorInstance = bc.localVar("interceptorInstance_" + i, bc.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)interceptorBean, ccChild));
                        interceptorInstanceToLocalVar.put(id, interceptorInstance);
                    }
                    LocalVar interceptorChainMap = bc.localVar("interceptorChainMap", bc.new_(HashMap.class));
                    LocalVar bindingsMap = bc.localVar("bindingsMap", bc.new_(HashMap.class));
                    SubclassGenerator.IntegerHolder chainIdx = new SubclassGenerator.IntegerHolder();
                    SubclassGenerator.IntegerHolder bindingIdx = new SubclassGenerator.IntegerHolder();
                    HashMap<AnnotationInstanceEquivalenceProxy, Expr> bindingsLiterals = new HashMap<AnnotationInstanceEquivalenceProxy, Expr>();
                    Function<Set<AnnotationInstanceEquivalenceProxy>, String> bindingsFun = SubclassGenerator.createBindingsFun(bindingIdx, bc, (Expr)bindingsMap, bindingsLiterals, pseudoBean, this.annotationLiterals);
                    Function<List<InterceptorInfo>, String> interceptorChainKeysFun = SubclassGenerator.createInterceptorChainKeysFun(chainIdx, bc, (Expr)interceptorChainMap, interceptorInstanceToLocalVar, interceptorBeanToLocalVar);
                    for (InterceptedMethod interceptedMethod : info.interceptedMethods()) {
                        BeanInfo.InterceptionInfo interception = interceptedMethod.interception();
                        cc.field("arc$" + interceptedMethod.index, fc -> {
                            fc.private_();
                            fc.setType(InterceptedMethodMetadata.class);
                        });
                        interceptorChainKeys.computeIfAbsent(interception.interceptors, interceptorChainKeysFun);
                        bindingKeys.computeIfAbsent(interception.bindingsEquivalenceProxies(), bindingsFun);
                    }
                    for (MethodGroup group : info.methodGroups()) {
                        ClassMethodDesc desc = ClassMethodDesc.of((ClassDesc)cc.type(), (String)("arc$initMetadata" + group.id()), Void.TYPE, (Class[])new Class[]{Map.class, Map.class});
                        bc.invokeVirtual((MethodDesc)desc, (Expr)cc.this_(), (Expr)interceptorChainMap, (Expr)bindingsMap);
                    }
                    bc.set((Assignable)cc.this_().field(constructedField), Const.of((boolean)true));
                    bc.return_();
                });
            });
            for (MethodGroup group : info.methodGroups()) {
                this.createInitMetadataMethod((ClassCreator)cc, pseudoBeanClass, implementingInterface, constructedField, delegateField, group, (Map<MethodDesc, MethodDesc>)forwardingMethods, (Map<List<InterceptorInfo>, String>)interceptorChainKeys, (Map<Set<AnnotationInstanceEquivalenceProxy>, String>)bindingKeys);
            }
            cc.method("arc_delegate", mc -> {
                mc.public_();
                mc.returning(Object.class);
                mc.body(bc -> bc.return_((Expr)cc.this_().field(delegateField)));
            });
            Collection<MethodInfo> methodsToForward = this.collectMethodsToForward(pseudoBean, bytecodeTransformerConsumer, transformUnproxyableClasses);
            for (MethodInfo method : methodsToForward) {
                MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                cc.method(methodDesc, mc -> {
                    mc.public_();
                    ArrayList<ParamVar> params = new ArrayList<ParamVar>(method.parametersCount());
                    for (MethodParameterInfo param : method.parameters()) {
                        params.add(mc.parameter(param.nameOrDefault()));
                    }
                    mc.body(b0 -> {
                        if (!superClass.equals(ConstantDescs.CD_Object)) {
                            b0.ifNot((Expr)cc.this_().field(constructedField), b1 -> {
                                if (method.isAbstract()) {
                                    b1.throw_(IllegalStateException.class, "Cannot invoke abstract method");
                                } else {
                                    ClassMethodDesc superMethod = ClassMethodDesc.of((ClassDesc)pseudoBeanClass, (String)methodDesc.name(), (MethodTypeDesc)methodDesc.type());
                                    b1.return_(b1.invokeSpecial((MethodDesc)superMethod, (Expr)cc.this_(), params));
                                }
                            });
                        }
                        b0.return_(method.declaringClass().isInterface() ? b0.invokeInterface(methodDesc, (Expr)cc.this_().field(delegateField), params) : b0.invokeVirtual(methodDesc, (Expr)cc.this_().field(delegateField), params));
                    });
                });
            }
        });
    }

    private void createInitMetadataMethod(ClassCreator cc, ClassDesc pseudoBeanClass, boolean isInterface, FieldDesc constructedField, FieldDesc delegateField, MethodGroup group, Map<MethodDesc, MethodDesc> forwardingMethods, Map<List<InterceptorInfo>, String> interceptorChainKeys, Map<Set<AnnotationInstanceEquivalenceProxy>, String> bindingKeys) {
        cc.method("arc$initMetadata" + group.id(), mc -> {
            mc.private_();
            mc.returning(Void.TYPE);
            ParamVar interceptorChainMapParam = mc.parameter("interceptorChainMap", Map.class);
            ParamVar bindingsMapParam = mc.parameter("bindingsMap", Map.class);
            mc.body(bc -> {
                HashMap<String, LocalVar> chains = new HashMap<String, LocalVar>();
                HashMap<String, LocalVar> bindings = new HashMap<String, LocalVar>();
                for (InterceptedMethod interceptedMethod : group.interceptedMethods()) {
                    MethodInfo method = interceptedMethod.method();
                    MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                    BeanInfo.InterceptionInfo interception = interceptedMethod.interception();
                    List parameters = method.parameterTypes();
                    String interceptorChainKey = (String)interceptorChainKeys.get(interception.interceptors);
                    LocalVar chainArg = chains.computeIfAbsent(interceptorChainKey, ignored -> bc.localVar("interceptorChain", bc.withMap((Expr)interceptorChainMapParam).get((Expr)Const.of((String)interceptorChainKey))));
                    Expr[] args = new Expr[3];
                    args[0] = Const.of((ClassDesc)pseudoBeanClass);
                    args[1] = Const.of((String)method.name());
                    if (!parameters.isEmpty()) {
                        LocalVar paramTypes = bc.localVar("paramTypes", bc.newEmptyArray(Class.class, parameters.size()));
                        for (int i = 0; i < parameters.size(); ++i) {
                            bc.set(paramTypes.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)((Type)parameters.get(i)))));
                        }
                        args[2] = paramTypes;
                    } else {
                        args[2] = bc.getStaticField(FieldDescs.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY);
                    }
                    Expr methodArg = bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_METHOD, args);
                    String bindingKey = (String)bindingKeys.get(interception.bindingsEquivalenceProxies());
                    LocalVar bindingsArg = bindings.computeIfAbsent(bindingKey, ignored -> bc.localVar("bindings", bc.withMap((Expr)bindingsMapParam).get((Expr)Const.of((String)bindingKey))));
                    Expr forwardFunArg = bc.lambda(BiFunction.class, lc -> {
                        ParamVar target = lc.parameter("target", 0);
                        ParamVar ctx = lc.parameter("ctx", 1);
                        lc.body(lbc -> {
                            Expr[] superArgs;
                            if (parameters.isEmpty()) {
                                superArgs = new Expr[]{};
                            } else {
                                LocalVar ctxArgs = lbc.localVar("args", lbc.invokeInterface(MethodDesc.of(InvocationContext.class, (String)"getParameters", Object[].class, (Class[])new Class[0]), (Expr)ctx));
                                superArgs = new Expr[parameters.size()];
                                for (int i = 0; i < parameters.size(); ++i) {
                                    superArgs[i] = ctxArgs.elem(i);
                                }
                            }
                            Expr superResult = method.declaringClass().isInterface() ? lbc.invokeInterface(methodDesc, (Expr)target, superArgs) : lbc.invokeVirtual(methodDesc, (Expr)target, superArgs);
                            lbc.return_(superResult);
                        });
                    });
                    Expr methodMetadata = bc.new_(MethodDescs.INTERCEPTED_METHOD_METADATA_CONSTRUCTOR, new Expr[]{chainArg, methodArg, bindingsArg, forwardFunArg});
                    FieldDesc metadataField = FieldDesc.of((ClassDesc)cc.type(), (String)("arc$" + interceptedMethod.index), InterceptedMethodMetadata.class);
                    bc.set((Assignable)cc.this_().field(metadataField), methodMetadata);
                    this.reflectionRegistration.registerMethod(method);
                    MethodDesc forwardDescriptor = (MethodDesc)forwardingMethods.get(methodDesc);
                    SubclassGenerator.createInterceptedMethod(method, cc, metadataField, constructedField, forwardDescriptor, () -> cc.this_().field(delegateField));
                }
                bc.return_();
            });
        });
    }

    private Collection<MethodInfo> collectMethodsToForward(BeanInfo pseudoBean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        ClassInfo pseudoBeanClass = pseudoBean.getImplClazz();
        HashMap<Methods.MethodKey, MethodInfo> methods = new HashMap<Methods.MethodKey, MethodInfo>();
        HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
        Methods.addDelegatingMethods(this.beanArchiveIndex, pseudoBeanClass, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            for (Map.Entry entry : methodsFromWhichToRemoveFinal.entrySet()) {
                String className = (String)entry.getKey();
                bytecodeTransformerConsumer.accept(new BytecodeTransformer(className, new Methods.RemoveFinalFromMethod((Set)entry.getValue())));
            }
        }
        for (MethodInfo interceptedMethod : pseudoBean.getInterceptedMethods().keySet()) {
            methods.remove(new Methods.MethodKey(interceptedMethod));
        }
        return methods.values();
    }

    private CodeGenInfo preprocess(BeanInfo pseudoBean) {
        List<InterceptorInfo> boundInterceptors = pseudoBean.getBoundInterceptors();
        SubclassGenerator.IntegerHolder methodIdx = new SubclassGenerator.IntegerHolder();
        ArrayList interceptedMethods = new ArrayList();
        pseudoBean.getInterceptedMethods().forEach((method, interception) -> {
            interceptedMethods.add(new InterceptedMethod(methodIdx.i, (MethodInfo)method, (BeanInfo.InterceptionInfo)interception));
            ++methodIdx.i;
        });
        List<MethodGroup> methodGroups = Grouping.of(interceptedMethods, 30, MethodGroup::new);
        return new CodeGenInfo(List.copyOf(boundInterceptors), List.copyOf(interceptedMethods), List.copyOf(methodGroups));
    }

    record CodeGenInfo(List<InterceptorInfo> boundInterceptors, List<InterceptedMethod> interceptedMethods, List<MethodGroup> methodGroups) {
    }

    record MethodGroup(int id, List<InterceptedMethod> interceptedMethods) {
    }

    record InterceptedMethod(int index, MethodInfo method, BeanInfo.InterceptionInfo interception) {
    }
}

