/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.InstanceMethodCreator;
import io.quarkus.gizmo2.creator.TypeParameterizedCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class ClientProxyGenerator
extends AbstractGenerator {
    static final String CLIENT_PROXY_SUFFIX = "_ClientProxy";
    static final String DELEGATE_METHOD_NAME = "arc$delegate";
    static final String SET_MOCK_METHOD_NAME = "arc$setMock";
    static final String CLEAR_MOCK_METHOD_NAME = "arc$clearMock";
    static final String GET_CONTEXTUAL_INSTANCE_METHOD_NAME = "arc_contextualInstance";
    static final String GET_BEAN = "arc_bean";
    static final String BEAN_FIELD = "bean";
    static final String MOCK_FIELD = "mock";
    static final String CONTEXT_FIELD = "context";
    private final Predicate<DotName> applicationClassPredicate;
    private final boolean mockable;
    private final Set<String> existingClasses;
    private final Set<DotName> singleContextNormalScopes;

    public ClientProxyGenerator(Predicate<DotName> applicationClassPredicate, boolean generateSources, boolean mockable, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Set<DotName> singleContextNormalScopes) {
        super(generateSources, reflectionRegistration);
        this.applicationClassPredicate = applicationClassPredicate;
        this.mockable = mockable;
        this.existingClasses = existingClasses;
        this.singleContextNormalScopes = singleContextNormalScopes;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        if (bean.getDeployment().hasRuntimeDeferredUnproxyableError(bean)) {
            return Collections.emptySet();
        }
        String baseName = this.getBeanBaseName(beanClassName);
        String targetPackage = bean.getClientProxyPackageName();
        String generatedName = ClientProxyGenerator.generatedNameFromTarget(targetPackage, baseName, CLIENT_PROXY_SUFFIX);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(this.getApplicationClassTestName(bean));
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.CLIENT_PROXY : null, this.generateSources);
        Gizmo gizmo = ClientProxyGenerator.gizmo(classOutput);
        this.createClientProxy(gizmo, bean, bytecodeTransformerConsumer, transformUnproxyableClasses, generatedName, targetPackage);
        return classOutput.getResources();
    }

    private void createClientProxy(Gizmo gizmo, BeanInfo bean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses, String generatedName, String targetPackage) {
        Type providerType = bean.getProviderType();
        ClassInfo providerClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), providerType.name());
        ClassDesc providerClassDesc = Jandex2Gizmo.classDescOf((ClassInfo)providerClass);
        boolean isInterface = providerClass.isInterface();
        ClassDesc superClass = isInterface ? ConstantDescs.CD_Object : providerClassDesc;
        gizmo.class_(generatedName, cc -> {
            Jandex2Gizmo.copyTypeParameters((ClassInfo)providerClass, (TypeParameterizedCreator)cc);
            GenericType.OfClass providerGenericType = Jandex2Gizmo.genericTypeOfClass((Type)providerType);
            if (!isInterface) {
                cc.extends_(providerGenericType);
            } else {
                cc.implements_(providerGenericType);
            }
            cc.implements_(ClientProxy.class);
            if (this.mockable) {
                cc.implements_(Mockable.class);
            }
            FieldDesc beanField = cc.field(BEAN_FIELD, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(InjectableBean.class);
            });
            FieldDesc mockField = this.mockable ? cc.field(MOCK_FIELD, fc -> {
                fc.private_();
                fc.volatile_();
                fc.setType(providerClassDesc);
            }) : null;
            Object contextField = BuiltinScope.APPLICATION.is(bean.getScope()) || this.singleContextNormalScopes.contains(bean.getScope().getDotName()) ? cc.field(CONTEXT_FIELD, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(InjectableContext.class);
            }) : null;
            cc.constructor(arg_0 -> ClientProxyGenerator.lambda$createClientProxy$5(superClass, cc, beanField, (FieldDesc)contextField, arg_0));
            MethodDesc delegateMethod = cc.method(DELEGATE_METHOD_NAME, arg_0 -> this.lambda$createClientProxy$8(providerClassDesc, cc, mockField, bean, (FieldDesc)contextField, beanField, arg_0));
            cc.method(GET_CONTEXTUAL_INSTANCE_METHOD_NAME, mc -> {
                mc.public_();
                mc.returning(Object.class);
                mc.body(bc -> bc.return_(bc.invokeVirtual(delegateMethod, (Expr)cc.this_())));
            });
            cc.method(GET_BEAN, mc -> {
                mc.public_();
                mc.returning(InjectableBean.class);
                mc.body(bc -> bc.return_((Expr)cc.this_().field(beanField)));
            });
            if (this.mockable) {
                cc.method(CLEAR_MOCK_METHOD_NAME, mc -> mc.body(bc -> {
                    bc.set((Assignable)cc.this_().field(mockField), Const.ofNull((ClassDesc)mockField.type()));
                    bc.return_();
                }));
                cc.method(SET_MOCK_METHOD_NAME, mc -> {
                    ParamVar mock = mc.parameter(MOCK_FIELD, Object.class);
                    mc.body(bc -> {
                        bc.set((Assignable)cc.this_().field(mockField), (Expr)mock);
                        bc.return_();
                    });
                });
            }
            for (MethodInfo method : this.getDelegatingMethods(bean, bytecodeTransformerConsumer, transformUnproxyableClasses)) {
                MethodDesc originalMethodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                cc.method(method.name(), mc -> {
                    Jandex2Gizmo.copyTypeParameters((MethodInfo)method, (TypeParameterizedCreator)mc);
                    mc.returning(Jandex2Gizmo.genericTypeOf((Type)method.returnType()));
                    ArrayList<ParamVar> params = new ArrayList<ParamVar>();
                    for (MethodParameterInfo param : method.parameters()) {
                        params.add(mc.parameter(param.nameOrDefault(), Jandex2Gizmo.genericTypeOf((Type)param.type())));
                    }
                    for (Type exception : method.exceptions()) {
                        mc.throws_(Jandex2Gizmo.genericTypeOfThrows((Type)exception));
                    }
                    mc.body(bc -> {
                        Expr ret;
                        if (!superClass.equals(ConstantDescs.CD_Object)) {
                            bc.ifNull((Expr)cc.this_().field(beanField), b1 -> {
                                if (method.isAbstract()) {
                                    b1.throw_(IllegalStateException.class, "Cannot invoke abstract method");
                                } else {
                                    ClassMethodDesc superDesc = ClassMethodDesc.of((ClassDesc)superClass, (String)originalMethodDesc.name(), (MethodTypeDesc)originalMethodDesc.type());
                                    b1.return_(b1.invokeSpecial((MethodDesc)superDesc, (Expr)cc.this_(), params));
                                }
                            });
                        }
                        Supplier<Expr> delegate = () -> bc.invokeVirtual(delegateMethod, (Expr)cc.this_());
                        if (Methods.isObjectToString(method)) {
                            ret = bc.invokeVirtual(originalMethodDesc, delegate.get(), params);
                        } else if (isInterface) {
                            InterfaceMethodDesc virtualMethod = InterfaceMethodDesc.of((ClassDesc)providerClassDesc, (String)originalMethodDesc.name(), (MethodTypeDesc)originalMethodDesc.type());
                            ret = bc.invokeInterface((MethodDesc)virtualMethod, delegate.get(), params);
                        } else if (this.isReflectionFallbackNeeded(method, targetPackage)) {
                            this.reflectionRegistration.registerMethod(method);
                            Expr paramTypes = bc.newArray(Class.class, method.parameterTypes().stream().map(paramType -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)paramType))).toList());
                            ret = bc.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass())), Const.of((String)method.name()), paramTypes, delegate.get(), bc.newArray(Object.class, params)});
                            if (method.returnType().kind() == Type.Kind.VOID) {
                                ret = Const.ofVoid();
                            }
                        } else {
                            ClassMethodDesc virtualMethod = ClassMethodDesc.of((ClassDesc)providerClassDesc, (String)originalMethodDesc.name(), (MethodTypeDesc)originalMethodDesc.type());
                            ret = bc.invokeVirtual((MethodDesc)virtualMethod, delegate.get(), params);
                        }
                        bc.return_(ret);
                    });
                });
            }
        });
    }

    Collection<MethodInfo> getDelegatingMethods(BeanInfo bean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        HashMap<Methods.MethodKey, MethodInfo> methods = new HashMap<Methods.MethodKey, MethodInfo>();
        IndexView index = bean.getDeployment().getBeanArchiveIndex();
        if (bean.isClassBean()) {
            HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
            ClassInfo classInfo = bean.getTarget().get().asClass();
            this.addDelegatesAndTransformIfNecessary(bytecodeTransformerConsumer, transformUnproxyableClasses, methods, index, methodsFromWhichToRemoveFinal, classInfo);
        } else if (bean.isProducerMethod()) {
            HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
            MethodInfo producerMethod = bean.getTarget().get().asMethod();
            ClassInfo returnTypeClass = IndexClassLookupUtils.getClassByName(index, producerMethod.returnType());
            this.addDelegatesAndTransformIfNecessary(bytecodeTransformerConsumer, transformUnproxyableClasses, methods, index, methodsFromWhichToRemoveFinal, returnTypeClass);
        } else if (bean.isProducerField()) {
            HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
            FieldInfo producerField = bean.getTarget().get().asField();
            ClassInfo fieldClass = IndexClassLookupUtils.getClassByName(index, producerField.type());
            this.addDelegatesAndTransformIfNecessary(bytecodeTransformerConsumer, transformUnproxyableClasses, methods, index, methodsFromWhichToRemoveFinal, fieldClass);
        } else if (bean.isSynthetic()) {
            Methods.addDelegatingMethods(index, bean.getImplClazz(), methods, null, transformUnproxyableClasses);
        }
        return methods.values();
    }

    private void addDelegatesAndTransformIfNecessary(Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses, Map<Methods.MethodKey, MethodInfo> methods, IndexView index, Map<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal, ClassInfo fieldClass) {
        Methods.addDelegatingMethods(index, fieldClass, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            for (Map.Entry<String, Set<Methods.MethodKey>> entry : methodsFromWhichToRemoveFinal.entrySet()) {
                String className = entry.getKey();
                bytecodeTransformerConsumer.accept(new BytecodeTransformer(className, new Methods.RemoveFinalFromMethod(entry.getValue())));
            }
        }
    }

    private DotName getApplicationClassTestName(BeanInfo bean) {
        DotName testedName = bean.isProducerField() ? bean.getTarget().get().asField().type().name() : (bean.isProducerMethod() ? bean.getTarget().get().asMethod().returnType().name() : bean.getBeanClass());
        return testedName;
    }

    private /* synthetic */ void lambda$createClientProxy$8(ClassDesc providerClassDesc, ClassCreator cc, FieldDesc mockField, BeanInfo bean, FieldDesc contextField, FieldDesc beanField, InstanceMethodCreator mc) {
        mc.private_();
        mc.returning(providerClassDesc);
        mc.body(b0 -> {
            if (this.mockable) {
                b0.ifNotNull((Expr)cc.this_().field(mockField), b1 -> b1.return_((Expr)cc.this_().field(mockField)));
            }
            Expr ret = BuiltinScope.APPLICATION.is(bean.getScope()) ? b0.invokeStatic(MethodDescs.CLIENT_PROXIES_GET_APP_SCOPED_DELEGATE, (Expr)cc.this_().field(contextField), (Expr)cc.this_().field(beanField)) : (this.singleContextNormalScopes.contains(bean.getScope().getDotName()) ? b0.invokeStatic(MethodDescs.CLIENT_PROXIES_GET_SINGLE_CONTEXT_DELEGATE, (Expr)cc.this_().field(contextField), (Expr)cc.this_().field(beanField)) : b0.invokeStatic(MethodDescs.CLIENT_PROXIES_GET_DELEGATE, (Expr)cc.this_().field(beanField)));
            b0.return_(ret);
        });
    }

    private static /* synthetic */ void lambda$createClientProxy$5(ClassDesc superClass, ClassCreator cc, FieldDesc beanField, FieldDesc contextField, ConstructorCreator mc) {
        ParamVar id = mc.parameter("id", String.class);
        mc.body(bc -> {
            bc.invokeSpecial(ConstructorDesc.of((ClassDesc)superClass), (Expr)cc.this_());
            LocalVar arc = bc.localVar("arc", bc.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER));
            LocalVar beanVar = bc.localVar(BEAN_FIELD, bc.invokeInterface(MethodDescs.ARC_CONTAINER_BEAN, (Expr)arc, (Expr)id));
            bc.set((Assignable)cc.this_().field(beanField), (Expr)beanVar);
            if (contextField != null) {
                Expr scope = bc.invokeInterface(MethodDescs.INJECTABLE_BEAN_GET_SCOPE, (Expr)beanVar);
                Expr contexts = bc.invokeInterface(MethodDescs.ARC_CONTAINER_GET_CONTEXTS, (Expr)arc, scope);
                bc.set((Assignable)cc.this_().field(contextField), bc.withList(contexts).get(0));
            }
            bc.return_();
        });
    }
}

