/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import io.quarkus.gizmo.TryBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.jandex.DotName;

public class ContextInstancesGenerator
extends AbstractGenerator {
    static final String CONTEXT_INSTANCES_SUFFIX = "_ContextInstances";
    private final BeanDeployment beanDeployment;
    private final Map<DotName, String> scopeToGeneratedName;

    public ContextInstancesGenerator(boolean generateSources, ReflectionRegistration reflectionRegistration, BeanDeployment beanDeployment, Map<DotName, String> scopeToGeneratedName) {
        super(generateSources, reflectionRegistration);
        this.beanDeployment = beanDeployment;
        this.scopeToGeneratedName = scopeToGeneratedName;
    }

    void precomputeGeneratedName(DotName scope) {
        String generatedName = DEFAULT_PACKAGE + "." + this.beanDeployment.name + "_" + scope.toString().replace(".", "_") + CONTEXT_INSTANCES_SUFFIX;
        this.scopeToGeneratedName.put(scope, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(DotName scope) {
        List<BeanInfo> beans = new BeanStream(this.beanDeployment.getBeans()).withScope(scope).collect();
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        String generatedName = this.scopeToGeneratedName.get(scope);
        this.reflectionRegistration.registerMethod(generatedName, "<init>", new String[0]);
        ClassCreator contextInstances = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ContextInstances.class}).build();
        HashMap<String, InstanceAndLock> idToFields = new HashMap<String, InstanceAndLock>();
        int fieldIndex = 0;
        for (BeanInfo bean : beans) {
            String beanIdx = "" + fieldIndex++;
            FieldCreator handleField = (FieldCreator)contextInstances.getFieldCreator(beanIdx, ContextInstanceHandle.class).setModifiers(66);
            FieldCreator lockField = (FieldCreator)contextInstances.getFieldCreator(beanIdx + "l", Lock.class).setModifiers(18);
            idToFields.put(bean.getIdentifier(), new InstanceAndLock(handleField.getFieldDescriptor(), lockField.getFieldDescriptor()));
        }
        MethodCreator constructor = contextInstances.getMethodCreator("<init>", "V", new String[0]);
        constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        for (InstanceAndLock fields : idToFields.values()) {
            constructor.writeInstanceField(fields.lock, constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(ReentrantLock.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
        constructor.returnVoid();
        this.implementComputeIfAbsent(contextInstances, beans, idToFields);
        this.implementGetIfPresent(contextInstances, beans, idToFields);
        this.implementRemove(contextInstances, beans, idToFields);
        this.implementGetAllPresent(contextInstances, idToFields);
        this.implementRemoveEach(contextInstances, idToFields);
        this.implementLockAll(contextInstances, idToFields);
        this.implementUnlockAll(contextInstances, idToFields);
        contextInstances.close();
        return classOutput.getResources();
    }

    private void implementGetAllPresent(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodCreator getAllPresent = (MethodCreator)contextInstances.getMethodCreator("getAllPresent", Set.class, new Class[0]).setModifiers(1);
        getAllPresent.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)contextInstances.getClassName(), (String)"lockAll", Void.TYPE, (Object[])new Object[0]), getAllPresent.getThis(), new ResultHandle[0]);
        ArrayList<ResultHandle> results = new ArrayList<ResultHandle>(idToFields.size());
        for (InstanceAndLock fields : idToFields.values()) {
            results.add(getAllPresent.readInstanceField(fields.instance, getAllPresent.getThis()));
        }
        getAllPresent.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)contextInstances.getClassName(), (String)"unlockAll", Void.TYPE, (Object[])new Object[0]), getAllPresent.getThis(), new ResultHandle[0]);
        ResultHandle ret = getAllPresent.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ResultHandle result : results) {
            getAllPresent.ifNotNull(result).trueBranch().invokeInterfaceMethod(MethodDescriptors.SET_ADD, ret, new ResultHandle[]{result});
        }
        getAllPresent.returnValue(ret);
    }

    private void implementLockAll(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodCreator lockAll = (MethodCreator)contextInstances.getMethodCreator("lockAll", Void.TYPE, new Class[0]).setModifiers(2);
        for (InstanceAndLock fields : idToFields.values()) {
            ResultHandle lock = lockAll.readInstanceField(fields.lock, lockAll.getThis());
            lockAll.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
        }
        lockAll.returnVoid();
    }

    private void implementUnlockAll(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodCreator unlockAll = (MethodCreator)contextInstances.getMethodCreator("unlockAll", Void.TYPE, new Class[0]).setModifiers(2);
        for (InstanceAndLock fields : idToFields.values()) {
            ResultHandle lock = unlockAll.readInstanceField(fields.lock, unlockAll.getThis());
            unlockAll.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
        }
        unlockAll.returnVoid();
    }

    private void implementRemoveEach(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        BytecodeCreator isNotNull;
        MethodCreator removeEach = (MethodCreator)contextInstances.getMethodCreator("removeEach", Void.TYPE, new Class[]{Consumer.class}).setModifiers(1);
        removeEach.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)contextInstances.getClassName(), (String)"lockAll", Void.TYPE, (Object[])new Object[0]), removeEach.getThis(), new ResultHandle[0]);
        ArrayList<ResultHandle> results = new ArrayList<ResultHandle>(idToFields.size());
        for (InstanceAndLock fields : idToFields.values()) {
            ResultHandle copy = removeEach.readInstanceField(fields.instance, removeEach.getThis());
            results.add(copy);
            isNotNull = removeEach.ifNotNull(copy).trueBranch();
            isNotNull.writeInstanceField(fields.instance, isNotNull.getThis(), isNotNull.loadNull());
        }
        removeEach.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)contextInstances.getClassName(), (String)"unlockAll", Void.TYPE, (Object[])new Object[0]), removeEach.getThis(), new ResultHandle[0]);
        BytecodeCreator actionIsNotNull = removeEach.ifNotNull(removeEach.getMethodParam(0)).trueBranch();
        for (ResultHandle result : results) {
            isNotNull = actionIsNotNull.ifNotNull(result).trueBranch();
            isNotNull.invokeInterfaceMethod(MethodDescriptors.CONSUMER_ACCEPT, removeEach.getMethodParam(0), new ResultHandle[]{result});
        }
        removeEach.returnVoid();
    }

    private void implementRemove(ClassCreator contextInstances, List<BeanInfo> beans, Map<String, InstanceAndLock> idToFields) {
        MethodCreator remove = (MethodCreator)contextInstances.getMethodCreator("remove", ContextInstanceHandle.class, new Class[]{String.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = remove.stringSwitch(remove.getMethodParam(0));
        strSwitch.fallThrough();
        for (BeanInfo bean : beans) {
            InstanceAndLock fields = idToFields.get(bean.getIdentifier());
            FieldDescriptor instanceField = fields.instance;
            MethodCreator removeHandle = (MethodCreator)contextInstances.getMethodCreator("r" + instanceField.getName(), ContextInstanceHandle.class, new Class[0]).setModifiers(2);
            ResultHandle lock = removeHandle.readInstanceField(fields.lock, removeHandle.getThis());
            removeHandle.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
            ResultHandle copy = removeHandle.readInstanceField(instanceField, removeHandle.getThis());
            BytecodeCreator isNotNull = removeHandle.ifNotNull(copy).trueBranch();
            isNotNull.writeInstanceField(instanceField, isNotNull.getThis(), isNotNull.loadNull());
            removeHandle.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            removeHandle.returnValue(copy);
            strSwitch.caseOf((Object)bean.getIdentifier(), bc -> bc.returnValue(bc.invokeVirtualMethod(removeHandle.getMethodDescriptor(), bc.getThis(), new ResultHandle[0])));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    private void implementGetIfPresent(ClassCreator contextInstances, List<BeanInfo> beans, Map<String, InstanceAndLock> idToFields) {
        MethodCreator getIfPresent = (MethodCreator)contextInstances.getMethodCreator("getIfPresent", ContextInstanceHandle.class, new Class[]{String.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = getIfPresent.stringSwitch(getIfPresent.getMethodParam(0));
        strSwitch.fallThrough();
        for (BeanInfo bean : beans) {
            strSwitch.caseOf((Object)bean.getIdentifier(), bc -> bc.returnValue(bc.readInstanceField(((InstanceAndLock)idToFields.get((Object)bean.getIdentifier())).instance, bc.getThis())));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    private void implementComputeIfAbsent(ClassCreator contextInstances, List<BeanInfo> beans, Map<String, InstanceAndLock> idToFields) {
        MethodCreator computeIfAbsent = (MethodCreator)contextInstances.getMethodCreator("computeIfAbsent", ContextInstanceHandle.class, new Class[]{String.class, Supplier.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = computeIfAbsent.stringSwitch(computeIfAbsent.getMethodParam(0));
        strSwitch.fallThrough();
        for (BeanInfo bean : beans) {
            InstanceAndLock fields = idToFields.get(bean.getIdentifier());
            MethodCreator compute = (MethodCreator)contextInstances.getMethodCreator("c" + fields.instance.getName(), ContextInstanceHandle.class, new Class[]{Supplier.class}).setModifiers(2);
            ResultHandle copy = compute.readInstanceField(fields.instance, compute.getThis());
            compute.ifNotNull(copy).trueBranch().returnValue(copy);
            ResultHandle lock = compute.readInstanceField(fields.lock, compute.getThis());
            compute.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
            TryBlock tryBlock = compute.tryBlock();
            ResultHandle val = tryBlock.readInstanceField(fields.instance, compute.getThis());
            BytecodeCreator isNull = tryBlock.ifNull(val).trueBranch();
            ResultHandle newVal = isNull.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, compute.getMethodParam(0), new ResultHandle[0]);
            isNull.writeInstanceField(fields.instance, compute.getThis(), newVal);
            tryBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
            catchBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            catchBlock.throwException(catchBlock.getCaughtException());
            compute.returnValue(compute.readInstanceField(fields.instance, compute.getThis()));
            strSwitch.caseOf((Object)bean.getIdentifier(), bc -> bc.returnValue(bc.invokeVirtualMethod(compute.getMethodDescriptor(), bc.getThis(), new ResultHandle[]{bc.getMethodParam(1)})));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    final class InstanceAndLock {
        private final FieldDescriptor instance;
        private final FieldDescriptor lock;

        InstanceAndLock(FieldDescriptor instance, FieldDescriptor lock) {
            this.instance = instance;
            this.lock = lock;
        }

        FieldDescriptor instance() {
            return this.instance;
        }

        FieldDescriptor lock() {
            return this.lock;
        }
    }
}

