/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;

public enum TypeKind {
    BOOLEAN(io.github.dmlloyd.classfile.TypeKind.BOOLEAN),
    BYTE(io.github.dmlloyd.classfile.TypeKind.BYTE),
    CHAR(io.github.dmlloyd.classfile.TypeKind.CHAR),
    SHORT(io.github.dmlloyd.classfile.TypeKind.SHORT),
    INT(io.github.dmlloyd.classfile.TypeKind.INT),
    LONG(io.github.dmlloyd.classfile.TypeKind.LONG),
    FLOAT(io.github.dmlloyd.classfile.TypeKind.FLOAT),
    DOUBLE(io.github.dmlloyd.classfile.TypeKind.DOUBLE),
    REFERENCE(io.github.dmlloyd.classfile.TypeKind.REFERENCE),
    VOID(io.github.dmlloyd.classfile.TypeKind.VOID);

    private final io.github.dmlloyd.classfile.TypeKind actualKind;

    private TypeKind(io.github.dmlloyd.classfile.TypeKind actualKind) {
        this.actualKind = actualKind;
    }

    public ClassDesc upperBound() {
        return this.actualKind.upperBound();
    }

    public int slotSize() {
        return this.actualKind.slotSize();
    }

    public TypeKind asLoadable() {
        return TypeKind.of(this.actualKind.asLoadable());
    }

    static TypeKind of(io.github.dmlloyd.classfile.TypeKind actualKind) {
        return switch (actualKind) {
            default -> throw new IncompatibleClassChangeError();
            case io.github.dmlloyd.classfile.TypeKind.BOOLEAN -> BOOLEAN;
            case io.github.dmlloyd.classfile.TypeKind.BYTE -> BYTE;
            case io.github.dmlloyd.classfile.TypeKind.CHAR -> CHAR;
            case io.github.dmlloyd.classfile.TypeKind.SHORT -> SHORT;
            case io.github.dmlloyd.classfile.TypeKind.INT -> INT;
            case io.github.dmlloyd.classfile.TypeKind.LONG -> LONG;
            case io.github.dmlloyd.classfile.TypeKind.FLOAT -> FLOAT;
            case io.github.dmlloyd.classfile.TypeKind.DOUBLE -> DOUBLE;
            case io.github.dmlloyd.classfile.TypeKind.REFERENCE -> REFERENCE;
            case io.github.dmlloyd.classfile.TypeKind.VOID -> VOID;
        };
    }

    public static TypeKind from(String descriptor) {
        char ch = descriptor.charAt(0);
        return switch (ch) {
            case 'Z' -> BOOLEAN;
            case 'B' -> BYTE;
            case 'C' -> CHAR;
            case 'S' -> SHORT;
            case 'I' -> INT;
            case 'J' -> LONG;
            case 'F' -> FLOAT;
            case 'D' -> DOUBLE;
            case 'V' -> VOID;
            case 'L', '[' -> REFERENCE;
            default -> throw Assert.impossibleSwitchCase((char)ch);
        };
    }

    public static TypeKind from(ClassDesc descriptor) {
        return TypeKind.from(descriptor.descriptorString());
    }

    public static TypeKind from(Class<?> clazz) {
        return clazz.isPrimitive() ? TypeKind.from(clazz.descriptorString()) : REFERENCE;
    }
}

