/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class ArrayStore
extends Item {
    private final Item arrayExpr;
    private final Item index;
    private final Item value;
    private final ClassDesc componentType;

    ArrayStore(Item arrayExpr, Item index, Item value, ClassDesc componentType) {
        this.arrayExpr = arrayExpr;
        this.index = Conversions.convert(index, ConstantDescs.CD_int);
        this.value = Conversions.convert(value, componentType);
        this.componentType = componentType;
    }

    Item arrayExpr() {
        return this.arrayExpr;
    }

    Item index() {
        return this.index;
    }

    Item value() {
        return this.value;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.value.process(itr, op);
        this.index.process(itr, op);
        this.arrayExpr.process(itr, op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.arrayStore(TypeKind.from((TypeDescriptor.OfField)this.componentType));
        smb.pop();
        smb.pop();
        smb.pop();
        smb.wroteCode();
    }
}

