/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.TypeKind;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

final class TryFinally
extends Item {
    final BlockCreatorImpl body;
    final BlockCreatorImpl cleanupTemplate;
    final Consumer<BlockCreator> cleanupBuilder;
    Label cleanupAndYield;
    final Map<CleanupKey, Cleanup> cleanups = new LinkedHashMap<CleanupKey, Cleanup>();
    IllegalStateException written = null;

    TryFinally(BlockCreatorImpl body, Consumer<BlockCreator> cleanupBuilder) {
        this.body = body;
        this.cleanupTemplate = new BlockCreatorImpl(body.parent());
        this.cleanupTemplate.branchTarget();
        this.cleanupBuilder = cleanupBuilder;
        body.tryFinally = this;
        body.parent().nesting(() -> this.cleanupTemplate.accept(cleanupBuilder));
    }

    BlockCreatorImpl body() {
        return this.body;
    }

    Label cleanupAndYield() {
        Label cleanupAndYield = this.cleanupAndYield;
        if (cleanupAndYield == null) {
            cleanupAndYield = this.cleanupAndYield = this.body.newLabel();
        }
        return cleanupAndYield;
    }

    Label cleanup(CleanupKey key) {
        Cleanup cleanup = this.cleanups.get(key);
        if (cleanup == null) {
            cleanup = new Cleanup(this.body.newLabel(), key);
            this.cleanups.put(key, cleanup);
        }
        return cleanup.label();
    }

    @Override
    public boolean mayFallThrough() {
        return this.body.mayFallThrough() && this.cleanupTemplate.mayFallThrough();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        BlockCreatorImpl copy;
        if (this.written != null) {
            throw this.written;
        }
        this.written = new IllegalStateException();
        boolean bodyFallsThrough = this.body.mayFallThrough();
        Label cleanupAndThrow = cb.newLabel();
        StackMapBuilder.Saved saved = smb.save();
        this.body.writeCode(cb, block, smb);
        cb.exceptionCatchAll(this.body.startLabel(), this.body.endLabel(), cleanupAndThrow);
        if (bodyFallsThrough) {
            cb.goto_(this.cleanupAndYield());
            smb.wroteCode();
        }
        smb.restore(saved);
        for (Cleanup value : this.cleanups.values()) {
            smb.restore(value.action().saved());
            cb.labelBinding(value.label());
            smb.addFrameInfo(cb);
            if (!this.cleanupTemplate.mayFallThrough()) {
                switch (TypeKind.from((TypeDescriptor.OfField)value.type()).slotSize()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        cb.pop();
                        smb.pop();
                        break;
                    }
                    case 2: {
                        cb.pop2();
                        smb.pop();
                    }
                }
                cb.goto_(this.cleanupAndYield());
                smb.wroteCode();
                continue;
            }
            copy = new BlockCreatorImpl(this.body.parent(), value.type());
            copy.accept((b, val) -> {
                this.cleanupBuilder.accept((BlockCreator)b);
                if (b.active()) {
                    value.action().terminate((BlockCreatorImpl)b, (Expr)val);
                }
            });
            copy.writeCode(cb, block, smb);
        }
        smb.restore(saved);
        cb.labelBinding(cleanupAndThrow);
        smb.clearStack();
        smb.push(ConstantDescs.CD_Throwable);
        smb.addFrameInfo(cb);
        if (!this.cleanupTemplate.mayFallThrough() && Util.isVoid(this.body.type())) {
            cb.pop();
            smb.pop();
            smb.wroteCode();
            this.cleanupAndYield();
        } else {
            copy = new BlockCreatorImpl(this.body.parent(), ConstantDescs.CD_Throwable);
            copy.branchTarget();
            copy.accept((b, val) -> {
                this.cleanupBuilder.accept((BlockCreator)b);
                if (b.active()) {
                    b.throw_((Expr)val);
                }
            });
            copy.writeCode(cb, block, smb);
        }
        smb.restore(saved);
        if (this.cleanupAndYield != null) {
            cb.labelBinding(this.cleanupAndYield);
            smb.addFrameInfo(cb);
            copy = new BlockCreatorImpl(this.body.parent(), this.body.type(), this.body.type());
            copy.branchTarget();
            copy.accept((b, val) -> {
                this.cleanupBuilder.accept((BlockCreator)b);
                if (b.active()) {
                    b.yield((Expr)val);
                }
            });
            copy.writeCode(cb, block, smb);
        }
    }

    record Cleanup(Label label, CleanupKey action) {
        ClassDesc type() {
            return this.action.type();
        }
    }

    static abstract class CleanupKey {
        private final StackMapBuilder.Saved saved;

        CleanupKey(StackMapBuilder.Saved saved) {
            this.saved = saved;
        }

        ClassDesc type() {
            return ConstantDescs.CD_void;
        }

        StackMapBuilder.Saved saved() {
            return this.saved;
        }

        abstract void terminate(BlockCreatorImpl var1, Expr var2);
    }
}

