/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.util.Optional;

public final class NullConst
extends ConstImpl {
    private final DynamicConstantDesc<Object> desc = DynamicConstantDesc.of(ConstantDescs.BSM_NULL_CONSTANT, new ConstantDesc[]{"_", this.type()});

    public NullConst(ClassDesc type) {
        super(type);
    }

    @Override
    public boolean isZero() {
        return true;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.aconst_null();
        smb.push(this.type());
        smb.wroteCode();
    }

    @Override
    public ConstantDesc desc() {
        return this.desc;
    }

    public Optional<ConstantDesc> describeConstable() {
        return Optional.of(this.desc());
    }

    @Override
    public boolean equals(ConstImpl obj) {
        NullConst other;
        return obj instanceof NullConst && this.equals(other = (NullConst)obj);
    }

    public boolean equals(NullConst other) {
        return this == other || other != null && this.type().equals(other.type());
    }

    @Override
    public int hashCode() {
        return this.type().hashCode() + 19;
    }

    @Override
    public String toString() {
        return "null";
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return Util.descName(b.append('('), this.type()).append(")null");
    }
}

