/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.ThisExpr;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.Opcode;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class Invoke
extends Item {
    private final ClassDesc owner;
    private final String name;
    private final MethodTypeDesc type;
    private final Item instance;
    private final List<Item> args;
    private final Opcode opcode;
    private final boolean isInterface;

    Invoke(Opcode opcode, MethodDesc desc, Expr instance, List<? extends Expr> args, GenericType genericType) {
        this(desc.owner(), desc.name(), (MethodTypeDesc)desc.type(), opcode, desc instanceof InterfaceMethodDesc, (Item)instance, Util.reinterpretCast(args), genericType);
    }

    Invoke(ConstructorDesc desc, Expr instance, List<? extends Expr> args, GenericType genericType) {
        this(desc.owner(), "<init>", desc.type(), Opcode.INVOKESPECIAL, false, (Item)instance, Util.reinterpretCast(args), genericType);
    }

    private Invoke(ClassDesc owner, String name, MethodTypeDesc type, Opcode opcode, boolean isInterface, Item instance, List<Item> args, GenericType genericType) {
        super(type.returnType(), genericType);
        if (type.parameterCount() != args.size()) {
            String paramsStr = type.parameterCount() == 1 ? "1 parameter" : type.parameterCount() + " parameters";
            String argsStr = args.size() == 1 ? "1 argument was" : args.size() + " arguments were";
            throw new IllegalArgumentException("Method " + owner.displayName() + "." + name + "() takes " + paramsStr + ", but " + argsStr + " passed");
        }
        if (instance != null) {
            instance = Conversions.convert(instance, owner);
        }
        ArrayList<Item> newArgs = new ArrayList<Item>(args.size());
        for (int i = 0; i < args.size(); ++i) {
            try {
                newArgs.add(Conversions.convert(args.get(i), type.parameterType(i)));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Parameter " + i + " of method " + owner.displayName() + "." + name + "() is of type '" + type.parameterType(i).displayName() + "', but given argument is '" + args.get(i).type().displayName() + "'");
            }
        }
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.opcode = opcode;
        this.isInterface = isInterface;
        this.instance = instance;
        this.args = newArgs;
    }

    @Override
    public String itemName() {
        return "Invoke:" + this.owner.displayName() + "." + this.name;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        int size = this.args.size();
        for (int i = size - 1; i >= 0; --i) {
            this.args.get(i).process(itr, op);
        }
        if (this.instance != null) {
            this.instance.process(itr, op);
        }
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.invoke(this.opcode, this.owner, this.name, this.type, this.isInterface);
        if (this.opcode == Opcode.INVOKESPECIAL && this.instance instanceof ThisExpr) {
            smb.store(0, this.instance.type());
        }
        if (this.opcode != Opcode.INVOKESTATIC) {
            smb.pop();
        }
        for (ClassDesc paramType : this.type.parameterList()) {
            smb.pop();
        }
        if (!Util.isVoid(this.type.returnType())) {
            smb.push(this.type.returnType());
        }
        smb.wroteCode();
    }
}

