/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.invoke.TypeDescriptor;

public class Preconditions {
    private Preconditions() {
    }

    public static void requireSameType(Expr a, Expr b) {
        if (!Util.equals(a.type(), b.type())) {
            throw new IllegalArgumentException("Type mismatch between " + a.type().displayName() + " and " + b.type().displayName());
        }
    }

    public static void requireSameTypeKind(Expr a, Expr b) {
        if (a.typeKind() != b.typeKind()) {
            throw new IllegalArgumentException("Type mismatch between " + a.type().displayName() + " and " + b.type().displayName());
        }
    }

    public static void requireSameTypeKind(ClassDesc a, ClassDesc b) {
        if (TypeKind.from((TypeDescriptor.OfField)a) != TypeKind.from((TypeDescriptor.OfField)b)) {
            throw new IllegalArgumentException("Type mismatch between " + a.displayName() + " and " + b.displayName());
        }
    }

    public static void requireSameLoadableTypeKind(Expr a, Expr b) {
        if (a.typeKind().asLoadable() != b.typeKind().asLoadable()) {
            throw new IllegalArgumentException("Type mismatch between " + a.type().displayName() + " and " + b.type().displayName());
        }
    }

    public static void requireSameLoadableTypeKind(ClassDesc a, ClassDesc b) {
        if (TypeKind.from((TypeDescriptor.OfField)a).asLoadable() != TypeKind.from((TypeDescriptor.OfField)b).asLoadable()) {
            throw new IllegalArgumentException("Type mismatch between " + a.displayName() + " and " + b.displayName());
        }
    }

    public static void requireArray(Expr expr) {
        if (!expr.type().isArray()) {
            throw new IllegalArgumentException("Array expected: " + expr.type().displayName());
        }
    }
}

