/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.undertow.UndertowMessages;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.IoCallback;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.Bits;
import io.undertow.util.IoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class ServletOutputStreamImpl
extends ServletOutputStream {
    private final ServletRequestContext servletRequestContext;
    private final HttpServerExchange exchange;
    private ByteBuf pooledBuffer;
    private int bufferSize;
    private long written;
    private final long contentLength;
    private static final AtomicIntegerFieldUpdater<ServletOutputStreamImpl> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ServletOutputStreamImpl.class, "state");
    private volatile int state;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int FLAG_IS_READY_CALLED = 4;
    private static final int FLAG_PENDING_DATA = 8;
    private static final int FLAG_EXCHANGE_LAST_SENT = 16;
    private WriteListener listener;
    private volatile ListenerCallback listenerCallback;

    public ServletOutputStreamImpl(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.contentLength = exchange.getResponseContentLength();
        this.servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
    }

    public ServletOutputStreamImpl(HttpServerExchange exchange, Integer bufferSize) {
        this.exchange = exchange;
        this.contentLength = exchange.getResponseContentLength();
        this.servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
    }

    public long getBytesWritten() {
        return this.written;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener == null) {
            if (this.exchange.getIoThread().inEventLoop()) {
                throw UndertowMessages.MESSAGES.blockingIoFromIOThread();
            }
            int rem = len;
            int idx = off;
            ByteBuf buffer = this.pooledBuffer;
            try {
                if (buffer == null) {
                    this.pooledBuffer = this.bufferSize > 0 ? (buffer = this.exchange.allocateBuffer(this.bufferSize)) : (buffer = this.exchange.allocateBuffer());
                }
                while (rem > 0) {
                    int toWrite = Math.min(rem, buffer.writableBytes());
                    buffer.writeBytes(b, idx, toWrite);
                    rem -= toWrite;
                    idx += toWrite;
                    if (buffer.isWritable()) continue;
                    this.setFlags(2);
                    ByteBuf tmpBuf = buffer;
                    this.pooledBuffer = buffer = this.exchange.allocateBuffer();
                    this.exchange.writeBlocking(tmpBuf, false);
                }
            }
            catch (Exception e) {
                if (buffer != null) {
                    buffer.release();
                    this.pooledBuffer = null;
                }
                throw new IOException(e);
            }
            this.updateWritten(len);
        } else {
            this.writeAsync(b, off, len);
        }
    }

    private void writeAsync(byte[] b, int off, int len) throws IOException {
        ByteBuf buffer = this.pooledBuffer;
        try {
            if (buffer == null) {
                this.pooledBuffer = buffer = this.exchange.allocateBuffer();
            }
            int toWrite = Math.min(len, buffer.writableBytes());
            buffer.writeBytes(b, off, toWrite);
            if (!buffer.isWritable()) {
                this.setFlags(10);
                this.pooledBuffer = null;
                if (toWrite < len) {
                    ByteBuf remainder = Unpooled.wrappedBuffer((byte[])b, (int)(off + toWrite), (int)(len - toWrite));
                    buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, remainder});
                }
                this.exchange.writeAsync(buffer, false, (IoCallback)this.listenerCallback, null);
            }
        }
        catch (Exception e) {
            if (buffer != null) {
                buffer.release();
                this.pooledBuffer = null;
            }
            throw new IOException(e);
        }
        this.updateWrittenAsync(len);
    }

    public void flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        try {
            if (this.pooledBuffer != null) {
                if (this.listener == null) {
                    this.exchange.writeBlocking(this.pooledBuffer, false);
                    this.pooledBuffer = null;
                } else {
                    this.exchange.writeAsync(this.pooledBuffer, false, (IoCallback)this.listenerCallback, null);
                    this.pooledBuffer = null;
                }
            }
        }
        catch (Exception e) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.release();
                this.pooledBuffer = null;
            }
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block14: {
            if (Bits.anyAreSet((int)this.state, (int)1)) {
                return;
            }
            this.setFlags(1);
            if (Bits.anyAreClear((int)this.state, (int)2) && this.servletRequestContext.getOriginalResponse().getHeader("Content-Length") == null) {
                if (this.pooledBuffer == null) {
                    this.exchange.setResponseHeader("Content-Length", "0");
                } else {
                    this.exchange.setResponseHeader("Content-Length", "" + this.pooledBuffer.readableBytes());
                }
            }
            try {
                if (this.listener == null) {
                    this.exchange.writeBlocking(this.pooledBuffer, true);
                    break block14;
                }
                ServletOutputStreamImpl servletOutputStreamImpl = this;
                synchronized (servletOutputStreamImpl) {
                    if (Bits.allAreClear((int)this.state, (int)24)) {
                        this.setFlags(16);
                        this.exchange.writeAsync(this.pooledBuffer, true, (IoCallback)this.listenerCallback, null);
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.pooledBuffer = null;
            }
        }
    }

    public void resetBuffer() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        if (this.pooledBuffer != null) {
            this.pooledBuffer.clear();
            this.written = 0L;
        }
    }

    public void setBufferSize(int bufferSize) {
        if (this.pooledBuffer == null || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
            throw UndertowServletMessages.MESSAGES.contentHasBeenWritten();
        }
        this.bufferSize = bufferSize;
    }

    public ServletRequestContext getServletRequestContext() {
        return this.servletRequestContext;
    }

    public ByteBuf underlyingBuffer() {
        if (this.pooledBuffer == null) {
            this.pooledBuffer = this.exchange.allocateBuffer();
        }
        return this.pooledBuffer;
    }

    public ByteBuf flushInternal() throws IOException {
        this.flush();
        return this.underlyingBuffer();
    }

    public void updateWritten(int len) {
        this.written += (long)len;
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L && this.written >= contentLength) {
            IoUtils.safeClose((Closeable)((Object)this));
        }
    }

    void updateWrittenAsync(long len) throws IOException {
        this.written += len;
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L && this.written >= contentLength) {
            IoUtils.safeClose((Closeable)((Object)this));
        }
    }

    public boolean isReady() {
        if (Bits.anyAreSet((int)this.state, (int)9)) {
            return false;
        }
        this.setFlags(4);
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        HttpServletRequestImpl servletRequest = this.servletRequestContext.getOriginalRequest();
        if (!servletRequest.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.listener = writeListener;
        this.listenerCallback = new ListenerCallback();
        this.servletRequestContext.getOriginalRequest().getAsyncContext().addAsyncTask(new Runnable(){

            @Override
            public void run() {
                ServletOutputStreamImpl.this.exchange.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletOutputStreamImpl.this.listenerCallback.onComplete(null, null);
                    }
                });
            }
        });
    }

    private void setFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old | flags)) {
        }
    }

    private void clearFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old & ~flags)) {
        }
    }

    private class ListenerCallback
    implements IoCallback<Void> {
        private ListenerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(HttpExchange ex, Void context) {
            ServletOutputStreamImpl.this.clearFlags(8);
            if (Bits.allAreClear((int)ServletOutputStreamImpl.this.state, (int)1)) {
                try {
                    ServletOutputStreamImpl.this.servletRequestContext.getCurrentServletContext().invokeOnWritePossible(ServletOutputStreamImpl.this.exchange, ServletOutputStreamImpl.this.listener);
                }
                catch (Exception e) {
                    if (ServletOutputStreamImpl.this.pooledBuffer != null) {
                        ServletOutputStreamImpl.this.pooledBuffer.release();
                        ServletOutputStreamImpl.this.pooledBuffer = null;
                    }
                    ServletOutputStreamImpl.this.servletRequestContext.getCurrentServletContext().invokeRunnable(ServletOutputStreamImpl.this.exchange, new Runnable(){

                        @Override
                        public void run() {
                            ServletOutputStreamImpl.this.listener.onError((Throwable)e);
                        }
                    });
                }
            } else {
                ServletOutputStreamImpl servletOutputStreamImpl = ServletOutputStreamImpl.this;
                synchronized (servletOutputStreamImpl) {
                    if (Bits.allAreClear((int)ServletOutputStreamImpl.this.state, (int)16)) {
                        ServletOutputStreamImpl.this.setFlags(16);
                        ServletOutputStreamImpl.this.exchange.writeAsync(ServletOutputStreamImpl.this.pooledBuffer, true, (IoCallback)this, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(HttpExchange ex, Void context, final IOException exception) {
            try {
                ServletOutputStreamImpl.this.servletRequestContext.getCurrentServletContext().invokeRunnable(ServletOutputStreamImpl.this.servletRequestContext.getExchange(), new Runnable(){

                    @Override
                    public void run() {
                        ServletOutputStreamImpl.this.listener.onError((Throwable)exception);
                    }
                });
            }
            finally {
                ServletOutputStreamImpl.this.exchange.endExchange();
                if (ServletOutputStreamImpl.this.pooledBuffer != null) {
                    ServletOutputStreamImpl.this.pooledBuffer.release();
                    ServletOutputStreamImpl.this.pooledBuffer = null;
                }
            }
        }
    }
}

