/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.SbomResult;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.BuildAnalyticsProvider;
import io.quarkus.maven.MojoLogger;
import io.quarkus.maven.QuarkusBootstrapMojo;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class BuildMojo
extends QuarkusBootstrapMojo {
    @Component
    MavenProjectHelper projectHelper;
    @Component
    BuildAnalyticsProvider analyticsProvider;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${project.build.directory}/generated-sources")
    File generatedSourcesDirectory;
    @Parameter(defaultValue="false", property="quarkus.build.skip")
    boolean skip = false;
    @Deprecated
    @Parameter(property="skipOriginalJarRename")
    boolean skipOriginalJarRename;
    @Parameter(property="attachRunnerAsMainArtifact", required=false)
    boolean attachRunnerAsMainArtifact;
    @Parameter(property="attachSboms")
    boolean attachSboms = true;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    File buildDirectory;
    @Parameter
    Map<String, String> systemProperties = Collections.emptyMap();

    @Override
    protected boolean beforeExecute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Quarkus build");
            return false;
        }
        if (this.mavenProject().getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Type of the artifact is POM, skipping build goal");
            return false;
        }
        if (!this.mavenProject().getArtifact().getArtifactHandler().getExtension().equals("jar")) {
            throw new MojoExecutionException("The project artifact's extension is '" + this.mavenProject().getArtifact().getArtifactHandler().getExtension() + "' while this goal expects it be 'jar'");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException {
        block22: {
            try {
                HashSet<String> propertiesToClear = new HashSet<String>();
                for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                    String key = entry.getKey();
                    if (System.getProperty(key) != null) continue;
                    System.setProperty(key, entry.getValue());
                    propertiesToClear.add(key);
                }
                if (this.setNativeEnabledIfNativeProfileEnabled()) {
                    propertiesToClear.add("quarkus.native.enabled");
                }
                if (!propertiesToClear.isEmpty() && this.mavenSession().getRequest().getDegreeOfConcurrency() > 1) {
                    this.getLog().warn((CharSequence)"*****************************************************************");
                    this.getLog().warn((CharSequence)"* Your build is requesting parallel execution, but the project  *");
                    this.getLog().warn((CharSequence)"* relies on System properties at build time which could cause   *");
                    this.getLog().warn((CharSequence)"* race condition issues thus unpredictable build results.       *");
                    this.getLog().warn((CharSequence)"* Please avoid using System properties or avoid enabling        *");
                    this.getLog().warn((CharSequence)"* parallel execution                                            *");
                    this.getLog().warn((CharSequence)"*****************************************************************");
                }
                try (CuratedApplication curatedApplication = this.bootstrapApplication();){
                    Path standardJar;
                    boolean uberJarWithSuffix;
                    AugmentAction action = curatedApplication.createAugmentor();
                    AugmentResult result = action.createProductionApplication();
                    this.analyticsProvider.sendAnalytics(TrackEventType.BUILD, curatedApplication.getApplicationModel(), result.getGraalVMInfo(), this.buildDirectory);
                    Artifact original = this.mavenProject().getArtifact();
                    if (result.getJar() == null) break block22;
                    boolean bl = uberJarWithSuffix = result.getJar().isUberJar() && result.getJar().getOriginalArtifact() != null && !result.getJar().getOriginalArtifact().equals(result.getJar().getPath());
                    if (!this.skipOriginalJarRename && uberJarWithSuffix && result.getJar().getOriginalArtifact() != null && Files.exists(standardJar = result.getJar().getOriginalArtifact(), new LinkOption[0])) {
                        Path renamedOriginal = standardJar.getParent().toAbsolutePath().resolve(String.valueOf(standardJar.getFileName()) + ".original");
                        try {
                            IoUtils.recursiveDelete((Path)renamedOriginal);
                            Files.move(standardJar, renamedOriginal, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        original.setFile(renamedOriginal.toFile());
                    }
                    if (uberJarWithSuffix) {
                        if (this.attachRunnerAsMainArtifact || result.getJar().getClassifier().isEmpty()) {
                            original.setFile(result.getJar().getPath().toFile());
                        } else {
                            this.projectHelper.attachArtifact(this.mavenProject(), result.getJar().getPath().toFile(), result.getJar().getClassifier());
                        }
                    }
                    if (this.attachSboms && result.getJar().isUberJar() && !result.getJar().getSboms().isEmpty()) {
                        for (SbomResult sbom : result.getJar().getSboms()) {
                            this.projectHelper.attachArtifact(this.mavenProject(), sbom.getFormat(), sbom.getClassifier(), sbom.getSbomFile().toFile());
                        }
                    }
                }
                finally {
                    propertiesToClear.forEach(System::clearProperty);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to build quarkus application", e);
            }
        }
    }

    @Override
    public void setLog(Log log) {
        super.setLog(log);
        MojoLogger.delegate = log;
    }
}

