/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.health;

import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.sql.DataSource;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class DataSourceHealthCheck
implements HealthCheck {
    private static final String DEFAULT_DS = "__default__";
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    @PostConstruct
    protected void init() {
        Set beans = Arc.container().beanManager().getBeans(DataSource.class, new Annotation[0]);
        for (Bean bean : beans) {
            if (bean.getName() == null) {
                DataSource defaultDs = (DataSource)Arc.container().instance(DataSource.class, new Annotation[0]).get();
                this.dataSources.put(DEFAULT_DS, defaultDs);
                continue;
            }
            DataSource ds = (DataSource)Arc.container().instance(bean.getName()).get();
            this.dataSources.put(bean.getName(), ds);
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Database connection(s) health check").up();
        for (Map.Entry<String, DataSource> dataSource : this.dataSources.entrySet()) {
            boolean isDefault = DEFAULT_DS.equals(dataSource.getKey());
            try {
                Connection con = dataSource.getValue().getConnection();
                Throwable throwable = null;
                try {
                    boolean valid = con.isValid(0);
                    if (valid) continue;
                    String data = isDefault ? "validation check failed for the default DataSource" : "validation check failed for DataSource '" + dataSource.getKey() + "'";
                    String dsName = isDefault ? "quarkus-default-ds" : dataSource.getKey();
                    builder.down().withData(dsName, data);
                }
                catch (Throwable valid) {
                    throwable = valid;
                    throw valid;
                }
                finally {
                    if (con == null) continue;
                    if (throwable != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable valid) {
                            throwable.addSuppressed(valid);
                        }
                        continue;
                    }
                    con.close();
                }
            }
            catch (SQLException e) {
                String data = isDefault ? "Unable to execute the validation check for the default DataSource: " : "Unable to execute the validation check for DataSource '" + dataSource.getKey() + "': ";
                String dsName = isDefault ? "quarkus-default-ds" : dataSource.getKey();
                builder.down().withData(dsName, data + e.getMessage());
            }
        }
        return builder.build();
    }
}

