/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import com.google.common.base.Objects;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.index.PersistentClassIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class BeanArchiveProcessor {
    /*
     * WARNING - void declaration
     */
    @BuildStep
    public BeanArchiveIndexBuildItem build(ArcConfig config, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations, List<AdditionalBeanBuildItem> additionalBeans, List<GeneratedBeanBuildItem> generatedBeans, LiveReloadBuildItem liveReloadBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, CustomScopeAnnotationsBuildItem customScopes) throws Exception {
        void var14_20;
        IndexView applicationIndex = this.buildApplicationIndex(config, applicationArchivesBuildItem, additionalBeanDefiningAnnotations, customScopes);
        Indexer additionalBeanIndexer = new Indexer();
        ArrayList<String> additionalBeanClasses = new ArrayList<String>();
        for (AdditionalBeanBuildItem additionalBeanBuildItem : additionalBeans) {
            additionalBeanClasses.addAll(additionalBeanBuildItem.getBeanClasses());
        }
        HashSet additionalIndex = new HashSet();
        for (String string : additionalBeanClasses) {
            IndexingUtil.indexClass((String)string, (Indexer)additionalBeanIndexer, (IndexView)applicationIndex, additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        HashSet<DotName> hashSet = new HashSet<DotName>();
        for (GeneratedBeanBuildItem generatedBeanClass : generatedBeans) {
            IndexingUtil.indexClass((String)generatedBeanClass.getName(), (Indexer)additionalBeanIndexer, (IndexView)applicationIndex, additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])generatedBeanClass.getData());
            hashSet.add(DotName.createSimple((String)generatedBeanClass.getName().replace('/', '.')));
            generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, generatedBeanClass.getName(), generatedBeanClass.getData(), generatedBeanClass.getSource()));
        }
        PersistentClassIndex persistentClassIndex = (PersistentClassIndex)liveReloadBuildItem.getContextObject(PersistentClassIndex.class);
        if (persistentClassIndex == null) {
            PersistentClassIndex persistentClassIndex2 = new PersistentClassIndex();
            liveReloadBuildItem.setContextObject(PersistentClassIndex.class, (Object)persistentClassIndex2);
        }
        return new BeanArchiveIndexBuildItem(BeanArchives.buildBeanArchiveIndex((ClassLoader)Thread.currentThread().getContextClassLoader(), (Map)var14_20.getAdditionalClasses(), (IndexView[])new IndexView[]{applicationIndex, additionalBeanIndexer.complete()}), hashSet);
    }

    private IndexView buildApplicationIndex(ArcConfig config, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations, CustomScopeAnnotationsBuildItem customScopes) {
        Set archives = applicationArchivesBuildItem.getAllApplicationArchives();
        HashSet<DotName> stereotypes = new HashSet<DotName>();
        for (Object archive : archives) {
            Collection annotations = archive.getIndex().getAnnotations(DotNames.STEREOTYPE);
            if (annotations.isEmpty()) continue;
            for (AnnotationInstance annotationInstance : annotations) {
                if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                stereotypes.add(annotationInstance.target().asClass().name());
            }
        }
        Set beanDefiningAnnotations = BeanDeployment.initBeanDefiningAnnotations((Collection)additionalBeanDefiningAnnotations.stream().map(bda -> new BeanDefiningAnnotation(bda.getName(), bda.getDefaultScope())).collect(Collectors.toList()), stereotypes);
        for (DotName customScopeAnnotationName : customScopes.getCustomScopeNames()) {
            beanDefiningAnnotations.add(customScopeAnnotationName);
        }
        beanDefiningAnnotations.add(DotNames.QUALIFIER);
        beanDefiningAnnotations.add(DotNames.INTERCEPTOR_BINDING);
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getApplicationArchives()) {
            if (this.isApplicationArchiveExcluded(config, archive)) continue;
            IndexView index = archive.getIndex();
            if (archive.getChildPath("META-INF/beans.xml") == null && archive.getChildPath("WEB-INF/beans.xml") == null && (!index.getAllKnownImplementors(DotNames.EXTENSION).isEmpty() || !this.containsBeanDefiningAnnotation(index, beanDefiningAnnotations))) continue;
            indexes.add(index);
        }
        indexes.add(applicationArchivesBuildItem.getRootArchive().getIndex());
        return CompositeIndex.create(indexes);
    }

    private boolean isApplicationArchiveExcluded(ArcConfig config, ApplicationArchive archive) {
        if (archive.getArtifactKey() != null) {
            AppArtifactKey key = archive.getArtifactKey();
            for (IndexDependencyConfig excludeDependency : config.excludeDependency.values()) {
                if (!Objects.equal((Object)key.getArtifactId(), (Object)excludeDependency.artifactId) || !Objects.equal((Object)key.getGroupId(), (Object)excludeDependency.groupId)) continue;
                if (excludeDependency.classifier.isPresent()) {
                    return Objects.equal((Object)key.getClassifier(), excludeDependency.classifier.get());
                }
                return true;
            }
        }
        return false;
    }

    boolean containsBeanDefiningAnnotation(IndexView index, Collection<DotName> beanDefiningAnnotations) {
        for (DotName beanDefiningAnnotation : beanDefiningAnnotations) {
            if (index.getAnnotations(beanDefiningAnnotation).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

