/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

public class WrongAnnotationUsageProcessor {
    @BuildStep
    void detect(ArcConfig config, ApplicationIndexBuildItem applicationIndex, CustomScopeAnnotationsBuildItem scopeAnnotations, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, InterceptorResolverBuildItem interceptorResolverBuildItem) {
        if (!config.detectWrongAnnotations) {
            return;
        }
        Index index = applicationIndex.getIndex();
        ArrayList<UnsupportedAnnotation> unsupported = new ArrayList<UnsupportedAnnotation>();
        Function<AnnotationInstance, String> singletonFun = new Function<AnnotationInstance, String>(){

            @Override
            public String apply(AnnotationInstance annotationInstance) {
                return String.format("%s declared on %s, use @javax.inject.Singleton instead", annotationInstance.toString(false), WrongAnnotationUsageProcessor.getTargetInfo(annotationInstance));
            }
        };
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"com.google.inject.Singleton"), singletonFun));
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"javax.ejb.Singleton"), singletonFun));
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"groovy.lang.Singleton"), singletonFun));
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"jakarta.ejb.Singleton"), singletonFun));
        HashMap<AnnotationInstance, String> wrongUsages = new HashMap<AnnotationInstance, String>();
        for (UnsupportedAnnotation unsupportedAnnotation : unsupported) {
            for (AnnotationInstance annotationInstance : index.getAnnotations(unsupportedAnnotation.name)) {
                wrongUsages.put(annotationInstance, unsupportedAnnotation.messageFun.apply(annotationInstance));
            }
        }
        if (!wrongUsages.isEmpty()) {
            for (Map.Entry entry : wrongUsages.entrySet()) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException((String)entry.getValue())));
            }
        }
        for (ClassInfo classInfo : index.getKnownClasses()) {
            ClassInfo.NestingType nestingType = classInfo.nestingType();
            if (ClassInfo.NestingType.ANONYMOUS != nestingType && ClassInfo.NestingType.LOCAL != nestingType && (ClassInfo.NestingType.INNER != nestingType || Modifier.isStatic(classInfo.flags()))) continue;
            Collection<AnnotationInstance> classLevelAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)classInfo);
            if (scopeAnnotations.isScopeIn(classLevelAnnotations)) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s has a scope annotation but it must be ignored per the CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
            } else if (Annotations.containsAny(classLevelAnnotations, interceptorResolverBuildItem.getInterceptorBindings())) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s declares an interceptor binding but it must be ignored per CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
            }
            for (MethodInfo methodInfo : classInfo.methods()) {
                Collection<AnnotationInstance> methodAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)methodInfo);
                if (methodAnnotations.isEmpty()) continue;
                if (Annotations.contains(methodAnnotations, (DotName)DotNames.OBSERVES) || Annotations.contains(methodAnnotations, (DotName)DotNames.OBSERVES_ASYNC)) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The method %s in the %s class %s declares an observer method but it must be ignored per the CDI rules", methodInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
                    continue;
                }
                if (Annotations.contains(methodAnnotations, (DotName)DotNames.PRODUCES)) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The method %s in the %s class %s declares a producer but it must be ignored per the CDI rules", methodInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
                    continue;
                }
                if (Modifier.isStatic(methodInfo.flags()) || !Annotations.containsAny(methodAnnotations, interceptorResolverBuildItem.getInterceptorBindings())) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The method %s in the %s class %s declares an interceptor binding but it must be ignored per CDI rules", methodInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
            }
            for (FieldInfo fieldInfo : classInfo.fields()) {
                Collection<AnnotationInstance> fieldAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)fieldInfo);
                if (fieldAnnotations.isEmpty() || !Annotations.contains(fieldAnnotations, (DotName)DotNames.PRODUCES)) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The field %s in the %s class %s declares a producer but it must be ignored per the CDI rules", fieldInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
            }
        }
    }

    private static String getTargetInfo(AnnotationInstance annotationInstance) {
        AnnotationTarget target = annotationInstance.target();
        switch (target.kind()) {
            case FIELD: {
                return target.asField().declaringClass().toString() + "." + target.asField().name();
            }
            case METHOD: {
                return target.asMethod().declaringClass().toString() + "." + target.asMethod().name() + "()";
            }
        }
        return target.toString();
    }

    private static class UnsupportedAnnotation {
        final DotName name;
        final Function<AnnotationInstance, String> messageFun;

        UnsupportedAnnotation(DotName name, Function<AnnotationInstance, String> messageFun) {
            this.name = name;
            this.messageFun = messageFun;
        }
    }
}

