/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import io.quarkus.arc.deployment.devconsole.DevInterceptorInfo;
import io.quarkus.arc.deployment.devconsole.DevObserverInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DevBeanInfos {
    private final List<DevBeanInfo> beans = new ArrayList<DevBeanInfo>();
    private final List<DevBeanInfo> removedBeans = new ArrayList<DevBeanInfo>();
    private final List<DevObserverInfo> observers = new ArrayList<DevObserverInfo>();
    private final List<DevInterceptorInfo> interceptors = new ArrayList<DevInterceptorInfo>();

    public List<DevBeanInfo> getRemovedBeans() {
        return this.removedBeans;
    }

    public List<DevBeanInfo> getBeans() {
        return this.beans;
    }

    public List<DevObserverInfo> getObservers() {
        return this.observers;
    }

    public List<DevInterceptorInfo> getInterceptors() {
        return this.interceptors;
    }

    public DevInterceptorInfo getInterceptor(String id) {
        for (DevInterceptorInfo interceptor : this.interceptors) {
            if (!interceptor.getId().equals(id)) continue;
            return interceptor;
        }
        return null;
    }

    void addBean(DevBeanInfo beanInfo) {
        this.beans.add(beanInfo);
    }

    void addRemovedBean(DevBeanInfo beanInfo) {
        this.removedBeans.add(beanInfo);
    }

    void addObserver(DevObserverInfo observer) {
        this.observers.add(observer);
    }

    void addInterceptor(DevInterceptorInfo interceptor) {
        this.interceptors.add(interceptor);
    }

    void sort() {
        Collections.sort(this.beans);
        Collections.sort(this.removedBeans);
        Collections.sort(this.observers);
        Collections.sort(this.interceptors);
    }
}

