/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.StartupBuildSteps;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.shutdown.ShutdownBuildTimeConfig;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Shutdown;
import io.quarkus.runtime.ShutdownDelayInitiated;
import io.quarkus.runtime.ShutdownDelayInitiatedEvent;
import io.quarkus.runtime.ShutdownEvent;
import jakarta.enterprise.context.spi.Contextual;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ShutdownBuildSteps {
    static final DotName SHUTDOWN_NAME = DotName.createSimple((String)Shutdown.class.getName());
    static final DotName SHUTDOWN_DELAY_NAME = DotName.createSimple((String)ShutdownDelayInitiated.class.getName());
    private static final Logger LOG = Logger.getLogger(ShutdownBuildSteps.class);

    @BuildStep
    AutoAddScopeBuildItem shutdownAddScope(CustomScopeAnnotationsBuildItem customScopes, final ShutdownBuildTimeConfig config) {
        return AutoAddScopeBuildItem.builder().defaultScope(BuiltinScope.APPLICATION).anyMethodMatches(new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo m) {
                return m.hasAnnotation(SHUTDOWN_NAME) || config.delayEnabled() && m.hasAnnotation(SHUTDOWN_DELAY_NAME);
            }
        }).reason("Found classes containing @Shutdown/@ShutdownDelayInitiated annotation..").build();
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans(final ShutdownBuildTimeConfig config) {
        return new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo bean) {
                if (bean.isClassBean()) {
                    ClassInfo clasInfo = ((AnnotationTarget)bean.getTarget().get()).asClass();
                    return clasInfo.hasAnnotation(SHUTDOWN_NAME) || config.delayEnabled() && clasInfo.hasAnnotation(SHUTDOWN_DELAY_NAME);
                }
                return false;
            }
        });
    }

    @BuildStep
    void registerShutdownObservers(ObserverRegistrationPhaseBuildItem observerRegistration, ShutdownBuildTimeConfig shutdownConfig, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> configurators) {
        AnnotationStore annotationStore = (AnnotationStore)observerRegistration.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : observerRegistration.getContext().beans().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            ArrayList<MethodInfo> shutdownMethods = new ArrayList<MethodInfo>();
            ArrayList<MethodInfo> shutdownDelayedMethods = new ArrayList<MethodInfo>();
            for (MethodInfo method : beanClass.methods()) {
                if (annotationStore.hasAnnotation((AnnotationTarget)method, SHUTDOWN_NAME)) {
                    this.validateMethod(method, shutdownMethods, SHUTDOWN_NAME.withoutPackagePrefix());
                }
                if (!annotationStore.hasAnnotation((AnnotationTarget)method, SHUTDOWN_DELAY_NAME)) continue;
                this.validateMethod(method, shutdownDelayedMethods, SHUTDOWN_DELAY_NAME.withoutPackagePrefix());
            }
            if (!shutdownMethods.isEmpty()) {
                this.processMethods(shutdownMethods, annotationStore, SHUTDOWN_NAME, observerRegistration, bean);
            }
            if (shutdownDelayedMethods.isEmpty() || !shutdownConfig.delayEnabled()) continue;
            this.processMethods(shutdownDelayedMethods, annotationStore, SHUTDOWN_DELAY_NAME, observerRegistration, bean);
        }
    }

    private void validateMethod(MethodInfo method, List<MethodInfo> validMethods, String annotationName) {
        if (!(method.isSynthetic() || Modifier.isPrivate(method.flags()) || Modifier.isStatic(method.flags()) || method.parametersCount() != 0)) {
            validMethods.add(method);
        } else {
            LOG.warnf("Ignored an invalid @" + annotationName + " method declared on %s: %s", (Object)method.declaringClass().name(), (Object)method);
        }
    }

    private void processMethods(List<MethodInfo> shutdownMethods, AnnotationStore annotationStore, DotName annotationName, ObserverRegistrationPhaseBuildItem observerRegistration, BeanInfo bean) {
        for (MethodInfo method : shutdownMethods) {
            AnnotationValue priority = annotationStore.getAnnotation((AnnotationTarget)method, annotationName).value();
            this.registerShutdownObserver(observerRegistration, bean, String.valueOf(method.declaringClass().name()) + "#" + method.toString(), priority != null ? priority.asInt() : 2500, method, annotationName);
        }
    }

    private void registerShutdownObserver(ObserverRegistrationPhaseBuildItem observerRegistration, BeanInfo bean, String id, int priority, MethodInfo shutdownMethod, DotName observedType) {
        ObserverConfigurator configurator = observerRegistration.getContext().configure().beanClass(bean.getBeanClass()).observedType(observedType.equals((Object)SHUTDOWN_NAME) ? ShutdownEvent.class : ShutdownDelayInitiatedEvent.class);
        configurator.id(id);
        configurator.priority(priority);
        configurator.notify(mc -> {
            ResultHandle containerHandle = mc.invokeStaticMethod(StartupBuildSteps.ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle beanHandle = mc.invokeInterfaceMethod(StartupBuildSteps.ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{mc.load(bean.getIdentifier())});
            if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
                ResultHandle creationalContext = mc.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle});
                ResultHandle instance = mc.invokeInterfaceMethod(StartupBuildSteps.CONTEXTUAL_CREATE, beanHandle, new ResultHandle[]{creationalContext});
                TryBlock tryBlock = mc.tryBlock();
                tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)shutdownMethod), instance, new ResultHandle[0]);
                CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
                catchBlock.invokeInterfaceMethod(StartupBuildSteps.CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instance, creationalContext});
                catchBlock.throwException(RuntimeException.class, "Error destroying bean with @Shutdown method", catchBlock.getCaughtException());
                mc.invokeInterfaceMethod(StartupBuildSteps.CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instance, creationalContext});
            } else {
                ResultHandle instanceHandle = mc.invokeInterfaceMethod(StartupBuildSteps.ARC_CONTAINER_INSTANCE, containerHandle, new ResultHandle[]{beanHandle});
                ResultHandle instance = mc.invokeInterfaceMethod(StartupBuildSteps.INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
                mc.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)shutdownMethod), instance, new ResultHandle[0]);
            }
            mc.returnValue(null);
        });
        configurator.done();
    }
}

