/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.LazySourceDir;
import io.quarkus.bootstrap.workspace.SourceDir;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultArtifactSources
implements ArtifactSources,
Serializable {
    private static final long serialVersionUID = 2053702489268820757L;
    private final String classifier;
    private final Collection<SourceDir> sources;
    private final Collection<SourceDir> resources;

    static ArtifactSources fromMap(Map<String, Object> map) {
        List<SourceDir> resources;
        Collection resourcesMap;
        List<SourceDir> sources;
        String classifier = map.get("classifier").toString();
        Collection sourcesMap = (Collection)map.get("sources");
        if (sourcesMap != null) {
            sources = new ArrayList(sourcesMap.size());
            for (Map sourceMap : sourcesMap) {
                sources.add(LazySourceDir.fromMap(sourceMap));
            }
        } else {
            sources = Collections.emptyList();
        }
        if ((resourcesMap = (Collection)map.get("resources")) != null) {
            resources = new ArrayList(resourcesMap.size());
            for (Map resourceMap : resourcesMap) {
                resources.add(LazySourceDir.fromMap(resourceMap));
            }
        } else {
            resources = Collections.emptyList();
        }
        return new DefaultArtifactSources(classifier, sources, resources);
    }

    public DefaultArtifactSources(String classifier, Collection<SourceDir> sources, Collection<SourceDir> resources) {
        this.classifier = Objects.requireNonNull(classifier, "The classifier is null");
        this.sources = sources;
        this.resources = resources;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public void addSources(SourceDir src) {
        this.sources.add(src);
    }

    @Override
    public Collection<SourceDir> getSourceDirs() {
        return this.sources;
    }

    public void addResources(SourceDir src) {
        this.resources.add(src);
    }

    @Override
    public Collection<SourceDir> getResourceDirs() {
        return this.resources;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.classifier);
        if (s.length() > 0) {
            s.append(' ');
        }
        s.append("sources: ").append(this.sources);
        s.append(" resources: ").append(this.resources);
        return s.toString();
    }
}

