/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.javax.inject.Inject;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.scripts.DefaultScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class BuildLayoutFactory {
    private static final String DEFAULT_SETTINGS_FILE_BASENAME = "settings";
    private final ScriptFileResolver scriptFileResolver;

    @Inject
    public BuildLayoutFactory(ScriptFileResolver scriptFileResolver) {
        this.scriptFileResolver = scriptFileResolver;
    }

    public BuildLayoutFactory() {
        this(new DefaultScriptFileResolver());
    }

    public BuildLayout getLayoutFor(File currentDir, boolean shouldSearchUpwards) {
        boolean searchUpwards = shouldSearchUpwards && !this.isBuildSrc(currentDir);
        return this.getLayoutFor(currentDir, searchUpwards ? null : currentDir.getParentFile());
    }

    private boolean isBuildSrc(File currentDir) {
        return currentDir.getName().equals("buildSrc");
    }

    public BuildLayout getLayoutFor(BuildLayoutConfiguration configuration) {
        if (configuration.isUseEmptySettings()) {
            return this.buildLayoutFrom(configuration, null);
        }
        return this.getLayoutFor(configuration.getCurrentDir(), configuration.isSearchUpwards());
    }

    private BuildLayout buildLayoutFrom(BuildLayoutConfiguration configuration, File settingsFile) {
        return new BuildLayout(configuration.getCurrentDir(), configuration.getCurrentDir(), settingsFile, this.scriptFileResolver);
    }

    public @Nullable File findExistingSettingsFileIn(File directory) {
        return this.scriptFileResolver.resolveScriptFile(directory, DEFAULT_SETTINGS_FILE_BASENAME);
    }

    BuildLayout getLayoutFor(File currentDir, File stopAt) {
        File settingsFile = this.findExistingSettingsFileIn(currentDir);
        if (settingsFile != null) {
            return this.layout(currentDir, settingsFile);
        }
        for (File candidate = currentDir.getParentFile(); candidate != null && !candidate.equals(stopAt); candidate = candidate.getParentFile()) {
            settingsFile = this.findExistingSettingsFileIn(candidate);
            if (settingsFile == null) continue;
            return this.layout(candidate, settingsFile);
        }
        return this.layout(currentDir, new File(currentDir, "settings.gradle"));
    }

    private BuildLayout layout(File rootDir, File settingsFile) {
        return new BuildLayout(rootDir, settingsFile.getParentFile(), FileUtils.canonicalize(settingsFile), this.scriptFileResolver);
    }
}

