/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.DefaultDeprecationData;
import org.gradle.api.problems.internal.DefaultGeneralData;
import org.gradle.api.problems.internal.DefaultPropertyTraceData;
import org.gradle.api.problems.internal.DefaultTypeValidationData;
import org.gradle.api.problems.internal.DeprecationData;
import org.gradle.api.problems.internal.DeprecationDataSpec;
import org.gradle.api.problems.internal.GeneralData;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.PropertyTraceData;
import org.gradle.api.problems.internal.PropertyTraceDataSpec;
import org.gradle.api.problems.internal.TypeValidationData;
import org.gradle.api.problems.internal.TypeValidationDataSpec;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.org.jspecify.annotations.NonNull;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public final class AdditionalDataBuilderFactory {
    private final Map<Class<?>, DataTypeAndProvider> additionalDataProviders = new HashMap();

    public AdditionalDataBuilderFactory() {
        this.additionalDataProviders.put(GeneralDataSpec.class, new DataTypeAndProvider(GeneralData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

            @Override
            public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
                return DefaultGeneralData.builder((GeneralData)instance);
            }
        }));
        this.additionalDataProviders.put(DeprecationDataSpec.class, new DataTypeAndProvider(DeprecationData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

            @Override
            public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
                return DefaultDeprecationData.builder((DeprecationData)instance);
            }
        }));
        this.additionalDataProviders.put(TypeValidationDataSpec.class, new DataTypeAndProvider(TypeValidationData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

            @Override
            public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
                return DefaultTypeValidationData.builder((TypeValidationData)instance);
            }
        }));
        this.additionalDataProviders.put(PropertyTraceDataSpec.class, new DataTypeAndProvider(PropertyTraceData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

            @Override
            public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
                return DefaultPropertyTraceData.builder((PropertyTraceData)instance);
            }
        }));
    }

    public void registerAdditionalDataProvider(Class<?> dataType, Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>> provider) {
        if (this.additionalDataProviders.put(dataType, new DataTypeAndProvider(dataType, provider)) != null) {
            throw new IllegalArgumentException("Data type: '" + dataType + "' already has an additional data provider registered!");
        }
    }

    public String getSupportedTypes() {
        StringBuilder result = new StringBuilder();
        for (Class<?> key : this.additionalDataProviders.keySet()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key.getName());
        }
        return result.toString();
    }

    private <S extends AdditionalData, U extends AdditionalDataSpec> AdditionalDataBuilder<S> builderFor(Class<? extends U> specType, @Nullable S instance, String illegalArgumentMessage) {
        Preconditions.checkNotNull(specType);
        DataTypeAndProvider dataTypeAndProvider = this.additionalDataProviders.get(specType);
        if (dataTypeAndProvider != null) {
            return dataTypeAndProvider.builderProvider.apply(instance);
        }
        throw new IllegalArgumentException(illegalArgumentMessage);
    }

    public <U extends AdditionalDataSpec> AdditionalDataBuilder<? extends AdditionalData> createAdditionalDataBuilder(Class<? extends U> specType, @Nullable AdditionalData additionalData) {
        if (additionalData == null) {
            return this.builderFor(specType, null, "Unsupported type: " + specType);
        }
        if (this.isCompatible(specType, additionalData)) {
            return this.builderFor(specType, additionalData, "Unsupported instance: " + additionalData);
        }
        throw new IllegalArgumentException("Additional data of type " + additionalData.getClass() + " is already set");
    }

    public <U extends AdditionalDataSpec> boolean hasProviderForSpec(Class<? extends U> specType) {
        return this.additionalDataProviders.containsKey(specType);
    }

    private <U extends AdditionalDataSpec> boolean isCompatible(Class<? extends U> specType, @NonNull AdditionalData additionalData) {
        DataTypeAndProvider dataTypeAndProvider = this.additionalDataProviders.get(specType);
        return dataTypeAndProvider != null && dataTypeAndProvider.dataType.isInstance(additionalData);
    }

    private static class DataTypeAndProvider {
        final Class<?> dataType;
        final Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>> builderProvider;

        private DataTypeAndProvider(Class<?> dataType, Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>> builderProvider) {
            this.dataType = dataType;
            this.builderProvider = builderProvider;
        }
    }
}

