/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.json;

import io.quarkus.bootstrap.json.JsonMember;
import io.quarkus.bootstrap.json.JsonMultiValue;
import io.quarkus.bootstrap.json.JsonString;
import io.quarkus.bootstrap.json.JsonTransform;
import io.quarkus.bootstrap.json.JsonValue;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class JsonObject
implements JsonMultiValue {
    private final Map<JsonString, JsonValue> value;

    public JsonObject(Map<JsonString, JsonValue> value) {
        this.value = value;
    }

    public <T extends JsonValue> T get(String attribute) {
        return (T)this.value.get(new JsonString(attribute));
    }

    public List<JsonMember> members() {
        return this.value.entrySet().stream().map(e -> new JsonMember((JsonString)e.getKey(), (JsonValue)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public void forEach(JsonTransform transform) {
        this.members().forEach((? super T member) -> transform.accept(null, (JsonValue)member));
    }
}

