/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.json;

import io.quarkus.bootstrap.json.JsonArray;
import io.quarkus.bootstrap.json.JsonBoolean;
import io.quarkus.bootstrap.json.JsonDouble;
import io.quarkus.bootstrap.json.JsonInteger;
import io.quarkus.bootstrap.json.JsonNull;
import io.quarkus.bootstrap.json.JsonObject;
import io.quarkus.bootstrap.json.JsonString;
import io.quarkus.bootstrap.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JsonReader {
    private final String text;
    private final int length;
    private int position;

    private JsonReader(String text) {
        this.text = text;
        this.length = text.length();
    }

    public static JsonReader of(String source) {
        return new JsonReader(source);
    }

    public <T extends JsonValue> T read() {
        return (T)this.readElement();
    }

    private JsonValue readElement() {
        this.ignoreWhitespace();
        JsonValue result = this.readValue();
        this.ignoreWhitespace();
        return result;
    }

    private JsonValue readValue() {
        int ch = this.peekChar();
        if (ch < 0) {
            throw new IllegalArgumentException("Unable to fully read json value");
        }
        switch (ch) {
            case 123: {
                return this.readObject();
            }
            case 91: {
                return this.readArray();
            }
            case 34: {
                return this.readString();
            }
            case 116: {
                return this.readConstant("true", JsonBoolean.TRUE);
            }
            case 102: {
                return this.readConstant("false", JsonBoolean.FALSE);
            }
            case 110: {
                return this.readConstant("null", JsonNull.INSTANCE);
            }
        }
        if (Character.isDigit(ch) || 45 == ch) {
            return this.readNumber(this.position);
        }
        throw new IllegalArgumentException("Unknown start character for json value: " + ch);
    }

    private JsonValue readObject() {
        ++this.position;
        HashMap<JsonString, JsonValue> members = new HashMap<JsonString, JsonValue>();
        while (this.position < this.length) {
            this.ignoreWhitespace();
            switch (this.peekChar()) {
                case 125: {
                    ++this.position;
                    return new JsonObject(members);
                }
                case 44: {
                    ++this.position;
                    break;
                }
                case 34: {
                    this.readMember(members);
                }
            }
        }
        throw new IllegalArgumentException("Json object ended without }");
    }

    private void readMember(Map<JsonString, JsonValue> members) {
        JsonString attribute = this.readString();
        this.ignoreWhitespace();
        int colon = this.nextChar();
        if (58 != colon) {
            throw new IllegalArgumentException("Expected : after attribute");
        }
        JsonValue element = this.readElement();
        members.put(attribute, element);
    }

    private JsonValue readArray() {
        ++this.position;
        ArrayList<JsonValue> elements = new ArrayList<JsonValue>();
        block4: while (this.position < this.length) {
            this.ignoreWhitespace();
            switch (this.peekChar()) {
                case 93: {
                    ++this.position;
                    return new JsonArray(elements);
                }
                case 44: {
                    ++this.position;
                    continue block4;
                }
            }
            elements.add(this.readElement());
        }
        throw new IllegalArgumentException("Json array ended without ]");
    }

    private JsonString readString() {
        ++this.position;
        int start = this.position;
        StringBuilder unescapedValue = null;
        while (this.position < this.length) {
            int ch = this.nextChar();
            if (Character.isISOControl(ch)) {
                throw new IllegalArgumentException("Control characters not allowed in json string");
            }
            if (34 == ch) {
                String value = unescapedValue == null ? this.text.substring(start, this.position - 1) : unescapedValue.toString();
                return new JsonString(value);
            }
            if (92 == ch) {
                int escaped;
                if (unescapedValue == null) {
                    unescapedValue = new StringBuilder().append(this.text, start, this.position - 1);
                }
                if ((escaped = this.nextChar()) == 117) {
                    unescapedValue.append(this.readUnicode());
                    continue;
                }
                unescapedValue.appendCodePoint(JsonReader.unescape(escaped));
                continue;
            }
            if (unescapedValue == null) continue;
            unescapedValue.appendCodePoint(ch);
        }
        throw new IllegalArgumentException("String not closed");
    }

    private static int unescape(int ch) {
        return switch (ch) {
            case 98 -> 8;
            case 110 -> 10;
            case 116 -> 9;
            case 102 -> 12;
            case 114 -> 13;
            default -> ch;
        };
    }

    private char readUnicode() {
        int digit1 = Character.digit(this.nextChar(), 16);
        int digit2 = Character.digit(this.nextChar(), 16);
        int digit3 = Character.digit(this.nextChar(), 16);
        int digit4 = Character.digit(this.nextChar(), 16);
        return (char)(digit1 << 12 | digit2 << 8 | digit3 << 4 | digit4);
    }

    private JsonValue readNumber(int numStartIndex) {
        boolean isFraction = this.skipToEndOfNumber();
        String number = this.text.substring(numStartIndex, this.position);
        return isFraction ? new JsonDouble(Double.parseDouble(number)) : new JsonInteger(Long.parseLong(number));
    }

    private boolean skipToEndOfNumber() {
        int ch = this.nextChar();
        if (45 == ch) {
            ch = this.nextChar();
        }
        if (Character.isDigit(ch) && 48 != ch) {
            this.ignoreDigits();
        }
        boolean isFraction = false;
        ch = this.peekChar();
        if (46 == ch) {
            isFraction = true;
            ++this.position;
            this.ignoreDigits();
        }
        ch = this.peekChar();
        switch (ch) {
            case 69: 
            case 101: {
                ++this.position;
                ch = this.nextChar();
                switch (ch) {
                    case 43: 
                    case 45: {
                        ++this.position;
                    }
                }
                this.ignoreDigits();
            }
        }
        return isFraction;
    }

    private void ignoreDigits() {
        int ch;
        while (this.position < this.length && Character.isDigit(ch = this.peekChar())) {
            ++this.position;
        }
    }

    private JsonValue readConstant(String expected, JsonValue result) {
        if (this.text.regionMatches(this.position, expected, 0, expected.length())) {
            this.position += expected.length();
            return result;
        }
        throw new IllegalArgumentException("Unable to read json constant for: " + expected);
    }

    private void ignoreWhitespace() {
        block3: while (this.position < this.length) {
            int ch = this.peekChar();
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.position;
                    continue block3;
                }
            }
            return;
        }
    }

    private int peekChar() {
        return this.position < this.length ? (int)this.text.charAt(this.position) : -1;
    }

    private int nextChar() {
        int ch = this.peekChar();
        ++this.position;
        return ch;
    }
}

