/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.maven.workspace.UnresolvedVersionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Resource;

public class LocalProject {
    public static final String PROJECT_GROUPID = "${project.groupId}";
    private static final String PROJECT_BASEDIR = "${project.basedir}";
    private static final String PROJECT_BUILD_DIR = "${project.build.directory}";
    private static final String POM_XML = "pom.xml";
    private final Model rawModel;
    private final String groupId;
    private final String artifactId;
    private String version;
    private final Path dir;
    private final LocalWorkspace workspace;
    private final List<LocalProject> modules = new ArrayList<LocalProject>(0);
    private AppArtifactKey key;

    public static LocalProject load(Path path) throws BootstrapMavenException {
        return LocalProject.load(path, true);
    }

    public static LocalProject load(Path path, boolean required) throws BootstrapMavenException {
        Path pom = LocalProject.locateCurrentProjectPom(path, required);
        if (pom == null) {
            return null;
        }
        try {
            return new LocalProject(LocalProject.readModel(pom), null);
        }
        catch (UnresolvedVersionException e) {
            return LocalProject.loadWorkspace(pom);
        }
    }

    public static LocalProject loadWorkspace(Path path) throws BootstrapMavenException {
        return LocalProject.loadWorkspace(path, true);
    }

    public static LocalProject loadWorkspace(Path path, boolean required) throws BootstrapMavenException {
        try {
            return new WorkspaceLoader(path.normalize().toAbsolutePath()).load();
        }
        catch (Exception e) {
            if (required) {
                throw e;
            }
            return null;
        }
    }

    public static LocalProject loadWorkspace(BootstrapMavenContext ctx) throws BootstrapMavenException {
        Path currentProjectPom = ctx.getCurrentProjectPomOrNull();
        if (currentProjectPom == null) {
            return null;
        }
        Path rootProjectBaseDir = ctx.getRootProjectBaseDir();
        WorkspaceLoader wsLoader = new WorkspaceLoader(currentProjectPom);
        if (rootProjectBaseDir != null && !rootProjectBaseDir.equals(currentProjectPom.getParent())) {
            wsLoader.setWorkspaceRootPom(rootProjectBaseDir.resolve(POM_XML));
        }
        LocalProject lp = wsLoader.load();
        lp.getWorkspace().setBootstrapMavenContext(ctx);
        return lp;
    }

    private static final Model readModel(Path pom) throws BootstrapMavenException {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (IOException e) {
            throw new BootstrapMavenException("Failed to read " + pom, e);
        }
    }

    private static Path locateCurrentProjectPom(Path path, boolean required) throws BootstrapMavenException {
        for (Path p = path; p != null; p = p.getParent()) {
            Path pom = p.resolve(POM_XML);
            if (!Files.exists(pom, new LinkOption[0])) continue;
            return pom;
        }
        if (required) {
            throw new BootstrapMavenException("Failed to locate project pom.xml for " + path);
        }
        return null;
    }

    private LocalProject(Model rawModel, LocalWorkspace workspace) throws BootstrapMavenException {
        this.rawModel = rawModel;
        this.dir = rawModel.getProjectDirectory().toPath();
        this.workspace = workspace;
        this.groupId = ModelUtils.getGroupId(rawModel);
        this.artifactId = rawModel.getArtifactId();
        String rawVersion = ModelUtils.getRawVersion(rawModel);
        boolean rawVersionIsUnresolved = ModelUtils.isUnresolvedVersion(rawVersion);
        String string = this.version = rawVersionIsUnresolved ? ModelUtils.resolveVersion(rawVersion, rawModel) : rawVersion;
        if (workspace != null) {
            workspace.addProject(this, rawModel.getPomFile().lastModified());
            if (rawVersionIsUnresolved && this.version != null) {
                workspace.setResolvedVersion(this.version);
            }
        } else if (this.version == null && rawVersionIsUnresolved) {
            throw UnresolvedVersionException.forGa(this.groupId, this.artifactId, rawVersion);
        }
    }

    public LocalProject getLocalParent() {
        if (this.workspace == null) {
            return null;
        }
        Parent parent = this.rawModel.getParent();
        if (parent == null) {
            return null;
        }
        return this.workspace.getProject(parent.getGroupId(), parent.getArtifactId());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        if (this.workspace != null) {
            this.version = this.workspace.getResolvedVersion();
        }
        if (this.version == null) {
            throw UnresolvedVersionException.forGa(this.groupId, this.artifactId, ModelUtils.getRawVersion(this.rawModel));
        }
        return this.version;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getOutputDir() {
        return this.resolveRelativeToBaseDir(LocalProject.configuredBuildDir(this, build -> build.getDirectory()), "target");
    }

    public Path getCodeGenOutputDir() {
        return this.getOutputDir().resolve("generated-sources");
    }

    public Path getClassesDir() {
        return this.resolveRelativeToBuildDir(LocalProject.configuredBuildDir(this, build -> build.getOutputDirectory()), "classes");
    }

    public Path getTestClassesDir() {
        return this.resolveRelativeToBuildDir(LocalProject.configuredBuildDir(this, build -> build.getTestOutputDirectory()), "test-classes");
    }

    public Path getSourcesSourcesDir() {
        return this.resolveRelativeToBaseDir(LocalProject.configuredBuildDir(this, build -> build.getSourceDirectory()), "src/main/java");
    }

    public Path getSourcesDir() {
        return this.getSourcesSourcesDir().getParent();
    }

    public Path getResourcesSourcesDir() {
        List resources = this.rawModel.getBuild() == null ? Collections.emptyList() : this.rawModel.getBuild().getResources();
        String resourcesDir = resources.isEmpty() ? null : ((Resource)resources.get(0)).getDirectory();
        return this.resolveRelativeToBaseDir(resourcesDir, "src/main/resources");
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public AppArtifactKey getKey() {
        return this.key == null ? (this.key = new AppArtifactKey(this.groupId, this.artifactId)) : this.key;
    }

    public AppArtifact getAppArtifact() {
        return this.getAppArtifact(this.rawModel.getPackaging());
    }

    public AppArtifact getAppArtifact(String extension) {
        return new AppArtifact(this.groupId, this.artifactId, "", extension, this.getVersion());
    }

    private Path resolveRelativeToBaseDir(String path, String defaultPath) {
        return this.dir.resolve(path == null ? defaultPath : LocalProject.stripProjectBasedirPrefix(path, PROJECT_BASEDIR));
    }

    private Path resolveRelativeToBuildDir(String path, String defaultPath) {
        return this.getOutputDir().resolve(path == null ? defaultPath : LocalProject.stripProjectBasedirPrefix(path, PROJECT_BUILD_DIR));
    }

    private static String stripProjectBasedirPrefix(String path, String expr) {
        return path.startsWith(expr) ? path.substring(expr.length() + 1) : path;
    }

    private static String configuredBuildDir(LocalProject project, Function<Build, String> f) {
        String dir;
        String string = dir = project.rawModel.getBuild() == null ? null : f.apply(project.rawModel.getBuild());
        while (dir == null && (project = project.getLocalParent()) != null) {
            dir = project.rawModel.getBuild() == null ? null : f.apply(project.rawModel.getBuild());
        }
        return dir;
    }

    private static class WorkspaceLoader {
        private final LocalWorkspace workspace = new LocalWorkspace();
        private final Map<Path, LocalProject> projectCache = new HashMap<Path, LocalProject>();
        private final Path currentProjectPom;
        private Path workspaceRootPom;

        private WorkspaceLoader(Path currentProjectPom) throws BootstrapMavenException {
            this.currentProjectPom = this.isPom(currentProjectPom) ? currentProjectPom : LocalProject.locateCurrentProjectPom(currentProjectPom, true);
        }

        private boolean isPom(Path p) {
            if (Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0])) {
                try {
                    this.loadAndCache(p);
                    return true;
                }
                catch (BootstrapMavenException bootstrapMavenException) {
                    // empty catch block
                }
            }
            return false;
        }

        private LocalProject project(Path pomFile) throws BootstrapMavenException {
            LocalProject project = this.projectCache.get(pomFile.getParent());
            if (project == null) {
                project = this.loadAndCache(pomFile);
            }
            return project;
        }

        private LocalProject loadAndCache(Path pomFile) throws BootstrapMavenException {
            LocalProject project = new LocalProject(LocalProject.readModel(pomFile), this.workspace);
            this.projectCache.put(pomFile.getParent(), project);
            return project;
        }

        void setWorkspaceRootPom(Path rootPom) {
            this.workspaceRootPom = rootPom;
        }

        private LocalProject loadCurrentProject(Path projectPom) throws BootstrapMavenException {
            LocalProject currentProject = null;
            LocalProject childProject = null;
            do {
                LocalProject project = this.loadProjectWithModules(projectPom, childProject == null ? null : childProject.getDir().relativize(projectPom.getParent()).toString());
                if (childProject != null) {
                    project.modules.add(childProject);
                } else {
                    currentProject = project;
                }
                Parent parent = project.getRawModel().getParent();
                if (parent != null && parent.getRelativePath() != null && !parent.getRelativePath().isEmpty()) {
                    projectPom = project.getDir().resolve(parent.getRelativePath()).normalize();
                    if (Files.isDirectory(projectPom, new LinkOption[0])) {
                        projectPom = projectPom.resolve(LocalProject.POM_XML);
                    }
                } else {
                    Path parentDir = project.getDir().getParent();
                    if (parentDir == null) break;
                    projectPom = parentDir.resolve(LocalProject.POM_XML);
                }
                childProject = project;
            } while (Files.exists(projectPom, new LinkOption[0]) && !this.projectCache.containsKey(projectPom.getParent()));
            return currentProject;
        }

        private LocalProject loadProjectWithModules(Path projectPom, String skipModule) throws BootstrapMavenException {
            LocalProject project = this.project(projectPom);
            List modules = project.getRawModel().getModules();
            if (!modules.isEmpty()) {
                for (String module : modules) {
                    if (module.equals(skipModule)) continue;
                    project.modules.add(this.loadProjectWithModules(project.getDir().resolve(module).resolve(LocalProject.POM_XML), null));
                }
            }
            return project;
        }

        LocalProject load() throws BootstrapMavenException {
            LocalProject currentProject = this.loadCurrentProject(this.currentProjectPom);
            if (this.workspace != null) {
                this.workspace.setCurrentProject(currentProject);
            }
            if (this.workspaceRootPom != null && !this.projectCache.containsKey(this.workspaceRootPom.getParent())) {
                this.loadCurrentProject(this.workspaceRootPom);
            }
            return currentProject;
        }
    }
}

