/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.LocalPomResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;

class LocalRepoModelResolver
implements ModelResolver,
LocalPomResolver {
    private final List<LocalPomResolver> pomResolvers;

    static LocalRepoModelResolver of(LocalPomResolver ... pomResolvers) {
        return new LocalRepoModelResolver(List.of(pomResolvers));
    }

    LocalRepoModelResolver(List<LocalPomResolver> pomResolvers) {
        this.pomResolvers = pomResolvers;
    }

    @Override
    public File resolvePom(String groupId, String artifactId, String version) {
        for (LocalPomResolver pomResolver : this.pomResolvers) {
            File pom = pomResolver.resolvePom(groupId, artifactId, version);
            if (pom == null) continue;
            return pom;
        }
        return null;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        final File pomXml = this.resolvePom(groupId, artifactId, version);
        if (pomXml == null) {
            throw new UnresolvableModelException("Has not been previously resolved", groupId, artifactId, version);
        }
        return new ModelSource2(){

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(pomXml);
            }

            public String getLocation() {
                return pomXml.getAbsolutePath();
            }

            public ModelSource2 getRelatedSource(String relPath) {
                return null;
            }

            public URI getLocationURI() {
                return null;
            }
        };
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
    }

    public ModelResolver newCopy() {
        return this;
    }
}

