/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersion;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersionConstraint;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BuildDependencyGraphVisitor;
import io.quarkus.bootstrap.resolver.maven.DeploymentDependencySelector;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.ExtensionInfo;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.OrderedDependencyVisitor;
import io.quarkus.bootstrap.resolver.maven.SimpleDependencyGraphTransformationContext;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictMarker;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.jboss.logging.Logger;

@Deprecated(since="3.19.0", forRemoval=true)
public class ApplicationDependencyTreeResolver {
    private static final Logger log = Logger.getLogger(ApplicationDependencyTreeResolver.class);
    private static final String QUARKUS_RUNTIME_ARTIFACT = "quarkus.runtime";
    private static final String QUARKUS_EXTENSION_DEPENDENCY = "quarkus.ext";
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;
    private static final byte COLLECT_DEPLOYMENT_INJECTION_POINTS = 8;
    private static final boolean CONVERGED_TREE_ONLY = PropertyUtils.getBoolean((String)"quarkus.bootstrap.converged-tree-only", (boolean)false);
    private byte walkingFlags = (byte)11;
    private final List<ExtensionDependency> deploymentInjectionPoints = new ArrayList<ExtensionDependency>();
    private ExtensionDependency currentTopLevelExtension;
    private final Map<ArtifactKey, ExtensionInfo> allExtensions = new HashMap<ArtifactKey, ExtensionInfo>();
    private List<ConditionalDependency> conditionalDepsToProcess = new ArrayList<ConditionalDependency>();
    private final Deque<Collection<Exclusion>> exclusionStack = new ArrayDeque<Collection<Exclusion>>();
    private final Map<ArtifactCoords, Set<ArtifactKey>> artifactDeps = new HashMap<ArtifactCoords, Set<ArtifactKey>>();
    private MavenArtifactResolver resolver;
    private Map<ArtifactKey, Dependency> managedDeps;
    private ApplicationModelBuilder appBuilder;
    private boolean collectReloadableModules;
    private Consumer<String> buildTreeConsumer;
    private List<Dependency> collectCompileOnly;
    private boolean runtimeModelOnly;
    private boolean devMode;

    public static ApplicationDependencyTreeResolver newInstance() {
        return new ApplicationDependencyTreeResolver();
    }

    public static Artifact getRuntimeArtifact(DependencyNode dep) {
        return (Artifact)dep.getData().get(QUARKUS_RUNTIME_ARTIFACT);
    }

    public ApplicationDependencyTreeResolver setArtifactResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ApplicationDependencyTreeResolver setApplicationModelBuilder(ApplicationModelBuilder appBuilder) {
        this.appBuilder = appBuilder;
        return this;
    }

    public ApplicationDependencyTreeResolver setCollectReloadableModules(boolean collectReloadableModules) {
        this.collectReloadableModules = collectReloadableModules;
        return this;
    }

    public ApplicationDependencyTreeResolver setBuildTreeConsumer(Consumer<String> buildTreeConsumer) {
        this.buildTreeConsumer = buildTreeConsumer;
        return this;
    }

    public ApplicationDependencyTreeResolver setCollectCompileOnly(List<Dependency> collectCompileOnly) {
        this.collectCompileOnly = collectCompileOnly;
        return this;
    }

    public ApplicationDependencyTreeResolver setRuntimeModelOnly(boolean runtimeModelOnly) {
        this.runtimeModelOnly = runtimeModelOnly;
        return this;
    }

    public ApplicationDependencyTreeResolver setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public ApplicationDependencyTreeResolver setManagedDependencies(Map<ArtifactKey, Dependency> managedDeps) {
        this.managedDeps = managedDeps;
        return this;
    }

    public void resolve(CollectRequest collectRtDepsRequest) throws AppModelResolverException {
        DependencyNode root = this.resolveRuntimeDeps(collectRtDepsRequest);
        if (this.collectReloadableModules) {
            this.setWalkingFlag((byte)4);
        }
        MavenArtifactResolver originalResolver = this.resolver;
        RepositorySystemSession originalSession = this.resolver.getSession();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(originalSession);
        session.setDependencySelector(DeploymentDependencySelector.ensureDeploymentDependencySelector(session.getDependencySelector()));
        try {
            this.resolver = new MavenArtifactResolver(new BootstrapMavenContext((BootstrapMavenContextConfig<?>)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)BootstrapMavenContext.config().setRepositorySystem(this.resolver.getSystem())).setRepositorySystemSession((RepositorySystemSession)session)).setRemoteRepositories(this.resolver.getRepositories())).setRemoteRepositoryManager(this.resolver.getRemoteRepositoryManager())).setCurrentProject(this.resolver.getMavenContext().getCurrentProject())).setWorkspaceDiscovery(false)));
        }
        catch (BootstrapMavenException e) {
            throw new BootstrapDependencyProcessingException("Failed to initialize deployment dependencies resolver", (Throwable)((Object)e));
        }
        this.visitRuntimeDependencies(root.getChildren());
        this.enableConditionalDeps();
        if (!this.runtimeModelOnly) {
            for (ExtensionDependency extDep : this.deploymentInjectionPoints) {
                this.injectDeploymentDependencies(extDep);
            }
        }
        root = this.normalize(originalSession, root);
        new BuildDependencyGraphVisitor(originalResolver, this.appBuilder, this.buildTreeConsumer).visit(root);
        if (!CONVERGED_TREE_ONLY && this.collectReloadableModules) {
            for (ResolvedDependencyBuilder db : this.appBuilder.getDependencies()) {
                if (db.isFlagSet(2112)) continue;
                this.clearReloadableFlag(db);
            }
        }
        for (ResolvedDependencyBuilder db : this.appBuilder.getDependencies()) {
            db.clearFlag(2048);
            this.appBuilder.addDependency(db);
        }
        this.collectPlatformProperties();
        if (!this.runtimeModelOnly) {
            this.collectCompileOnly(collectRtDepsRequest, root);
        }
    }

    private void enableConditionalDeps() {
        if (!this.conditionalDepsToProcess.isEmpty()) {
            List<ConditionalDependency> unsatisfiedConditionalDeps = new ArrayList<ConditionalDependency>();
            while (!this.conditionalDepsToProcess.isEmpty()) {
                ArrayList<ConditionalDependency> tmp = unsatisfiedConditionalDeps;
                unsatisfiedConditionalDeps = this.conditionalDepsToProcess;
                this.conditionalDepsToProcess = tmp;
                int totalConditionsToProcess = unsatisfiedConditionalDeps.size();
                Iterator<ConditionalDependency> i = unsatisfiedConditionalDeps.iterator();
                while (i.hasNext()) {
                    ConditionalDependency cd = i.next();
                    if (!cd.isSatisfied()) continue;
                    i.remove();
                    cd.activate();
                }
                if (totalConditionsToProcess == unsatisfiedConditionalDeps.size()) break;
                this.conditionalDepsToProcess.addAll(unsatisfiedConditionalDeps);
                unsatisfiedConditionalDeps.clear();
            }
        }
    }

    private void collectCompileOnly(CollectRequest collectRtDepsRequest, DependencyNode root) throws BootstrapMavenException {
        if (this.collectCompileOnly.isEmpty()) {
            return;
        }
        ArrayDeque<List> depStack = new ArrayDeque<List>();
        List children = root.getChildren();
        while (children != null) {
            for (DependencyNode node : children) {
                this.managedDeps.putIfAbsent(DependencyUtils.getKey(node.getArtifact()), node.getDependency());
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            children = (List)depStack.poll();
        }
        CollectRequest request = new CollectRequest().setDependencies(this.collectCompileOnly).setManagedDependencies(new ArrayList<Dependency>(this.managedDeps.values())).setRepositories(collectRtDepsRequest.getRepositories());
        if (collectRtDepsRequest.getRoot() != null) {
            request.setRoot(collectRtDepsRequest.getRoot());
        } else {
            request.setRootArtifact(collectRtDepsRequest.getRootArtifact());
        }
        try {
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapDependencyProcessingException("Failed to collect compile-only dependencies of " + String.valueOf(root.getArtifact()), e);
        }
        children = root.getChildren();
        int flags = 4098;
        while (children != null) {
            for (DependencyNode node : children) {
                ExtensionInfo extInfo = this.getExtensionInfoOrNull(node.getArtifact(), node.getRepositories());
                ResolvedDependencyBuilder dep = this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact()));
                if (dep == null) {
                    dep = (ResolvedDependencyBuilder)DependencyUtils.newDependencyBuilder(node, this.resolver).setFlags(flags);
                    if (extInfo != null) {
                        dep.setFlags(16);
                        if (dep.isFlagSet(2)) {
                            dep.setFlags(128);
                        }
                    }
                    this.appBuilder.addDependency(dep);
                } else {
                    dep.setFlags(4096);
                }
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            flags = 4096;
            children = (List)depStack.poll();
        }
    }

    private void collectPlatformProperties() throws AppModelResolverException {
        PlatformImportsImpl platformReleases = new PlatformImportsImpl();
        for (Dependency d : this.managedDeps.values()) {
            Artifact artifact = d.getArtifact();
            String extension = artifact.getExtension();
            String artifactId = artifact.getArtifactId();
            if ("json".equals(extension) && artifactId.endsWith("-quarkus-platform-descriptor")) {
                platformReleases.addPlatformDescriptor(artifact.getGroupId(), artifactId, artifact.getClassifier(), extension, artifact.getVersion());
                continue;
            }
            if (!"properties".equals(artifact.getExtension()) || !artifactId.endsWith("-quarkus-platform-properties")) continue;
            platformReleases.addPlatformProperties(artifact.getGroupId(), artifactId, artifact.getClassifier(), extension, artifact.getVersion(), this.resolver.resolve(artifact).getArtifact().getFile().toPath());
        }
        this.appBuilder.setPlatformImports((PlatformImports)platformReleases);
    }

    private void clearReloadableFlag(ResolvedDependencyBuilder db) {
        Set<ArtifactKey> deps = this.artifactDeps.get(db.getArtifactCoords());
        if (deps == null || deps.isEmpty()) {
            return;
        }
        for (ArtifactKey key : deps) {
            ResolvedDependencyBuilder dep = this.appBuilder.getDependency(key);
            if (dep == null || dep.isFlagSet(2048)) continue;
            dep.setFlags(2048);
            dep.clearFlag(64);
            this.clearReloadableFlag(dep);
        }
    }

    private DependencyNode normalize(RepositorySystemSession session, DependencyNode root) throws AppModelResolverException {
        SimpleDependencyGraphTransformationContext context = new SimpleDependencyGraphTransformationContext(session);
        try {
            root = new ConflictMarker().transformGraph(root, (DependencyGraphTransformationContext)context);
            root = new ConflictIdSorter().transformGraph(root, (DependencyGraphTransformationContext)context);
            root = session.getDependencyGraphTransformer().transformGraph(root, (DependencyGraphTransformationContext)context);
        }
        catch (RepositoryException e) {
            throw new AppModelResolverException("Failed to normalize the dependency graph", (Throwable)e);
        }
        return root;
    }

    private DependencyNode resolveRuntimeDeps(CollectRequest request) throws AppModelResolverException {
        RepositorySystemSession session = this.resolver.getSession();
        if (!CONVERGED_TREE_ONLY && this.collectReloadableModules) {
            DefaultRepositorySystemSession mutableSession = new DefaultRepositorySystemSession(this.resolver.getSession());
            mutableSession.setDependencyGraphTransformer(new DependencyGraphTransformer(){

                public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
                    IdentityHashMap<DependencyNode, DependencyNode> visited = new IdentityHashMap<DependencyNode, DependencyNode>();
                    for (DependencyNode c : node.getChildren()) {
                        this.walk(c, visited);
                    }
                    return ApplicationDependencyTreeResolver.this.resolver.getSession().getDependencyGraphTransformer().transformGraph(node, context);
                }

                private void walk(DependencyNode node, Map<DependencyNode, DependencyNode> visited) {
                    if (visited.put(node, node) != null || node.getChildren().isEmpty()) {
                        return;
                    }
                    Set deps = ApplicationDependencyTreeResolver.this.artifactDeps.computeIfAbsent(DependencyUtils.getCoords(node.getArtifact()), k -> new HashSet(node.getChildren().size()));
                    for (DependencyNode c : node.getChildren()) {
                        deps.add(DependencyUtils.getKey(c.getArtifact()));
                        this.walk(c, visited);
                    }
                }
            });
            session = mutableSession;
        }
        try {
            return this.resolver.getSystem().resolveDependencies(session, new DependencyRequest().setCollectRequest(request)).getRoot();
        }
        catch (DependencyResolutionException e) {
            Artifact a = request.getRoot() == null ? request.getRootArtifact() : request.getRoot().getArtifact();
            throw new BootstrapMavenException("Failed to resolve dependencies for " + String.valueOf(a), e);
        }
    }

    private boolean isRuntimeArtifact(ArtifactKey key) {
        ResolvedDependencyBuilder dep = this.appBuilder.getDependency(key);
        return dep != null && dep.isFlagSet(4);
    }

    private void visitRuntimeDependencies(List<DependencyNode> list) {
        for (DependencyNode n : list) {
            this.visitRuntimeDependency(n);
        }
    }

    private void visitRuntimeDependency(DependencyNode node) {
        Artifact artifact;
        ArtifactKey key;
        ResolvedDependencyBuilder dep;
        boolean popExclusions;
        byte prevWalkingFlags = this.walkingFlags;
        boolean bl = popExclusions = !node.getDependency().getExclusions().isEmpty();
        if (popExclusions) {
            this.exclusionStack.addLast(node.getDependency().getExclusions());
        }
        if ((dep = this.appBuilder.getDependency(key = DependencyUtils.getKey(artifact = node.getArtifact()))) == null) {
            artifact = this.resolve(artifact, node.getRepositories());
        }
        try {
            ExtensionDependency extDep = this.getExtensionDependencyOrNull(node, artifact);
            if (dep == null) {
                if (!node.getRelocations().isEmpty()) {
                    ((DefaultDependencyNode)node).setRelocations(List.of());
                }
                WorkspaceModule module = null;
                if (this.resolver.getProjectModuleResolver() != null) {
                    module = this.resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                }
                if ("provided".equals((dep = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(artifact, module).setOptional(node.getDependency().isOptional())).setScope(node.getDependency().getScope())).setDirect(this.isWalkingFlagOn((byte)2))).setRuntimeCp()).setDeploymentCp()).getScope())) {
                    dep.setFlags(4096);
                }
                if (extDep != null) {
                    ArtifactKey deploymentKey;
                    dep.setRuntimeExtensionArtifact();
                    if (this.isWalkingFlagOn((byte)1)) {
                        dep.setFlags(128);
                    }
                    if (!this.managedDeps.containsKey(deploymentKey = DependencyUtils.getKey(extDep.info.deploymentArtifact))) {
                        this.managedDeps.put(deploymentKey, new Dependency(extDep.info.deploymentArtifact, "compile"));
                    }
                    this.collectConditionalDependencies(extDep);
                }
                if (this.isWalkingFlagOn((byte)4)) {
                    if (module != null) {
                        dep.setReloadable();
                        this.appBuilder.addReloadableWorkspaceModule(key);
                    } else {
                        this.clearWalkingFlag((byte)4);
                    }
                }
                this.appBuilder.addDependency(dep);
            }
            this.clearWalkingFlag((byte)2);
            if (extDep != null) {
                extDep.info.ensureActivated(this.appBuilder);
                this.visitExtensionDependency(extDep);
            }
            this.visitRuntimeDependencies(node.getChildren());
        }
        catch (DeploymentInjectionException e) {
            throw e;
        }
        catch (Exception t) {
            throw new DeploymentInjectionException("Failed to inject extension deployment dependencies", t);
        }
        if (popExclusions) {
            this.exclusionStack.pollLast();
        }
        this.walkingFlags = prevWalkingFlags;
    }

    private ExtensionDependency getExtensionDependencyOrNull(DependencyNode node, Artifact artifact) throws BootstrapDependencyProcessingException {
        ExtensionDependency extDep = ExtensionDependency.get(node);
        if (extDep != null) {
            return extDep;
        }
        ExtensionInfo extInfo = this.getExtensionInfoOrNull(artifact, node.getRepositories());
        if (extInfo != null) {
            Collection<Exclusion> exclusions;
            if (this.exclusionStack.isEmpty()) {
                exclusions = List.of();
            } else if (this.exclusionStack.size() == 1) {
                exclusions = this.exclusionStack.peekLast();
            } else {
                exclusions = new ArrayList<Exclusion>();
                for (Collection<Exclusion> set : this.exclusionStack) {
                    exclusions.addAll(set);
                }
            }
            return new ExtensionDependency(extInfo, node, exclusions);
        }
        return null;
    }

    private void visitExtensionDependency(ExtensionDependency extDep) {
        if (this.clearWalkingFlag((byte)1)) {
            this.currentTopLevelExtension = extDep;
        } else if (this.currentTopLevelExtension != null) {
            this.currentTopLevelExtension.addExtensionDependency(extDep);
        }
        if (this.clearWalkingFlag((byte)8)) {
            this.deploymentInjectionPoints.add(extDep);
        }
    }

    private void collectConditionalDependencies(ExtensionDependency dependent) throws BootstrapDependencyProcessingException {
        if (dependent.info.conditionalDeps.length == 0 || dependent.conditionalDepsQueued) {
            return;
        }
        dependent.conditionalDepsQueued = true;
        ExclusionDependencySelector selector = dependent.exclusions == null ? null : new ExclusionDependencySelector(dependent.exclusions);
        for (Artifact conditionalArtifact : dependent.info.conditionalDeps) {
            ExtensionInfo condExtInfo;
            if (selector != null && !selector.selectDependency(new Dependency(conditionalArtifact, "runtime")) || (condExtInfo = this.getExtensionInfoOrNull(conditionalArtifact = this.resolve(conditionalArtifact, dependent.runtimeNode.getRepositories()), dependent.runtimeNode.getRepositories())) != null && condExtInfo.activated) continue;
            ConditionalDependency conditionalDep = new ConditionalDependency(conditionalArtifact, condExtInfo, dependent);
            this.conditionalDepsToProcess.add(conditionalDep);
            if (condExtInfo == null) continue;
            this.collectConditionalDependencies(conditionalDep.getExtensionDependency());
        }
    }

    private ExtensionInfo getExtensionInfoOrNull(Artifact artifact, List<RemoteRepository> repos) throws BootstrapDependencyProcessingException {
        if (!artifact.getExtension().equals("jar")) {
            return null;
        }
        ArtifactKey extKey = DependencyUtils.getKey(artifact);
        ExtensionInfo ext = this.allExtensions.get(extKey);
        if (ext != null) {
            return ext;
        }
        Path path = (artifact = this.resolve(artifact, repos)).getFile().toPath();
        Properties descriptor = (Properties)PathTree.ofDirectoryOrArchive((Path)path).apply("META-INF/quarkus-extension.properties", ApplicationDependencyTreeResolver::readExtensionProperties);
        if (descriptor != null) {
            ext = new ExtensionInfo(artifact, descriptor, this.devMode);
            this.allExtensions.put(extKey, ext);
        }
        return ext;
    }

    private static Properties readExtensionProperties(PathVisit visit) {
        if (visit == null) {
            return null;
        }
        try {
            Properties rtProps = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                rtProps.load(reader);
            }
            return rtProps;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void injectDeploymentDependencies(ExtensionDependency extDep) throws BootstrapDependencyProcessingException {
        log.debugf("Injecting deployment dependency %s", (Object)extDep.info.deploymentArtifact);
        DependencyNode deploymentNode = this.collectDependencies(extDep.info.deploymentArtifact, extDep.exclusions, extDep.runtimeNode.getRepositories());
        if (deploymentNode.getChildren().isEmpty()) {
            throw new BootstrapDependencyProcessingException("Failed to collect dependencies of " + String.valueOf(deploymentNode.getArtifact()) + ": either its POM could not be resolved from the available Maven repositories or the artifact does not have any dependencies while at least a dependency on the runtime artifact " + String.valueOf(extDep.info.runtimeArtifact) + " is expected");
        }
        if (this.resolver.getProjectModuleResolver() != null && this.collectReloadableModules) {
            this.clearReloadable(deploymentNode);
        }
        extDep.replaceRuntimeExtensionNodes(deploymentNode);
        if (!extDep.presentInTargetGraph) {
            throw new BootstrapDependencyProcessingException("Quarkus extension deployment artifact " + String.valueOf(deploymentNode.getArtifact()) + " does not appear to depend on the corresponding runtime artifact " + String.valueOf(extDep.info.runtimeArtifact));
        }
        DependencyNode runtimeNode = extDep.runtimeNode;
        runtimeNode.setData((Object)QUARKUS_RUNTIME_ARTIFACT, (Object)runtimeNode.getArtifact());
        runtimeNode.setArtifact(deploymentNode.getArtifact());
        runtimeNode.getDependency().setArtifact(deploymentNode.getArtifact());
        runtimeNode.setChildren(deploymentNode.getChildren());
    }

    private void clearReloadable(DependencyNode node) {
        for (DependencyNode child : node.getChildren()) {
            this.clearReloadable(child);
        }
        ResolvedDependencyBuilder dep = this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact()));
        if (dep != null) {
            dep.clearFlag(64);
        }
    }

    private DependencyNode collectDependencies(Artifact artifact, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        CollectRequest request;
        if (this.managedDeps.isEmpty()) {
            request = new CollectRequest().setRoot(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions)).setRepositories(repos);
        } else {
            ArrayList<Dependency> effectiveManagedDeps;
            Map<ArtifactKey, Dependency> effectiveManagedMap;
            ArtifactDescriptorResult descr;
            try {
                descr = this.resolver.resolveDescriptor(artifact, repos);
            }
            catch (BootstrapMavenException e) {
                throw new DeploymentInjectionException("Failed to resolve descriptor for " + String.valueOf(artifact), (Throwable)((Object)e));
            }
            if (descr.getManagedDependencies().isEmpty()) {
                effectiveManagedMap = this.managedDeps;
                effectiveManagedDeps = new ArrayList<Dependency>(this.managedDeps.values());
            } else {
                effectiveManagedMap = new HashMap<ArtifactKey, Dependency>(this.managedDeps);
                DependencyUtils.putAll(effectiveManagedMap, descr.getManagedDependencies());
                effectiveManagedDeps = new ArrayList<Dependency>(effectiveManagedMap.values());
            }
            List<Dependency> directDeps = DependencyUtils.mergeDependencies(List.of(), descr.getDependencies(), effectiveManagedMap, Set.of("provided", "test"));
            request = new CollectRequest().setDependencies(directDeps).setManagedDependencies(effectiveManagedDeps).setRepositories(repos);
            if (exclusions.isEmpty()) {
                request.setRootArtifact(artifact);
            } else {
                request.setRoot(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions));
            }
        }
        try {
            return this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new DeploymentInjectionException("Failed to collect dependencies for " + String.valueOf(artifact), e);
        }
    }

    private Artifact resolve(Artifact artifact, List<RemoteRepository> repos) {
        if (artifact.getFile() != null) {
            return artifact;
        }
        try {
            return this.resolver.getSystem().resolveArtifact(this.resolver.getSession(), new ArtifactRequest().setArtifact(artifact).setRepositories(repos)).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new DeploymentInjectionException("Failed to resolve artifact " + String.valueOf(artifact), e);
        }
    }

    private void setWalkingFlag(byte flag) {
        this.walkingFlags = (byte)(this.walkingFlags | flag);
    }

    private boolean isWalkingFlagOn(byte flag) {
        return (this.walkingFlags & flag) == flag;
    }

    private boolean clearWalkingFlag(byte flags) {
        this.walkingFlags = (byte)(this.walkingFlags & (byte)(this.walkingFlags ^ flags));
        return this.walkingFlags != this.walkingFlags;
    }

    private static boolean isSameKey(Artifact a1, Artifact a2) {
        return a2.getArtifactId().equals(a1.getArtifactId()) && a2.getGroupId().equals(a1.getGroupId()) && a2.getClassifier().equals(a1.getClassifier()) && a2.getExtension().equals(a1.getExtension());
    }

    private static class ExtensionDependency {
        final ExtensionInfo info;
        final DependencyNode runtimeNode;
        final Collection<Exclusion> exclusions;
        boolean conditionalDepsQueued;
        private List<ExtensionDependency> extDeps;
        private boolean presentInTargetGraph;

        static ExtensionDependency get(DependencyNode node) {
            return (ExtensionDependency)node.getData().get(ApplicationDependencyTreeResolver.QUARKUS_EXTENSION_DEPENDENCY);
        }

        private ExtensionDependency(ExtensionInfo info, DependencyNode node, Collection<Exclusion> exclusions) {
            this.runtimeNode = node;
            this.info = info;
            this.exclusions = exclusions;
            Map data = node.getData();
            if (data.isEmpty()) {
                node.setData((Object)ApplicationDependencyTreeResolver.QUARKUS_EXTENSION_DEPENDENCY, (Object)this);
            } else if (data.put(ApplicationDependencyTreeResolver.QUARKUS_EXTENSION_DEPENDENCY, this) != null) {
                throw new IllegalStateException("Dependency node " + String.valueOf(node) + " has already been associated with an extension dependency");
            }
        }

        private void addExtensionDependency(ExtensionDependency dep) {
            if (this.extDeps == null) {
                this.extDeps = new ArrayList<ExtensionDependency>();
            }
            this.extDeps.add(dep);
        }

        private void replaceRuntimeExtensionNodes(DependencyNode deploymentNode) {
            int nodesToReplace;
            OrderedDependencyVisitor deploymentVisitor = new OrderedDependencyVisitor(deploymentNode);
            deploymentVisitor.next();
            int n = nodesToReplace = this.extDeps == null ? 1 : this.extDeps.size() + 1;
            block0: while (deploymentVisitor.hasNext() && nodesToReplace > 0) {
                deploymentVisitor.next();
                if (this.replaceRuntimeNode(deploymentVisitor)) {
                    --nodesToReplace;
                    continue;
                }
                if (this.extDeps == null) continue;
                for (int i = 0; i < this.extDeps.size(); ++i) {
                    if (!this.extDeps.get(i).replaceRuntimeNode(deploymentVisitor)) continue;
                    --nodesToReplace;
                    continue block0;
                }
            }
        }

        private boolean replaceRuntimeNode(OrderedDependencyVisitor depVisitor) {
            if (!this.presentInTargetGraph && ApplicationDependencyTreeResolver.isSameKey(this.runtimeNode.getArtifact(), depVisitor.getCurrent().getArtifact())) {
                DefaultDependencyNode inserted = new DefaultDependencyNode(this.runtimeNode);
                inserted.setChildren(this.runtimeNode.getChildren());
                depVisitor.replaceCurrent((DependencyNode)inserted);
                this.presentInTargetGraph = true;
                return true;
            }
            return false;
        }
    }

    private class ConditionalDependency {
        final Artifact artifact;
        final ExtensionInfo info;
        final ExtensionDependency dependent;
        private ExtensionDependency dependency;
        private boolean activated;

        private ConditionalDependency(Artifact artifact, ExtensionInfo info, ExtensionDependency dependent) {
            this.artifact = Objects.requireNonNull(artifact, "artifact is null");
            this.info = info;
            this.dependent = dependent;
        }

        ExtensionDependency getExtensionDependency() {
            if (this.dependency == null && this.info != null) {
                this.dependency = new ExtensionDependency(this.info, this.initDependencyNode(), this.dependent.exclusions);
            }
            return this.dependency;
        }

        private DependencyNode initDependencyNode() {
            DefaultDependencyNode rtNode = new DefaultDependencyNode(new Dependency(this.artifact, "compile"));
            rtNode.setVersion((Version)new BootstrapArtifactVersion(this.artifact.getVersion()));
            rtNode.setVersionConstraint((VersionConstraint)new BootstrapArtifactVersionConstraint(new BootstrapArtifactVersion(this.artifact.getVersion())));
            rtNode.setRepositories(this.dependent.runtimeNode.getRepositories());
            return rtNode;
        }

        void activate() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            DependencyNode originalNode = ApplicationDependencyTreeResolver.this.collectDependencies(this.artifact, this.dependent.exclusions, this.dependent.runtimeNode.getRepositories());
            ApplicationDependencyTreeResolver.this.clearWalkingFlag((byte)3);
            ExtensionDependency extDep = this.getExtensionDependency();
            DependencyNode rtNode = extDep == null ? this.initDependencyNode() : extDep.runtimeNode;
            ((DefaultDependencyNode)rtNode).setRepositories(originalNode.getRepositories());
            if (rtNode.getChildren().isEmpty()) {
                rtNode.setChildren(originalNode.getChildren());
            } else {
                rtNode.getChildren().addAll(originalNode.getChildren());
            }
            ApplicationDependencyTreeResolver.this.currentTopLevelExtension = null;
            ApplicationDependencyTreeResolver.this.setWalkingFlag((byte)8);
            ApplicationDependencyTreeResolver.this.visitRuntimeDependency(rtNode);
            this.dependent.runtimeNode.getChildren().add(rtNode);
        }

        boolean isSatisfied() {
            if (this.info == null || this.info.dependencyCondition == null) {
                return true;
            }
            for (ArtifactKey key : this.info.dependencyCondition) {
                if (ApplicationDependencyTreeResolver.this.isRuntimeArtifact(key)) continue;
                return false;
            }
            return true;
        }
    }
}

