/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.ModelResolutionTask;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskErrorHandler;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jboss.logging.Logger;

public class FailAtCompletionErrorHandler
implements ModelResolutionTaskErrorHandler {
    private static final Logger log = Logger.getLogger(FailAtCompletionErrorHandler.class);
    private final Collection<Exception> errors = new ConcurrentLinkedDeque<Exception>();

    @Override
    public void handleError(ModelResolutionTask task, Exception error) {
        this.errors.add(error);
    }

    @Override
    public void allTasksFinished() {
        if (!this.errors.isEmpty()) {
            FailAtCompletionErrorHandler.throwFailureReport(this.errors);
        }
    }

    protected boolean isEmpty() {
        return this.errors.isEmpty();
    }

    private static void throwFailureReport(Collection<Exception> errors) {
        StringBuilder sb = new StringBuilder("The following errors were encountered while processing Quarkus application dependencies:");
        log.error((Object)sb);
        int i = 1;
        block0: for (Exception error : errors) {
            String prefix = i++ + ")";
            log.error((Object)prefix, (Throwable)error);
            sb.append(System.lineSeparator()).append(prefix).append(" ").append(error.getLocalizedMessage());
            for (StackTraceElement e : error.getStackTrace()) {
                int j;
                sb.append(System.lineSeparator());
                for (j = 0; j < prefix.length(); ++j) {
                    sb.append(" ");
                }
                sb.append("at ").append(e);
                if (!e.getClassName().contains("io.quarkus")) continue;
                sb.append(System.lineSeparator());
                for (j = 0; j < prefix.length(); ++j) {
                    sb.append(" ");
                }
                sb.append("...");
                continue block0;
            }
        }
        throw new RuntimeException(sb.toString());
    }
}

