/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.JarResource;
import io.quarkus.bootstrap.runner.VirtualThreadSupport;
import io.smallrye.common.io.jar.JarFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;

public class JarFileReference {
    private final JarFile jarFile;
    private final AtomicInteger referenceCounter = new AtomicInteger(2);

    private JarFileReference(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    private boolean acquire() {
        int count;
        do {
            if ((count = this.referenceCounter.get()) != 0) continue;
            return false;
        } while (!this.referenceCounter.compareAndSet(count, count + 1));
        return true;
    }

    private boolean release(JarResource jarResource) {
        int count;
        do {
            if ((count = this.referenceCounter.get()) > 0) continue;
            throw new IllegalStateException("The reference counter cannot be negative, found: " + (this.referenceCounter.get() - 1));
        } while (!this.referenceCounter.compareAndSet(count, count - 1));
        if (count == 1) {
            jarResource.jarFileReference.set(null);
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    void close(JarResource jarResource) {
        this.release(jarResource);
    }

    static <T> T withJarFile(JarResource jarResource, String resource, JarFileConsumer<T> fileConsumer) {
        JarFileReference jarFileReference;
        CompletableFuture<JarFileReference> localJarFileRefFuture = jarResource.jarFileReference.get();
        if (localJarFileRefFuture != null && localJarFileRefFuture.isDone() && (jarFileReference = localJarFileRefFuture.join()).acquire()) {
            return JarFileReference.consumeSharedJarFile(jarFileReference, jarResource, resource, fileConsumer);
        }
        if (!VirtualThreadSupport.isVirtualThread()) {
            return JarFileReference.consumeSharedJarFile(JarFileReference.asyncLoadAcquiredJarFile(jarResource), jarResource, resource, fileConsumer);
        }
        CompletableFuture<JarFileReference> newJarFileRef = JarFileReference.syncLoadAcquiredJarFile(jarResource);
        if (jarResource.jarFileReference.compareAndSet(localJarFileRefFuture, newJarFileRef) || jarResource.jarFileReference.compareAndSet(null, newJarFileRef)) {
            return JarFileReference.consumeSharedJarFile(newJarFileRef.join(), jarResource, resource, fileConsumer);
        }
        return JarFileReference.consumeUnsharedJarFile(newJarFileRef, jarResource, resource, fileConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T consumeSharedJarFile(JarFileReference jarFileReference, JarResource jarResource, String resource, JarFileConsumer<T> fileConsumer) {
        try {
            T t = fileConsumer.apply(jarFileReference.jarFile, jarResource.jarPath, resource);
            return t;
        }
        finally {
            jarFileReference.release(jarResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T consumeUnsharedJarFile(CompletableFuture<JarFileReference> jarFileReferenceFuture, JarResource jarResource, String resource, JarFileConsumer<T> fileConsumer) {
        JarFileReference jarFileReference = jarFileReferenceFuture.join();
        try {
            T t = fileConsumer.apply(jarFileReference.jarFile, jarResource.jarPath, resource);
            return t;
        }
        finally {
            boolean closed = jarFileReference.release(jarResource);
            assert (!closed);
            if (!jarResource.jarFileReference.compareAndSet(null, jarFileReferenceFuture)) {
                closed = jarFileReference.release(jarResource);
                assert (closed);
            }
        }
    }

    private static CompletableFuture<JarFileReference> syncLoadAcquiredJarFile(JarResource jarResource) {
        try {
            return CompletableFuture.completedFuture(new JarFileReference(JarFiles.create((File)jarResource.jarPath.toFile())));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open " + jarResource.jarPath, e);
        }
    }

    private static JarFileReference asyncLoadAcquiredJarFile(JarResource jarResource) {
        CompletableFuture<JarFileReference> newJarRefFuture = new CompletableFuture<JarFileReference>();
        CompletableFuture<JarFileReference> existingJarRefFuture = null;
        JarFileReference existingJarRef = null;
        do {
            if (!jarResource.jarFileReference.compareAndSet(null, newJarRefFuture)) continue;
            try {
                JarFileReference newJarRef = new JarFileReference(JarFiles.create((File)jarResource.jarPath.toFile()));
                newJarRefFuture.complete(newJarRef);
                return newJarRef;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } while ((existingJarRef = (existingJarRefFuture = jarResource.jarFileReference.get()) == null ? null : existingJarRefFuture.join()) == null || !existingJarRef.acquire());
        return existingJarRef;
    }

    @FunctionalInterface
    static interface JarFileConsumer<T> {
        public T apply(JarFile var1, Path var2, String var3);
    }
}

