/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.StepInfo;
import io.quarkus.builder.diag.Diagnostic;
import io.quarkus.builder.item.BuildItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jboss.logging.Logger;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;

final class Execution {
    static final Logger log = Logger.getLogger((String)"io.quarkus.builder");
    private final BuildChain chain;
    private final ConcurrentHashMap<ItemId, BuildItem> singles;
    private final ConcurrentHashMap<ItemId, List<BuildItem>> multis;
    private final Set<ItemId> finalIds;
    private final ConcurrentHashMap<StepInfo, BuildContext> contextCache = new ConcurrentHashMap();
    private final EnhancedQueueExecutor executor;
    private final List<Diagnostic> diagnostics = Collections.synchronizedList(new ArrayList());
    private final String buildTargetName;
    private final AtomicBoolean errorReported = new AtomicBoolean();
    private final AtomicInteger lastStepCount = new AtomicInteger();
    private volatile Thread runningThread;
    private volatile boolean done;

    Execution(BuildExecutionBuilder builder, Set<ItemId> finalIds) {
        this.chain = builder.getChain();
        this.singles = new ConcurrentHashMap<ItemId, BuildItem>(builder.getInitialSingle());
        this.multis = new ConcurrentHashMap<ItemId, ArrayList<BuildItem>>(builder.getInitialMulti());
        this.finalIds = finalIds;
        EnhancedQueueExecutor.Builder executorBuilder = new EnhancedQueueExecutor.Builder();
        executorBuilder.setRegisterMBean(false);
        executorBuilder.setCorePoolSize(8).setMaximumPoolSize(1024);
        executorBuilder.setExceptionHandler(JBossExecutors.loggingExceptionHandler());
        executorBuilder.setThreadFactory((ThreadFactory)new JBossThreadFactory(new ThreadGroup("build group"), Boolean.FALSE, null, "build-%t", JBossExecutors.loggingExceptionHandler(), null));
        this.buildTargetName = builder.getBuildTargetName();
        this.executor = executorBuilder.build();
        this.lastStepCount.set(builder.getChain().getEndStepCount());
        if (this.lastStepCount.get() == 0) {
            this.done = true;
        }
    }

    List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    BuildContext getBuildContext(StepInfo stepInfo) {
        return this.contextCache.computeIfAbsent(stepInfo, si -> new BuildContext(this.chain.getClassLoader(), (StepInfo)si, this));
    }

    void removeBuildContext(StepInfo stepInfo, BuildContext buildContext) {
        this.contextCache.remove(stepInfo, buildContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BuildResult run() throws BuildException {
        long start = System.nanoTime();
        this.runningThread = Thread.currentThread();
        List<StepInfo> startSteps = this.chain.getStartSteps();
        for (StepInfo startStep : startSteps) {
            this.executor.execute(this.getBuildContext(startStep)::run);
        }
        boolean intr = false;
        try {
            while (true) {
                if (Thread.interrupted()) {
                    intr = true;
                }
                if (this.done) {
                    break;
                }
                LockSupport.park(this);
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
            this.runningThread = null;
        }
        this.executor.shutdown();
        while (true) {
            try {
                this.executor.awaitTermination(1000L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                intr = true;
                continue;
            }
            finally {
                if (!intr) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        for (Diagnostic diagnostic : this.diagnostics) {
            if (diagnostic.getLevel() != Diagnostic.Level.ERROR) continue;
            BuildException failed = new BuildException("Build failed due to errors", diagnostic.getThrown(), Collections.unmodifiableList(this.diagnostics));
            for (Diagnostic i : this.diagnostics) {
                if (i.getThrown() == null || i.getThrown() == diagnostic.getThrown()) continue;
                failed.addSuppressed(i.getThrown());
            }
            throw failed;
        }
        if (this.lastStepCount.get() > 0) {
            throw new BuildException("Extra steps left over", Collections.emptyList());
        }
        return new BuildResult(this.singles, this.multis, this.finalIds, Collections.unmodifiableList(this.diagnostics), Math.max(0L, System.nanoTime() - start));
    }

    EnhancedQueueExecutor getExecutor() {
        return this.executor;
    }

    String getBuildTargetName() {
        return this.buildTargetName;
    }

    void setErrorReported() {
        this.errorReported.compareAndSet(false, true);
    }

    boolean isErrorReported() {
        return this.errorReported.get();
    }

    ConcurrentHashMap<ItemId, BuildItem> getSingles() {
        return this.singles;
    }

    ConcurrentHashMap<ItemId, List<BuildItem>> getMultis() {
        return this.multis;
    }

    BuildChain getBuildChain() {
        return this.chain;
    }

    void depFinished() {
        int count = this.lastStepCount.decrementAndGet();
        log.tracef("End step completed; %d remaining", count);
        if (count == 0) {
            this.done = true;
            LockSupport.unpark(this.runningThread);
        }
    }

    static {
        try {
            Class.forName("org.jboss.threads.EnhancedQueueExecutor$1", false, Execution.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

