/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.Constraint;
import io.quarkus.builder.Consume;
import io.quarkus.builder.ConsumeFlag;
import io.quarkus.builder.ConsumeFlags;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.Produce;
import io.quarkus.builder.ProduceFlag;
import io.quarkus.builder.ProduceFlags;
import io.quarkus.builder.item.BuildItem;
import io.smallrye.common.constraint.Assert;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;

public final class BuildStepBuilder {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private final BuildChainBuilder buildChainBuilder;
    private final Map<ItemId, Consume> consumes = new HashMap<ItemId, Consume>();
    private final Map<ItemId, Produce> produces = new HashMap<ItemId, Produce>();
    private BuildStep buildStep;

    BuildStepBuilder(BuildChainBuilder buildChainBuilder) {
        this.buildChainBuilder = buildChainBuilder;
    }

    public BuildStepBuilder setBuildStep(BuildStep buildStep) {
        this.buildStep = buildStep;
        return this;
    }

    public BuildStepBuilder beforeConsume(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.addProduces(new ItemId(type), Constraint.ORDER_ONLY, ProduceFlags.NONE);
        return this;
    }

    public BuildStepBuilder beforeConsume(Class<? extends BuildItem> type, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        this.addProduces(new ItemId(type), Constraint.ORDER_ONLY, ProduceFlags.of(flag));
        return this;
    }

    public BuildStepBuilder afterProduce(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.addConsumes(new ItemId(type), Constraint.ORDER_ONLY, ConsumeFlags.of(ConsumeFlag.OPTIONAL));
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.checkType(type);
        this.addProduces(new ItemId(type), Constraint.REAL, ProduceFlags.NONE);
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        this.checkType(type);
        this.addProduces(new ItemId(type), Constraint.REAL, ProduceFlags.of(flag));
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type, ProduceFlag flag1, ProduceFlag flag2) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag1));
        this.checkType(type);
        this.addProduces(new ItemId(type), Constraint.REAL, (ProduceFlags)ProduceFlags.of(flag1).with(flag2));
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type, ProduceFlags flags) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flags));
        this.checkType(type);
        this.addProduces(new ItemId(type), Constraint.REAL, flags);
        return this;
    }

    public BuildStepBuilder consumes(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.checkType(type);
        this.addConsumes(new ItemId(type), Constraint.REAL, ConsumeFlags.NONE);
        return this;
    }

    public BuildStepBuilder consumes(Class<? extends BuildItem> type, ConsumeFlags flags) {
        Assert.checkNotNullParam((String)"type", type);
        this.checkType(type);
        this.addConsumes(new ItemId(type), Constraint.REAL, flags);
        return this;
    }

    public BuildChainBuilder build() {
        BuildChainBuilder chainBuilder = this.buildChainBuilder;
        if (this.produces.isEmpty()) {
            throw new IllegalArgumentException("Build step '" + this.buildStep.getId() + "' does not produce any build item and thus will never get executed. Either change the return type of the method to a build item type, add a parameter of type BuildProducer<[some build item type]>/Consumer<[some build item type]>, or annotate the method with @Produces. Use @Produce(ArtifactResultBuildItem.class) if you want to always execute this step.");
        }
        if (BuildChainBuilder.LOG_CONFLICT_CAUSING) {
            chainBuilder.addStep(this, new Exception().getStackTrace());
        } else {
            chainBuilder.addStep(this, EMPTY_STACK_TRACE);
        }
        return chainBuilder;
    }

    public BuildChainBuilder buildIf(BooleanSupplier supp) {
        return supp.getAsBoolean() ? this.build() : null;
    }

    BuildStep getBuildStep() {
        return this.buildStep;
    }

    private void addConsumes(ItemId itemId, Constraint constraint, ConsumeFlags flags) {
        Assert.checkNotNullParam((String)"flags", (Object)((Object)flags));
        this.consumes.compute(itemId, (id, c) -> c == null ? new Consume(this, itemId, constraint, flags) : c.combine(constraint, flags));
    }

    private void addProduces(ItemId itemId, Constraint constraint, ProduceFlags flags) {
        this.produces.compute(itemId, (id, p) -> p == null ? new Produce(this, itemId, constraint, flags) : p.combine(constraint, flags));
    }

    Map<ItemId, Consume> getConsumes() {
        return this.consumes;
    }

    Map<ItemId, Produce> getProduces() {
        return this.produces;
    }

    Set<ItemId> getRealConsumes() {
        HashMap<ItemId, Consume> map = new HashMap<ItemId, Consume>(this.consumes);
        map.entrySet().removeIf(e -> ((Consume)e.getValue()).constraint() == Constraint.ORDER_ONLY);
        return map.keySet();
    }

    Set<ItemId> getRealProduces() {
        HashMap<ItemId, Produce> map = new HashMap<ItemId, Produce>(this.produces);
        map.entrySet().removeIf(e -> ((Produce)e.getValue()).getConstraint() == Constraint.ORDER_ONLY);
        return map.keySet();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BuildStep [");
        builder.append(this.buildStep);
        builder.append("]");
        return builder.toString();
    }

    private void checkType(Class<?> type) {
        int modifiers = type.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            throw new IllegalArgumentException("Cannot consume/produce interface or abstract class build items");
        }
    }
}

