/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.CacheInvalidateInterceptorBinding;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheInvalidateInterceptorBinding
@Interceptor
@Priority(value=1)
public class CacheInvalidateInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateInterceptor.class);

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Object key = null;
        for (CacheInvalidateInterceptorBinding binding : this.getInterceptorBindings(context, CacheInvalidateInterceptorBinding.class)) {
            CaffeineCache cache = this.cacheRepository.getCache(binding.cacheName());
            if (key == null) {
                key = this.getCacheKey(cache, binding.cacheKeyParameterPositions(), context.getParameters());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Invalidating entry with key [%s] from cache [%s]", key, (Object)cache.getName());
            }
            cache.invalidate(key);
        }
        return context.proceed();
    }
}

