/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CacheManagerImpl
implements CacheManager {
    private final Map<String, Cache> caches;
    private final Set<String> cacheNames;

    public CacheManagerImpl(Map<String, Cache> caches) {
        Objects.requireNonNull(caches);
        this.caches = Collections.unmodifiableMap(caches);
        this.cacheNames = Collections.unmodifiableSet(caches.keySet());
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public Optional<Cache> getCache(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.caches.get(name));
    }
}

