/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenerator;
import io.quarkus.deployment.codegen.CodeGenData;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.util.FSWatchUtil;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.logging.Logger;

class CodeGenWatcher {
    private static final Logger log = Logger.getLogger(CodeGenWatcher.class);
    private final QuarkusClassLoader deploymentClassLoader;
    private final FSWatchUtil fsWatchUtil;

    CodeGenWatcher(CuratedApplication curatedApplication, DevModeContext context) throws CodeGenException {
        QuarkusClassLoader deploymentClassLoader = curatedApplication.createDeploymentClassLoader();
        List<CodeGenData> codeGens = CodeGenerator.init((ClassLoader)deploymentClassLoader, context.getAllModules());
        if (codeGens.isEmpty()) {
            this.fsWatchUtil = null;
            this.deploymentClassLoader = null;
            deploymentClassLoader.close();
        } else {
            ArrayList<FSWatchUtil.Watcher> watchers = new ArrayList<FSWatchUtil.Watcher>(codeGens.size());
            Properties properties = new Properties();
            properties.putAll(context.getBuildSystemProperties());
            for (CodeGenData codeGen : codeGens) {
                watchers.add(new FSWatchUtil.Watcher(codeGen.sourceDir, codeGen.provider.inputExtension(), modifiedPaths -> {
                    try {
                        CodeGenerator.trigger((ClassLoader)deploymentClassLoader, codeGen, curatedApplication.getApplicationModel(), properties, LaunchMode.DEVELOPMENT, false);
                    }
                    catch (Exception any) {
                        log.warn((Object)"Code generation failed", (Throwable)any);
                    }
                }));
            }
            this.fsWatchUtil = new FSWatchUtil();
            this.fsWatchUtil.observe(watchers, 500L);
            this.deploymentClassLoader = deploymentClassLoader;
        }
    }

    void shutdown() {
        if (this.fsWatchUtil != null) {
            this.fsWatchUtil.shutdown();
        }
        if (this.deploymentClassLoader != null) {
            this.deploymentClassLoader.close();
        }
    }
}

