/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ConfigMappingUtils {
    public static final DotName CONFIG_MAPPING_NAME = DotName.createSimple((String)ConfigMapping.class.getName());

    private ConfigMappingUtils() {
    }

    @BuildStep
    public static void generateConfigClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses, DotName configAnnotation) {
        for (AnnotationInstance instance : combinedIndex.getIndex().getAnnotations(configAnnotation)) {
            AnnotationTarget target = instance.target();
            AnnotationValue annotationPrefix = instance.value("prefix");
            if (target.kind().equals((Object)AnnotationTarget.Kind.FIELD) && annotationPrefix != null && !annotationPrefix.asString().equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
                configClasses.produce(ConfigMappingUtils.toConfigClassBuildItem(instance, ConfigMappingUtils.toClass(target.asField().type().name()), annotationPrefix.asString()));
                continue;
            }
            if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) && annotationPrefix != null && !annotationPrefix.asString().equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
                ClassType classType = ((Type)target.asMethodParameter().method().parameters().get(target.asMethodParameter().position())).asClassType();
                configClasses.produce(ConfigMappingUtils.toConfigClassBuildItem(instance, ConfigMappingUtils.toClass(classType.name()), annotationPrefix.asString()));
                continue;
            }
            if (!target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
            Class<?> configClass = ConfigMappingUtils.toClass(target.asClass().name());
            String prefix = Optional.ofNullable(annotationPrefix).map(AnnotationValue::asString).orElse("");
            List configMappingsMetadata = ConfigMappingLoader.getConfigMappingsMetadata(configClass);
            HashSet<String> generatedClassesNames = new HashSet<String>();
            HashSet mappingsInfo = new HashSet();
            configMappingsMetadata.forEach(mappingMetadata -> {
                generatedClasses.produce(new GeneratedClassBuildItem(true, mappingMetadata.getClassName(), mappingMetadata.getClassBytes()));
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getInterfaceType()).methods(true).build());
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getClassName()).constructors(true).build());
                for (Class<?> parent : ConfigMappingUtils.getHierarchy(mappingMetadata.getInterfaceType())) {
                    reflectiveClasses.produce(ReflectiveClassBuildItem.builder(parent).methods(true).build());
                }
                generatedClassesNames.add(mappingMetadata.getClassName());
                ClassInfo mappingInfo = combinedIndex.getIndex().getClassByName(DotName.createSimple((String)mappingMetadata.getInterfaceType().getName()));
                if (mappingInfo != null) {
                    mappingsInfo.add(mappingInfo);
                }
            });
            for (ClassInfo classInfo : mappingsInfo) {
                for (MethodInfo method : classInfo.methods()) {
                    reflectiveClasses.produce(new ReflectiveClassBuildItem(true, false, method.returnType().name().toString()));
                }
            }
            configClasses.produce(ConfigMappingUtils.toConfigClassBuildItem(instance, configClass, generatedClassesNames, prefix));
        }
    }

    private static Class<?> toClass(DotName dotName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(dotName.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + dotName.toString() + ") cannot be created during deployment.", e);
        }
    }

    private static ConfigClassBuildItem toConfigClassBuildItem(AnnotationInstance instance, Class<?> configClass, String prefix) {
        return ConfigMappingUtils.toConfigClassBuildItem(instance, configClass, Collections.emptySet(), prefix);
    }

    private static ConfigClassBuildItem toConfigClassBuildItem(AnnotationInstance instance, Class<?> configClass, Set<String> generatedClasses, String prefix) {
        if (instance.name().equals((Object)CONFIG_MAPPING_NAME)) {
            return new ConfigClassBuildItem(configClass, generatedClasses, prefix, ConfigClassBuildItem.Type.MAPPING);
        }
        return new ConfigClassBuildItem(configClass, generatedClasses, prefix, ConfigClassBuildItem.Type.PROPERTIES);
    }

    private static List<Class<?>> getHierarchy(Class<?> mapping) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> i : mapping.getInterfaces()) {
            interfaces.add(i);
            interfaces.addAll(ConfigMappingUtils.getHierarchy(i));
        }
        return interfaces;
    }
}

