/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.PathCollection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.jboss.jandex.IndexView;

public interface ApplicationArchive {
    public IndexView getIndex();

    @Deprecated
    public Path getArchiveLocation();

    @Deprecated
    public PathsCollection getRootDirs();

    public PathCollection getRootDirectories();

    @Deprecated
    public PathsCollection getPaths();

    public PathCollection getResolvedPaths();

    public AppArtifactKey getArtifactKey();

    public ArtifactKey getKey();

    default public Path getChildPath(String path) {
        return this.getRootDirectories().resolveExistingOrNull(path);
    }

    default public void processEntry(String path, BiConsumer<Path, Path> consumer) {
        Iterator dirs = this.getRootDirectories().iterator();
        Iterator paths = this.getResolvedPaths().iterator();
        while (dirs.hasNext()) {
            Path child = ((Path)dirs.next()).resolve(path);
            if (Files.exists(child, new LinkOption[0])) {
                consumer.accept(child, (Path)paths.next());
                return;
            }
            paths.next();
        }
    }
}

