/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.dev.testing.ContinuousTestingSharedStateListener;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestListenerBuildItem;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.testing.ContinuousTestingSharedStateManager;
import io.quarkus.dev.testing.TracingHandler;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class TestTracingProcessor {
    static volatile boolean testingSetup;

    @BuildStep(onlyIfNot={IsNormal.class})
    LogCleanupFilterBuildItem handle() {
        return new LogCleanupFilterBuildItem("org.junit.platform.launcher.core.EngineDiscoveryOrchestrator", "0 containers");
    }

    @BuildStep
    TestListenerBuildItem sharedStateListener() {
        return new TestListenerBuildItem(new ContinuousTestingSharedStateListener());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Produce.List(value={@Produce(value=LogHandlerBuildItem.class), @Produce(value=TestSetupBuildItem.class), @Produce(value=ServiceStartBuildItem.class)})
    void startTesting(TestConfig config, LiveReloadBuildItem liveReloadBuildItem, LaunchModeBuildItem launchModeBuildItem, List<TestListenerBuildItem> testListenerBuildItems) {
        if (!TestSupport.instance().isPresent() || config.continuousTesting == TestConfig.Mode.DISABLED || config.flatClassPath) {
            return;
        }
        DevModeType devModeType = launchModeBuildItem.getDevModeType().orElse(null);
        if (devModeType == null || !devModeType.isContinuousTestingSupported()) {
            return;
        }
        if (testingSetup) {
            return;
        }
        testingSetup = true;
        TestSupport testSupport = TestSupport.instance().get();
        for (TestListenerBuildItem i : testListenerBuildItems) {
            testSupport.addListener(i.listener);
        }
        testSupport.setConfig(config);
        testSupport.setTags(config.includeTags.orElse(Collections.emptyList()), config.excludeTags.orElse(Collections.emptyList()));
        testSupport.setPatterns(config.includePattern.orElse(null), config.excludePattern.orElse(null));
        testSupport.setConfiguredDisplayTestOutput(config.displayTestOutput);
        testSupport.setTestType(config.type);
        if (!liveReloadBuildItem.isLiveReload()) {
            if (config.continuousTesting == TestConfig.Mode.ENABLED) {
                testSupport.start();
            } else if (config.continuousTesting == TestConfig.Mode.PAUSED) {
                testSupport.stop();
            }
        }
        QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        ((QuarkusClassLoader)cl.parent()).addCloseTask(ContinuousTestingSharedStateManager::reset);
    }

    @BuildStep(onlyIf={IsTest.class})
    public void instrumentTestClasses(CombinedIndexBuildItem combinedIndexBuildItem, LaunchModeBuildItem launchModeBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformerProducer) {
        if (!launchModeBuildItem.isAuxiliaryApplication()) {
            return;
        }
        for (ClassInfo clazz : combinedIndexBuildItem.getIndex().getKnownClasses()) {
            final String theClassName = clazz.name().toString();
            if (!this.isAppClass(theClassName)) continue;
            transformerProducer.produce(new BytecodeTransformerBuildItem(false, theClassName, new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                    return new TracingClassVisitor(classVisitor, theClassName);
                }
            }, true));
        }
    }

    public boolean isAppClass(String theClassName) {
        QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        List res = cl.getElementsWithResource(theClassName.replace(".", "/") + ".class", true);
        return !res.isEmpty();
    }

    public static class TracingClassVisitor
    extends ClassVisitor {
        private final String theClassName;

        public TracingClassVisitor(ClassVisitor classVisitor, String theClassName) {
            super(589824, classVisitor);
            this.theClassName = theClassName;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("<init>") || name.equals("<clinit>")) {
                return mv;
            }
            return new MethodVisitor(589824, mv){

                public void visitCode() {
                    super.visitCode();
                    this.visitLdcInsn(theClassName);
                    this.visitMethodInsn(184, TracingHandler.class.getName().replace(".", "/"), "trace", "(Ljava/lang/String;)V", false);
                }
            };
        }
    }
}

