/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;

public class TestResult {
    final String displayName;
    final String testClass;
    final UniqueId uniqueId;
    final TestExecutionResult testExecutionResult;
    final List<String> logOutput;
    final boolean test;
    final long runId;
    final long time;
    final List<Throwable> problems;
    final boolean reportable;

    public TestResult(String displayName, String testClass, UniqueId uniqueId, TestExecutionResult testExecutionResult, List<String> logOutput, boolean test, long runId, long time, boolean reportable) {
        this.displayName = displayName;
        this.testClass = testClass;
        this.uniqueId = uniqueId;
        this.testExecutionResult = testExecutionResult;
        this.logOutput = logOutput;
        this.test = test;
        this.runId = runId;
        this.time = time;
        this.reportable = reportable;
        ArrayList<Throwable> problems = new ArrayList<Throwable>();
        if (testExecutionResult.getThrowable().isPresent()) {
            for (Throwable t = (Throwable)testExecutionResult.getThrowable().get(); t != null; t = t.getCause()) {
                problems.add(t);
            }
        }
        this.problems = Collections.unmodifiableList(problems);
    }

    public TestExecutionResult getTestExecutionResult() {
        return this.testExecutionResult;
    }

    public List<String> getLogOutput() {
        return this.logOutput;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public UniqueId getUniqueId() {
        return this.uniqueId;
    }

    public boolean isTest() {
        return this.test;
    }

    public long getRunId() {
        return this.runId;
    }

    public long getTime() {
        return this.time;
    }

    public List<Throwable> getProblems() {
        return this.problems;
    }

    public boolean isReportable() {
        return this.reportable;
    }
}

