/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.configuration.ConfigCompatibility;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingInterceptor;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.PropertiesUtil;
import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.PropertyName;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config.common.AbstractConfigSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public final class BuildTimeConfigurationReader {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config.build");
    private static final String CONFIG_ROOTS_LIST = "META-INF/quarkus-config-roots.list";
    private final ClassLoader classLoader;
    private final List<ConfigMappings.ConfigClass> buildTimeMappings;
    private final List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings;
    private final List<ConfigMappings.ConfigClass> runTimeMappings;
    private final List<ConfigMappings.ConfigClass> buildTimeVisibleMappings;
    private final Set<String> mappingsIgnorePaths;
    final ConfigTrackingInterceptor buildConfigTracker;

    private static List<Class<?>> collectConfigRoots(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Assert.checkNotNullParam((String)"classLoader", (Object)classLoader);
        ArrayList roots = new ArrayList();
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, CONFIG_ROOTS_LIST)) {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("The configuration " + String.valueOf(clazz) + " must be an interface annotated with @ConfigRoot and @ConfigMapping");
            }
            ConfigRoot configRoot = clazz.getAnnotation(ConfigRoot.class);
            if (configRoot == null) {
                throw new IllegalArgumentException("The configuration " + String.valueOf(clazz) + " is missing the @ConfigRoot annotation");
            }
            ConfigMapping configMapping = clazz.getAnnotation(ConfigMapping.class);
            if (configMapping == null) {
                throw new IllegalArgumentException("The configuration " + String.valueOf(clazz) + " is missing the @ConfigMapping annotation");
            }
            roots.add(clazz);
        }
        return roots;
    }

    public BuildTimeConfigurationReader(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        this(classLoader, BuildTimeConfigurationReader.collectConfigRoots(classLoader));
    }

    public BuildTimeConfigurationReader(List<Class<?>> configRoots) {
        this(null, configRoots);
    }

    private BuildTimeConfigurationReader(ClassLoader classLoader, List<Class<?>> configRoots) {
        Assert.checkNotNullParam((String)"configRoots", configRoots);
        this.classLoader = classLoader;
        this.buildTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        this.buildTimeRunTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        this.runTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        for (Class<?> configRoot : configRoots) {
            boolean isMapping = configRoot.isAnnotationPresent(ConfigMapping.class);
            if (!isMapping) continue;
            ConfigPhase phase = ConfigPhase.BUILD_TIME;
            ConfigRoot annotation = configRoot.getAnnotation(ConfigRoot.class);
            if (annotation != null) {
                phase = annotation.phase();
            }
            ConfigMappings.ConfigClass mapping = ConfigMappings.ConfigClass.configClass(configRoot);
            if (phase.equals((Object)ConfigPhase.BUILD_TIME)) {
                this.buildTimeMappings.add(mapping);
                continue;
            }
            if (phase.equals((Object)ConfigPhase.BUILD_AND_RUN_TIME_FIXED)) {
                this.buildTimeRunTimeMappings.add(mapping);
                continue;
            }
            if (!phase.equals((Object)ConfigPhase.RUN_TIME)) continue;
            this.runTimeMappings.add(mapping);
        }
        this.buildTimeVisibleMappings = new ArrayList<ConfigMappings.ConfigClass>(this.buildTimeMappings.size() + this.buildTimeRunTimeMappings.size());
        this.buildTimeVisibleMappings.addAll(this.buildTimeMappings);
        this.buildTimeVisibleMappings.addAll(this.buildTimeRunTimeMappings);
        this.mappingsIgnorePaths = new HashSet<String>();
        block1: for (ConfigMappings.ConfigClass buildTimeMapping : this.buildTimeMappings) {
            if (buildTimeMapping.getPrefix().equals("quarkus") || buildTimeMapping.getPrefix().startsWith("quarkus.")) continue;
            for (ConfigMappings.ConfigClass staticMapping : this.buildTimeRunTimeMappings) {
                if (!buildTimeMapping.getPrefix().equals(staticMapping.getPrefix())) continue;
                this.mappingsIgnorePaths.add(buildTimeMapping.getPrefix() + ".**");
                break;
            }
            for (ConfigMappings.ConfigClass runtimeMapping : this.runTimeMappings) {
                if (!buildTimeMapping.getPrefix().equals(runtimeMapping.getPrefix())) continue;
                this.mappingsIgnorePaths.add(buildTimeMapping.getPrefix() + ".**");
                continue block1;
            }
        }
        this.buildConfigTracker = new ConfigTrackingInterceptor();
    }

    public SmallRyeConfig initConfiguration(Properties buildSystemProps, Properties runtimeProperties, Map<String, String> platformProperties) {
        SmallRyeConfigBuilder builder = ConfigUtils.configBuilder();
        if (this.classLoader != null) {
            builder.forClassLoader(this.classLoader);
        }
        builder.withSources(new ConfigSource[]{new PropertiesConfigSource(buildSystemProps, "Build system")}).withSources(new ConfigSource[]{new PropertiesConfigSource(runtimeProperties, "Runtime Properties")});
        if (!platformProperties.isEmpty()) {
            builder.withSources(new ConfigSource[]{new DefaultValuesConfigSource(platformProperties, "Quarkus platform", -2147482648)});
        }
        for (ConfigMappings.ConfigClass mapping : this.buildTimeVisibleMappings) {
            builder.withMapping(mapping);
        }
        for (String mappingsIgnorePath : this.mappingsIgnorePaths) {
            builder.withMappingIgnore(mappingsIgnorePath);
        }
        builder.withInterceptors(new ConfigSourceInterceptor[]{this.buildConfigTracker});
        builder.withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.instance(), ConfigCompatibility.BackEnd.instance()});
        SmallRyeConfig config = builder.build();
        this.buildConfigTracker.configure((Config)config);
        return config;
    }

    public ReadResult readConfiguration(SmallRyeConfig config) {
        return (ReadResult)SecretKeys.doUnlocked(() -> new ReadOperation(config, this.buildConfigTracker).run());
    }

    public static final class ReadResult {
        final Map<String, ConfigValue> allBuildTimeValues;
        final Map<String, ConfigValue> buildTimeRunTimeValues;
        final Map<String, ConfigValue> runTimeDefaultValues;
        final Map<String, ConfigValue> runTimeValues;
        final List<ConfigMappings.ConfigClass> buildTimeMappings;
        final List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings;
        final List<ConfigMappings.ConfigClass> runTimeMappings;
        final List<ConfigMappings.ConfigClass> allMappings;
        final Set<String> mappingsIgnorePaths;
        final Map<Class<?>, ConfigMappings.ConfigClass> allMappingsByClass;
        final Set<String> unknownBuildProperties;
        final ConfigTrackingInterceptor.ReadOptionsProvider readOptionsProvider;

        public ReadResult(Builder builder) {
            this.allBuildTimeValues = builder.getAllBuildTimeValues();
            this.buildTimeRunTimeValues = builder.getBuildTimeRunTimeValues();
            this.runTimeDefaultValues = builder.getRunTimeDefaultValues();
            this.runTimeValues = builder.getRuntimeValues();
            this.buildTimeMappings = builder.getBuildTimeMappings();
            this.buildTimeRunTimeMappings = builder.getBuildTimeRunTimeMappings();
            this.runTimeMappings = builder.getRunTimeMappings();
            this.mappingsIgnorePaths = builder.getMappingsIgnorePaths();
            this.allMappings = new ArrayList<ConfigMappings.ConfigClass>(ReadResult.mappingsToMap(builder).values());
            this.allMappingsByClass = ReadResult.mappingsToMap(builder);
            this.unknownBuildProperties = builder.getUnknownBuildProperties();
            this.readOptionsProvider = builder.buildConfigTracker == null ? null : builder.buildConfigTracker.getReadOptionsProvider();
        }

        private static Map<Class<?>, ConfigMappings.ConfigClass> mappingsToMap(Builder builder) {
            HashMap map = new HashMap();
            for (ConfigMappings.ConfigClass mapping : builder.getBuildTimeMappings()) {
                map.put(mapping.getType(), mapping);
            }
            for (ConfigMappings.ConfigClass mapping : builder.getBuildTimeRunTimeMappings()) {
                map.put(mapping.getType(), mapping);
            }
            for (ConfigMappings.ConfigClass mapping : builder.getRunTimeMappings()) {
                map.put(mapping.getType(), mapping);
            }
            return map;
        }

        public Map<String, ConfigValue> getAllBuildTimeValues() {
            return this.allBuildTimeValues;
        }

        public Map<String, ConfigValue> getBuildTimeRunTimeValues() {
            return this.buildTimeRunTimeValues;
        }

        public Map<String, ConfigValue> getRunTimeDefaultValues() {
            return this.runTimeDefaultValues;
        }

        public Map<String, ConfigValue> getRunTimeValues() {
            return this.runTimeValues;
        }

        public List<ConfigMappings.ConfigClass> getBuildTimeMappings() {
            return this.buildTimeMappings;
        }

        public List<ConfigMappings.ConfigClass> getBuildTimeRunTimeMappings() {
            return this.buildTimeRunTimeMappings;
        }

        public List<ConfigMappings.ConfigClass> getRunTimeMappings() {
            return this.runTimeMappings;
        }

        public Set<String> getMappingsIgnorePaths() {
            return this.mappingsIgnorePaths;
        }

        public List<ConfigMappings.ConfigClass> getAllMappings() {
            return this.allMappings;
        }

        public Map<Class<?>, ConfigMappings.ConfigClass> getAllMappingsByClass() {
            return this.allMappingsByClass;
        }

        public Set<String> getUnknownBuildProperties() {
            return this.unknownBuildProperties;
        }

        public ConfigTrackingInterceptor.ReadOptionsProvider getReadOptionsProvider() {
            return this.readOptionsProvider;
        }

        static class Builder {
            private Map<String, ConfigValue> allBuildTimeValues;
            private Map<String, ConfigValue> buildTimeRunTimeValues;
            private Map<String, ConfigValue> runTimeDefaultValues;
            private Map<String, ConfigValue> runtimeValues;
            private List<ConfigMappings.ConfigClass> buildTimeMappings;
            private List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings;
            private List<ConfigMappings.ConfigClass> runTimeMappings;
            private Set<String> mappingsIgnorePaths;
            private Set<String> unknownBuildProperties;
            private ConfigTrackingInterceptor buildConfigTracker;

            Builder() {
            }

            Map<String, ConfigValue> getAllBuildTimeValues() {
                return this.allBuildTimeValues;
            }

            Builder setAllBuildTimeValues(Map<String, ConfigValue> allBuildTimeValues) {
                this.allBuildTimeValues = allBuildTimeValues;
                return this;
            }

            Map<String, ConfigValue> getBuildTimeRunTimeValues() {
                return this.buildTimeRunTimeValues;
            }

            Builder setBuildTimeRunTimeValues(Map<String, ConfigValue> buildTimeRunTimeValues) {
                this.buildTimeRunTimeValues = buildTimeRunTimeValues;
                return this;
            }

            Map<String, ConfigValue> getRunTimeDefaultValues() {
                return this.runTimeDefaultValues;
            }

            Builder setRunTimeDefaultValues(Map<String, ConfigValue> runTimeDefaultValues) {
                this.runTimeDefaultValues = runTimeDefaultValues;
                return this;
            }

            Map<String, ConfigValue> getRuntimeValues() {
                return this.runtimeValues;
            }

            Builder setRuntimeValues(Map<String, ConfigValue> runtimeValues) {
                this.runtimeValues = runtimeValues;
                return this;
            }

            List<ConfigMappings.ConfigClass> getBuildTimeMappings() {
                return this.buildTimeMappings;
            }

            Builder setBuildTimeMappings(List<ConfigMappings.ConfigClass> buildTimeMappings) {
                this.buildTimeMappings = buildTimeMappings;
                return this;
            }

            List<ConfigMappings.ConfigClass> getBuildTimeRunTimeMappings() {
                return this.buildTimeRunTimeMappings;
            }

            Builder setBuildTimeRunTimeMappings(List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings) {
                this.buildTimeRunTimeMappings = buildTimeRunTimeMappings;
                return this;
            }

            List<ConfigMappings.ConfigClass> getRunTimeMappings() {
                return this.runTimeMappings;
            }

            Builder setRunTimeMappings(List<ConfigMappings.ConfigClass> runTimeMappings) {
                this.runTimeMappings = runTimeMappings;
                return this;
            }

            Set<String> getMappingsIgnorePaths() {
                return this.mappingsIgnorePaths;
            }

            Builder setMappingsIgnorePaths(Set<String> mappingsIgnorePaths) {
                this.mappingsIgnorePaths = mappingsIgnorePaths;
                return this;
            }

            Set<String> getUnknownBuildProperties() {
                return this.unknownBuildProperties;
            }

            Builder setUnknownBuildProperties(Set<String> unknownBuildProperties) {
                this.unknownBuildProperties = unknownBuildProperties;
                return this;
            }

            Builder setBuildConfigTracker(ConfigTrackingInterceptor buildConfigTracker) {
                this.buildConfigTracker = buildConfigTracker;
                return this;
            }

            ReadResult createReadResult() {
                return new ReadResult(this);
            }
        }
    }

    final class ReadOperation {
        final SmallRyeConfig config;
        final ConfigTrackingInterceptor buildConfigTracker;
        final Map<String, ConfigValue> allBuildTimeValues = new TreeMap<String, ConfigValue>();
        final Map<String, ConfigValue> buildTimeRunTimeValues = new TreeMap<String, ConfigValue>();
        final Map<String, ConfigValue> runTimeDefaultValues = new TreeMap<String, ConfigValue>();
        final Map<String, ConfigValue> runTimeValues = new TreeMap<String, ConfigValue>();

        ReadOperation(SmallRyeConfig config, ConfigTrackingInterceptor buildConfigTracker) {
            this.config = config;
            this.buildConfigTracker = buildConfigTracker;
        }

        ReadResult run() {
            ConfigValue configValue;
            final SmallRyeConfig runtimeConfig = this.getConfigForRuntimeRecording();
            this.config.getConfigSource("PropertiesConfigSource[source=Runtime Properties]").ifPresent(new Consumer<ConfigSource>(){

                @Override
                public void accept(ConfigSource configSource) {
                    for (String propertyName : configSource.getPropertyNames()) {
                        ConfigValue configValue = (ConfigValue)Expressions.withoutExpansion(() -> runtimeConfig.getConfigValue(propertyName));
                        if (configValue.getValue() == null) continue;
                        ReadOperation.this.runTimeValues.put(propertyName, configValue);
                    }
                }
            });
            Set<PropertyName> buildTimeNames = ReadOperation.mappingsToNames(BuildTimeConfigurationReader.this.buildTimeMappings).keySet();
            Set<PropertyName> buildTimeRunTimeNames = ReadOperation.mappingsToNames(BuildTimeConfigurationReader.this.buildTimeRunTimeMappings).keySet();
            Set<PropertyName> runTimeNames = ReadOperation.mappingsToNames(BuildTimeConfigurationReader.this.runTimeMappings).keySet();
            HashSet<String> prefixes = new HashSet<String>();
            prefixes.addAll(BuildTimeConfigurationReader.this.buildTimeMappings.stream().map(ConfigMappings.ConfigClass::getPrefix).toList());
            prefixes.addAll(BuildTimeConfigurationReader.this.buildTimeRunTimeMappings.stream().map(ConfigMappings.ConfigClass::getPrefix).toList());
            prefixes.addAll(BuildTimeConfigurationReader.this.runTimeMappings.stream().map(ConfigMappings.ConfigClass::getPrefix).toList());
            final HashSet<String> unknownBuildProperties = new HashSet<String>();
            for (String property : this.getAllProperties(prefixes)) {
                ConfigValue value;
                if (property.equals("config_ordinal")) continue;
                boolean mapped = false;
                PropertyName name = new PropertyName(property);
                if (buildTimeNames.contains(name)) {
                    mapped = true;
                    value = this.config.getConfigValue(property);
                    if (value.getValue() != null) {
                        this.allBuildTimeValues.put(value.getNameProfiled(), value);
                    }
                }
                if (buildTimeRunTimeNames.contains(name)) {
                    mapped = true;
                    value = this.config.getConfigValue(property);
                    if (value.getValue() != null) {
                        this.allBuildTimeValues.put(value.getNameProfiled(), value);
                        this.buildTimeRunTimeValues.put(value.getNameProfiled(), value);
                    }
                }
                if (runTimeNames.contains(name)) {
                    mapped = true;
                    value = (ConfigValue)Expressions.withoutExpansion(() -> runtimeConfig.getConfigValue(property));
                    if (value.getRawValue() != null) {
                        this.runTimeValues.put(value.getNameProfiled(), value.noProblems().withValue(value.getRawValue()));
                    }
                }
                if (PropertiesUtil.isPropertyInRoots((String)property, prefixes)) {
                    if (mapped) continue;
                    unknownBuildProperties.add(property);
                    continue;
                }
                configValue = (ConfigValue)Expressions.withoutExpansion(() -> runtimeConfig.getConfigValue(property));
                if (configValue.getValue() != null) {
                    this.runTimeValues.put(property, configValue);
                }
                if (!PropertiesUtil.isPropertyQuarkusCompoundName((NameIterator)new NameIterator(property))) continue;
                unknownBuildProperties.add(property);
            }
            final Iterable configSources = this.config.getConfigSources();
            this.config.getConfigSource("PropertiesConfigSource[source=Build system]").ifPresent(new Consumer<ConfigSource>(){

                @Override
                public void accept(ConfigSource buildSystem) {
                    block0: for (String propertyName : buildSystem.getPropertyNames()) {
                        for (ConfigSource configSource : configSources) {
                            if (configSource.equals((Object)buildSystem) || !configSource.getPropertyNames().contains(propertyName)) continue;
                            continue block0;
                        }
                        unknownBuildProperties.remove(propertyName);
                    }
                }
            });
            HashSet<String> relocatesOrFallbacks = new HashSet<String>();
            for (String unknownBuildProperty : unknownBuildProperties) {
                configValue = this.config.getConfigValue(unknownBuildProperty);
                if (unknownBuildProperties.contains(configValue.getName())) continue;
                relocatesOrFallbacks.add(unknownBuildProperty);
            }
            unknownBuildProperties.removeAll(relocatesOrFallbacks);
            return new ReadResult.Builder().setAllBuildTimeValues(this.allBuildTimeValues).setBuildTimeRunTimeValues(this.filterActiveProfileProperties(this.buildTimeRunTimeValues)).setRunTimeDefaultValues(this.filterActiveProfileProperties(this.runTimeDefaultValues)).setRuntimeValues(this.runTimeValues).setBuildTimeMappings(BuildTimeConfigurationReader.this.buildTimeMappings).setBuildTimeRunTimeMappings(BuildTimeConfigurationReader.this.buildTimeRunTimeMappings).setRunTimeMappings(BuildTimeConfigurationReader.this.runTimeMappings).setMappingsIgnorePaths(BuildTimeConfigurationReader.this.mappingsIgnorePaths).setUnknownBuildProperties(unknownBuildProperties).setBuildConfigTracker(this.buildConfigTracker).createReadResult();
        }

        private Set<String> getAllProperties(Set<String> registeredRoots) {
            final HashSet<String> sourcesProperties = new HashSet<String>();
            for (ConfigSource configSource : this.config.getConfigSources()) {
                if (configSource instanceof SysPropConfigSource || configSource instanceof EnvConfigSource || "PropertiesConfigSource[source=Build system]".equals(configSource.getName())) {
                    for (Object property : configSource.getPropertyNames()) {
                        int profileDot;
                        String unprofiledProperty = property;
                        if (((String)property).startsWith("%") && (profileDot = ((String)property).indexOf(46)) != -1) {
                            unprofiledProperty = ((String)property).substring(profileDot + 1);
                        }
                        if (!PropertiesUtil.isPropertyInRoots((String)unprofiledProperty, registeredRoots)) continue;
                        sourcesProperties.add((String)property);
                    }
                    continue;
                }
                sourcesProperties.addAll(configSource.getPropertyNames());
            }
            AbstractConfigSource sourceProperties = new AbstractConfigSource("SourceProperties", 100){

                public Set<String> getPropertyNames() {
                    return sourcesProperties;
                }

                public String getValue(String propertyName) {
                    return ReadOperation.this.config.getConfigValue(propertyName).getValue();
                }
            };
            HashSet<String> properties = new HashSet<String>();
            SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
            builder.getSources().clear();
            builder.getSourceProviders().clear();
            builder.setAddDefaultSources(false).withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.nonLoggingInstance(), ConfigCompatibility.BackEnd.instance()}).addDiscoveredCustomizers().withProfiles(this.config.getProfiles()).withSources(new ConfigSource[]{sourceProperties});
            for (String property : builder.build().getPropertyNames()) {
                properties.add(property);
            }
            builder = ConfigUtils.emptyConfigBuilder();
            builder.getProfiles().add("");
            builder.getSources().clear();
            builder.getSourceProviders().clear();
            builder.setAddDefaultSources(false).withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.nonLoggingInstance(), ConfigCompatibility.BackEnd.instance()}).addDiscoveredCustomizers().withSources(new ConfigSource[]{sourceProperties});
            List profiles = this.config.getProfiles();
            for (String property : builder.build().getPropertyNames()) {
                String activeProperty = ProfileConfigSourceInterceptor.activeName((String)property, (List)profiles);
                if (activeProperty.equals("quarkus.config.profile.parent") && !activeProperty.equals(property)) {
                    properties.remove(activeProperty);
                }
                properties.add(property);
            }
            return properties;
        }

        private SmallRyeConfig getConfigForRuntimeRecording() {
            SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
            builder.getProfiles().add("");
            builder.getSources().clear();
            builder.getSourceProviders().clear();
            builder.withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new SmallRyeConfigBuilderCustomizer(){

                public void configBuilder(SmallRyeConfigBuilder builder) {
                    builder.getMappingsBuilder().getMappings().clear();
                }

                public int priority() {
                    return Integer.MAX_VALUE;
                }
            }});
            builder.setAddDefaultSources(false).addDiscoveredCustomizers().addPropertiesSources();
            for (ConfigSource configSource : this.config.getConfigSources()) {
                if (configSource instanceof SysPropConfigSource || configSource instanceof EnvConfigSource || "PropertiesConfigSource[source=Build system]".equals(configSource.getName())) continue;
                builder.withSources(new ConfigSource[]{configSource});
            }
            builder.withSources(new ConfigSource[]{new AbstractConfigSource("Profiles", Integer.MAX_VALUE){
                private final Set<String> profiles;
                {
                    this.profiles = Set.of("quarkus.profile", "quarkus.config.profile.parent", "quarkus.test.profile", "smallrye.config.profile", "smallrye.config.profile.parent", "mp.config.profile");
                }

                public Set<String> getPropertyNames() {
                    return Collections.emptySet();
                }

                public String getValue(String propertyName) {
                    if (this.profiles.contains(propertyName)) {
                        return ReadOperation.this.config.getConfigValue(propertyName).getValue();
                    }
                    return null;
                }
            }});
            return builder.build();
        }

        private Map<String, ConfigValue> filterActiveProfileProperties(Map<String, ConfigValue> properties) {
            HashSet<String> propertiesToRemove = new HashSet<String>();
            for (String property : properties.keySet()) {
                for (String profile : this.config.getProfiles()) {
                    String profiledProperty = "%" + profile + "." + property;
                    if (!properties.containsKey(profiledProperty)) continue;
                    propertiesToRemove.add(property);
                }
            }
            properties.keySet().removeAll(propertiesToRemove);
            return properties;
        }

        private static Map<PropertyName, String> mappingsToNames(List<ConfigMappings.ConfigClass> configMappings) {
            HashSet names = new HashSet();
            for (ConfigMappings.ConfigClass configMapping : configMappings) {
                names.addAll(ConfigMappings.getProperties((ConfigMappings.ConfigClass)configMapping).keySet());
            }
            HashMap<PropertyName, String> propertyNames = new HashMap<PropertyName, String>();
            for (String name : names) {
                PropertyName propertyName = new PropertyName(name);
                if (propertyNames.containsKey(propertyName)) {
                    ArrayList<String> duplicates = new ArrayList<String>();
                    duplicates.add(name);
                    while (propertyNames.containsKey(propertyName)) {
                        duplicates.add((String)propertyNames.remove(propertyName));
                    }
                    String minName = Collections.min(duplicates, Comparator.comparingInt(String::length));
                    propertyNames.put(new PropertyName(minName), minName);
                    continue;
                }
                propertyNames.put(propertyName, name);
            }
            return propertyNames;
        }
    }
}

