/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.deployment.pkg.jar.ArchiveCreator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.zip.DefaultBackingStoreSupplier;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;

public class ParallelCommonsCompressArchiveCreator
implements ArchiveCreator {
    private static final Set<String> MANIFESTS = Set.of("META-INF/MANIFEST.MF", "META-INF\\MANIFEST.MF");
    private static final Set<String> VERSIONS = Set.of("META-INF/versions/", "META-INF\\versions\\");
    private static final InputStreamSupplier EMPTY_SUPPLIER = () -> new ByteArrayInputStream(new byte[0]);
    private static final int DIR_UNIX_MODE = 16877;
    private static final int FILE_UNIX_MODE = 33188;
    private final Path archivePath;
    private final FileTime entryTimestamp;
    private final ZipArchiveOutputStream archive;
    private final ParallelScatterZipCreator scatterZipCreator;
    private final ScatterZipOutputStream directories;
    private final int compressionMethod;
    private final Path tempDirectory;
    private Manifest manifest;
    private final Map<String, String> addedFiles = new HashMap<String, String>();

    ParallelCommonsCompressArchiveCreator(Path archivePath, boolean compressed, Instant entryTimestamp, ExecutorService executorService) throws IOException {
        int compressionLevel;
        if (compressed) {
            compressionLevel = -1;
            this.compressionMethod = 8;
        } else {
            compressionLevel = 0;
            this.compressionMethod = 0;
        }
        if (archivePath.getParent() != null) {
            Files.createDirectories(archivePath.getParent(), new FileAttribute[0]);
        }
        this.archivePath = archivePath;
        this.entryTimestamp = entryTimestamp != null ? FileTime.from(entryTimestamp) : null;
        this.archive = new ZipArchiveOutputStream(archivePath, new OpenOption[0]);
        this.archive.setMethod(this.compressionMethod);
        this.tempDirectory = Files.createTempDirectory("zip-builder-files", new FileAttribute[0]);
        this.scatterZipCreator = new ParallelScatterZipCreator((ExecutorService)new DoNotShutdownDelegatingExecutorService(executorService), (ScatterGatherBackingStoreSupplier)new DefaultBackingStoreSupplier(this.tempDirectory), compressionLevel);
        this.directories = ScatterZipOutputStream.pathBased((Path)Files.createTempFile("zip-builder-dirs", "", new FileAttribute[0]), (int)compressionLevel);
    }

    @Override
    public void addManifest(Manifest manifest) throws IOException {
        this.manifest = manifest;
    }

    @Override
    public void addDirectory(String directory, String source) throws IOException {
        if (this.addedFiles.putIfAbsent((String)directory, source) != null) {
            return;
        }
        if (!((String)directory).endsWith("/")) {
            directory = (String)directory + "/";
        }
        this.addDirectoryEntry(new ZipArchiveEntry((String)directory));
    }

    @Override
    public void addFile(Path origin, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        if (this.addedFiles.putIfAbsent(target, source) != null) {
            return;
        }
        this.addEntry(new ZipArchiveEntry(target), ParallelCommonsCompressArchiveCreator.toInputStreamSupplier(origin));
    }

    @Override
    public void addFile(byte[] bytes, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        this.addEntry(new ZipArchiveEntry(target), ParallelCommonsCompressArchiveCreator.toInputStreamSupplier(bytes));
        this.addedFiles.put(target, source);
    }

    @Override
    public void addFileIfNotExists(Path origin, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        if (this.addedFiles.containsKey(target)) {
            return;
        }
        this.addFile(origin, target, source);
    }

    @Override
    public void addFileIfNotExists(byte[] bytes, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        if (this.addedFiles.containsKey(target)) {
            return;
        }
        this.addFile(bytes, target, source);
    }

    @Override
    public void addFile(List<byte[]> bytes, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        this.addFile(ParallelCommonsCompressArchiveCreator.joinWithNewlines(bytes), target, source);
    }

    @Override
    public boolean isMultiVersion() {
        for (String addedFile : this.addedFiles.keySet()) {
            for (String version : VERSIONS) {
                if (!addedFile.startsWith(version)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void makeMultiVersion() throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        this.manifest.getMainAttributes().put(Attributes.Name.MULTI_RELEASE, "true");
    }

    private void addDirectoryEntry(ZipArchiveEntry zipArchiveEntry) throws IOException {
        if (!zipArchiveEntry.isDirectory() || zipArchiveEntry.isUnixSymlink()) {
            return;
        }
        this.normalizeTimestampsAndPermissions(zipArchiveEntry);
        zipArchiveEntry.setMethod(this.compressionMethod);
        this.directories.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)EMPTY_SUPPLIER));
    }

    private void addEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier streamSupplier) throws IOException {
        this.normalizeTimestampsAndPermissions(zipArchiveEntry);
        zipArchiveEntry.setMethod(this.compressionMethod);
        if (zipArchiveEntry.isDirectory() && !zipArchiveEntry.isUnixSymlink()) {
            this.directories.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)streamSupplier));
        } else {
            this.scatterZipCreator.addArchiveEntry(zipArchiveEntry, streamSupplier);
        }
    }

    private static byte[] joinWithNewlines(List<byte[]> lines) {
        Object object;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (byte[] line : lines) {
                out.write(line);
                out.write(10);
            }
            object = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error joining byte arrays", e);
            }
        }
        out.close();
        return object;
    }

    private static InputStreamSupplier toInputStreamSupplier(byte[] data) {
        return () -> new ByteArrayInputStream(data);
    }

    private static InputStreamSupplier toInputStreamSupplier(Path path) {
        return () -> {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private void normalizeTimestampsAndPermissions(ZipArchiveEntry archiveEntry) {
        if (this.entryTimestamp == null) {
            return;
        }
        archiveEntry.setTime(this.entryTimestamp.toMillis());
        archiveEntry.setCreationTime(this.entryTimestamp);
        archiveEntry.setLastModifiedTime(this.entryTimestamp);
        archiveEntry.setLastAccessTime(this.entryTimestamp);
        if (archiveEntry.isDirectory()) {
            archiveEntry.setUnixMode(16877);
        } else {
            archiveEntry.setUnixMode(33188);
        }
    }

    @Override
    public void close() {
        try (ZipArchiveOutputStream zipArchiveOutputStream = this.archive;){
            if (this.manifest != null) {
                ZipArchiveEntry metaInfArchiveEntry = new ZipArchiveEntry("META-INF/");
                this.normalizeTimestampsAndPermissions(metaInfArchiveEntry);
                this.archive.putArchiveEntry(metaInfArchiveEntry);
                this.archive.closeArchiveEntry();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.manifest.write(baos);
                byte[] manifestBytes = baos.toByteArray();
                ZipArchiveEntry manifestEntry = new ZipArchiveEntry("META-INF/MANIFEST.MF");
                this.normalizeTimestampsAndPermissions(manifestEntry);
                manifestEntry.setSize((long)manifestBytes.length);
                this.archive.putArchiveEntry(manifestEntry);
                this.archive.write(manifestBytes);
                this.archive.closeArchiveEntry();
            }
            this.directories.writeTo(this.archive);
            this.directories.close();
            this.scatterZipCreator.writeTo(this.archive);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Unable to create archive: " + String.valueOf(this.archivePath), e);
        }
        try {
            Files.deleteIfExists(this.tempDirectory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DoNotShutdownDelegatingExecutorService
    implements ExecutorService {
        private final ExecutorService delegate;

        private DoNotShutdownDelegatingExecutorService(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return List.of();
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.delegate.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }
}

