/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class ConfigChangeRecorder {
    private static final Logger log = Logger.getLogger(ConfigChangeRecorder.class);

    public void handleConfigChange(Map<String, String> buildTimeConfig) {
        Config configProvider = ConfigProvider.getConfig();
        for (Map.Entry<String, String> entry : buildTimeConfig.entrySet()) {
            Optional val = configProvider.getOptionalValue(entry.getKey(), String.class);
            if (!val.isPresent() || ((String)val.get()).equals(entry.getValue())) continue;
            log.warn((Object)("Build time property cannot be changed at runtime. " + entry.getKey() + " was " + entry.getValue() + " at build time and is now " + (String)val.get()));
        }
    }
}

